/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search;

import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.management.profile.AzureProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.AzureConfigurable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.HttpPipelineProvider;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.fluent.SearchManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.implementation.SearchManagementClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.implementation.SearchServicesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.SearchServices;
import java.util.Objects;

public final class SearchServiceManager
extends Manager<SearchManagementClient> {
    private SearchServices searchServices;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static SearchServiceManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return SearchServiceManager.authenticate(HttpPipelineProvider.buildHttpPipeline(credential, profile), profile);
    }

    public static SearchServiceManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new SearchServiceManager(httpPipeline, profile);
    }

    private SearchServiceManager(HttpPipeline httpPipeline, AzureProfile profile) {
        super(httpPipeline, profile, new SearchManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).buildClient());
    }

    public SearchServices searchServices() {
        if (this.searchServices == null) {
            this.searchServices = new SearchServicesImpl(this);
        }
        return this.searchServices;
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public SearchServiceManager authenticate(TokenCredential credential, AzureProfile profile) {
            return SearchServiceManager.authenticate(this.buildHttpPipeline(credential, profile), profile);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public SearchServiceManager authenticate(TokenCredential var1, AzureProfile var2);
    }
}

