/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.SearchServiceManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.fluent.SearchManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.fluent.models.SearchServiceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.implementation.AdminKeysImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.implementation.QueryKeyImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.implementation.SearchServiceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.AdminKeyKind;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.AdminKeys;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.CheckNameAvailabilityInput;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.CheckNameAvailabilityOutput;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.QueryKey;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.SearchService;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.search.models.SearchServices;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public class SearchServicesImpl
extends GroupableResourcesImpl<SearchService, SearchServiceImpl, SearchServiceInner, SearchManagementClient, SearchServiceManager>
implements SearchServices {
    public SearchServicesImpl(SearchServiceManager searchManager) {
        super((SearchManagementClient)searchManager.serviceClient(), searchManager);
    }

    @Override
    protected Mono<SearchServiceInner> getInnerAsync(String resourceGroupName, String name) {
        return ((SearchManagementClient)this.inner()).getServices().getByResourceGroupAsync(resourceGroupName, name);
    }

    @Override
    protected Mono<Void> deleteInnerAsync(String resourceGroupName, String name) {
        return ((SearchManagementClient)this.inner()).getServices().deleteAsync(resourceGroupName, name);
    }

    @Override
    protected SearchServiceImpl wrapModel(String name) {
        SearchServiceInner inner = new SearchServiceInner();
        return new SearchServiceImpl(name, inner, (SearchServiceManager)this.manager());
    }

    @Override
    protected SearchServiceImpl wrapModel(SearchServiceInner inner) {
        if (inner == null) {
            return null;
        }
        return new SearchServiceImpl(inner.name(), inner, (SearchServiceManager)this.manager());
    }

    @Override
    public CheckNameAvailabilityOutput checkNameAvailability(String name) {
        return this.checkNameAvailabilityAsync(name).block();
    }

    @Override
    public Mono<CheckNameAvailabilityOutput> checkNameAvailabilityAsync(String name) {
        return ((SearchManagementClient)this.inner()).getServices().checkNameAvailabilityAsync(new CheckNameAvailabilityInput().withName(name));
    }

    @Override
    public AdminKeys getAdminKeys(String resourceGroupName, String searchServiceName) {
        return this.getAdminKeysAsync(resourceGroupName, searchServiceName).block();
    }

    @Override
    public Mono<AdminKeys> getAdminKeysAsync(String resourceGroupName, String searchServiceName) {
        return ((SearchManagementClient)this.inner()).getAdminKeys().getAsync(resourceGroupName, searchServiceName).map(AdminKeysImpl::new);
    }

    @Override
    public PagedIterable<QueryKey> listQueryKeys(String resourceGroupName, String searchServiceName) {
        return new PagedIterable<QueryKey>(this.listQueryKeysAsync(resourceGroupName, searchServiceName));
    }

    @Override
    public PagedFlux<QueryKey> listQueryKeysAsync(String resourceGroupName, String searchServiceName) {
        return PagedConverter.mapPage(((SearchManagementClient)this.inner()).getQueryKeys().listBySearchServiceAsync(resourceGroupName, searchServiceName), QueryKeyImpl::new);
    }

    @Override
    public AdminKeys regenerateAdminKeys(String resourceGroupName, String searchServiceName, AdminKeyKind keyKind) {
        return this.regenerateAdminKeysAsync(resourceGroupName, searchServiceName, keyKind).block();
    }

    @Override
    public Mono<AdminKeys> regenerateAdminKeysAsync(String resourceGroupName, String searchServiceName, AdminKeyKind keyKind) {
        return ((SearchManagementClient)this.inner()).getAdminKeys().regenerateAsync(resourceGroupName, searchServiceName, keyKind).map(AdminKeysImpl::new);
    }

    @Override
    public QueryKey createQueryKey(String resourceGroupName, String searchServiceName, String name) {
        return this.createQueryKeyAsync(resourceGroupName, searchServiceName, name).block();
    }

    @Override
    public Mono<QueryKey> createQueryKeyAsync(String resourceGroupName, String searchServiceName, String name) {
        return ((SearchManagementClient)this.inner()).getQueryKeys().createAsync(resourceGroupName, searchServiceName, name).map(QueryKeyImpl::new);
    }

    @Override
    public void deleteQueryKey(String resourceGroupName, String searchServiceName, String key) {
        this.deleteQueryKeyAsync(resourceGroupName, searchServiceName, key).block();
    }

    @Override
    public Mono<Void> deleteQueryKeyAsync(String resourceGroupName, String searchServiceName, String key) {
        return ((SearchManagementClient)this.inner()).getQueryKeys().deleteAsync(resourceGroupName, searchServiceName, key);
    }

    @Override
    public PagedIterable<SearchService> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable<SearchService>(this.listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    public PagedFlux<SearchService> listByResourceGroupAsync(String resourceGroupName) {
        if (CoreUtils.isNullOrEmpty(resourceGroupName)) {
            return new PagedFlux<SearchService>(() -> Mono.error(new IllegalArgumentException("Parameter 'resourceGroupName' is required and cannot be null.")));
        }
        return PagedConverter.mapPage(((SearchManagementClient)this.inner()).getServices().listByResourceGroupAsync(resourceGroupName), this::wrapModel);
    }

    @Override
    public SearchServiceImpl define(String name) {
        return this.wrapModel(name);
    }

    @Override
    public PagedIterable<SearchService> list() {
        return new PagedIterable<SearchService>(this.listAsync());
    }

    @Override
    public PagedFlux<SearchService> listAsync() {
        return PagedConverter.mapPage(((SearchManagementClient)this.inner()).getServices().listAsync(), this::wrapModel);
    }
}

