/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ServerKeyType;
import java.io.IOException;

public final class EncryptionProtectorProperties
implements JsonSerializable<EncryptionProtectorProperties> {
    private String subregion;
    private String serverKeyName;
    private ServerKeyType serverKeyType;
    private String uri;
    private String thumbprint;
    private Boolean autoRotationEnabled;
    private static final ClientLogger LOGGER = new ClientLogger(EncryptionProtectorProperties.class);

    public String subregion() {
        return this.subregion;
    }

    public String serverKeyName() {
        return this.serverKeyName;
    }

    public EncryptionProtectorProperties withServerKeyName(String serverKeyName) {
        this.serverKeyName = serverKeyName;
        return this;
    }

    public ServerKeyType serverKeyType() {
        return this.serverKeyType;
    }

    public EncryptionProtectorProperties withServerKeyType(ServerKeyType serverKeyType) {
        this.serverKeyType = serverKeyType;
        return this;
    }

    public String uri() {
        return this.uri;
    }

    public String thumbprint() {
        return this.thumbprint;
    }

    public Boolean autoRotationEnabled() {
        return this.autoRotationEnabled;
    }

    public EncryptionProtectorProperties withAutoRotationEnabled(Boolean autoRotationEnabled) {
        this.autoRotationEnabled = autoRotationEnabled;
        return this;
    }

    public void validate() {
        if (this.serverKeyType() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property serverKeyType in model EncryptionProtectorProperties"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serverKeyType", this.serverKeyType == null ? null : this.serverKeyType.toString());
        jsonWriter.writeStringField("serverKeyName", this.serverKeyName);
        jsonWriter.writeBooleanField("autoRotationEnabled", this.autoRotationEnabled);
        return jsonWriter.writeEndObject();
    }

    public static EncryptionProtectorProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EncryptionProtectorProperties deserializedEncryptionProtectorProperties = new EncryptionProtectorProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serverKeyType".equals(fieldName)) {
                    deserializedEncryptionProtectorProperties.serverKeyType = ServerKeyType.fromString(reader.getString());
                    continue;
                }
                if ("subregion".equals(fieldName)) {
                    deserializedEncryptionProtectorProperties.subregion = reader.getString();
                    continue;
                }
                if ("serverKeyName".equals(fieldName)) {
                    deserializedEncryptionProtectorProperties.serverKeyName = reader.getString();
                    continue;
                }
                if ("uri".equals(fieldName)) {
                    deserializedEncryptionProtectorProperties.uri = reader.getString();
                    continue;
                }
                if ("thumbprint".equals(fieldName)) {
                    deserializedEncryptionProtectorProperties.thumbprint = reader.getString();
                    continue;
                }
                if ("autoRotationEnabled".equals(fieldName)) {
                    deserializedEncryptionProtectorProperties.autoRotationEnabled = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEncryptionProtectorProperties;
        });
    }
}

