/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ManagedInstanceAdministratorType;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;

public final class ManagedInstanceAdministratorProperties
implements JsonSerializable<ManagedInstanceAdministratorProperties> {
    private ManagedInstanceAdministratorType administratorType;
    private String login;
    private UUID sid;
    private UUID tenantId;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedInstanceAdministratorProperties.class);

    public ManagedInstanceAdministratorType administratorType() {
        return this.administratorType;
    }

    public ManagedInstanceAdministratorProperties withAdministratorType(ManagedInstanceAdministratorType administratorType) {
        this.administratorType = administratorType;
        return this;
    }

    public String login() {
        return this.login;
    }

    public ManagedInstanceAdministratorProperties withLogin(String login) {
        this.login = login;
        return this;
    }

    public UUID sid() {
        return this.sid;
    }

    public ManagedInstanceAdministratorProperties withSid(UUID sid) {
        this.sid = sid;
        return this;
    }

    public UUID tenantId() {
        return this.tenantId;
    }

    public ManagedInstanceAdministratorProperties withTenantId(UUID tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public void validate() {
        if (this.administratorType() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property administratorType in model ManagedInstanceAdministratorProperties"));
        }
        if (this.login() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property login in model ManagedInstanceAdministratorProperties"));
        }
        if (this.sid() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property sid in model ManagedInstanceAdministratorProperties"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("administratorType", this.administratorType == null ? null : this.administratorType.toString());
        jsonWriter.writeStringField("login", this.login);
        jsonWriter.writeStringField("sid", Objects.toString(this.sid, null));
        jsonWriter.writeStringField("tenantId", Objects.toString(this.tenantId, null));
        return jsonWriter.writeEndObject();
    }

    public static ManagedInstanceAdministratorProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedInstanceAdministratorProperties deserializedManagedInstanceAdministratorProperties = new ManagedInstanceAdministratorProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("administratorType".equals(fieldName)) {
                    deserializedManagedInstanceAdministratorProperties.administratorType = ManagedInstanceAdministratorType.fromString(reader.getString());
                    continue;
                }
                if ("login".equals(fieldName)) {
                    deserializedManagedInstanceAdministratorProperties.login = reader.getString();
                    continue;
                }
                if ("sid".equals(fieldName)) {
                    deserializedManagedInstanceAdministratorProperties.sid = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedManagedInstanceAdministratorProperties.tenantId = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedInstanceAdministratorProperties;
        });
    }
}

