/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ManagementOperationState;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ServerOperationProperties
implements JsonSerializable<ServerOperationProperties> {
    private String operation;
    private String operationFriendlyName;
    private Integer percentComplete;
    private String serverName;
    private OffsetDateTime startTime;
    private ManagementOperationState state;
    private Integer errorCode;
    private String errorDescription;
    private Integer errorSeverity;
    private Boolean isUserError;
    private OffsetDateTime estimatedCompletionTime;
    private String description;
    private Boolean isCancellable;

    public String operation() {
        return this.operation;
    }

    public String operationFriendlyName() {
        return this.operationFriendlyName;
    }

    public Integer percentComplete() {
        return this.percentComplete;
    }

    public String serverName() {
        return this.serverName;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public ManagementOperationState state() {
        return this.state;
    }

    public Integer errorCode() {
        return this.errorCode;
    }

    public String errorDescription() {
        return this.errorDescription;
    }

    public Integer errorSeverity() {
        return this.errorSeverity;
    }

    public Boolean isUserError() {
        return this.isUserError;
    }

    public OffsetDateTime estimatedCompletionTime() {
        return this.estimatedCompletionTime;
    }

    public String description() {
        return this.description;
    }

    public Boolean isCancellable() {
        return this.isCancellable;
    }

    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ServerOperationProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ServerOperationProperties deserializedServerOperationProperties = new ServerOperationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operation".equals(fieldName)) {
                    deserializedServerOperationProperties.operation = reader.getString();
                    continue;
                }
                if ("operationFriendlyName".equals(fieldName)) {
                    deserializedServerOperationProperties.operationFriendlyName = reader.getString();
                    continue;
                }
                if ("percentComplete".equals(fieldName)) {
                    deserializedServerOperationProperties.percentComplete = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("serverName".equals(fieldName)) {
                    deserializedServerOperationProperties.serverName = reader.getString();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedServerOperationProperties.startTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedServerOperationProperties.state = ManagementOperationState.fromString(reader.getString());
                    continue;
                }
                if ("errorCode".equals(fieldName)) {
                    deserializedServerOperationProperties.errorCode = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("errorDescription".equals(fieldName)) {
                    deserializedServerOperationProperties.errorDescription = reader.getString();
                    continue;
                }
                if ("errorSeverity".equals(fieldName)) {
                    deserializedServerOperationProperties.errorSeverity = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("isUserError".equals(fieldName)) {
                    deserializedServerOperationProperties.isUserError = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("estimatedCompletionTime".equals(fieldName)) {
                    deserializedServerOperationProperties.estimatedCompletionTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedServerOperationProperties.description = reader.getString();
                    continue;
                }
                if ("isCancellable".equals(fieldName)) {
                    deserializedServerOperationProperties.isCancellable = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerOperationProperties;
        });
    }
}

