/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Post;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Put;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.management.polling.PollResult;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollerFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.SyncPoller;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.JobExecutionsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.JobExecutionInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.JobExecutionListResult;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.time.OffsetDateTime;
import java.util.UUID;

public final class JobExecutionsClientImpl
implements JobExecutionsClient {
    private final JobExecutionsService service;
    private final SqlManagementClientImpl client;

    JobExecutionsClientImpl(SqlManagementClientImpl client) {
        this.service = RestProxy.create(JobExecutionsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JobExecutionInner>> listByAgentSinglePageAsync(String resourceGroupName, String serverName, String jobAgentName, OffsetDateTime createTimeMin, OffsetDateTime createTimeMax, OffsetDateTime endTimeMin, OffsetDateTime endTimeMax, Boolean isActive, Long skip, Long top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByAgent(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, JobExecutionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobExecutionListResult)res.getValue()).value(), ((JobExecutionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JobExecutionInner>> listByAgentSinglePageAsync(String resourceGroupName, String serverName, String jobAgentName, OffsetDateTime createTimeMin, OffsetDateTime createTimeMax, OffsetDateTime endTimeMin, OffsetDateTime endTimeMax, Boolean isActive, Long skip, Long top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByAgent(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase<Object, JobExecutionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobExecutionListResult)res.getValue()).value(), ((JobExecutionListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<JobExecutionInner> listByAgentAsync(String resourceGroupName, String serverName, String jobAgentName, OffsetDateTime createTimeMin, OffsetDateTime createTimeMax, OffsetDateTime endTimeMin, OffsetDateTime endTimeMax, Boolean isActive, Long skip, Long top) {
        return new PagedFlux<JobExecutionInner>(() -> this.listByAgentSinglePageAsync(resourceGroupName, serverName, jobAgentName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top), nextLink -> this.listByAgentNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<JobExecutionInner> listByAgentAsync(String resourceGroupName, String serverName, String jobAgentName) {
        OffsetDateTime createTimeMin = null;
        OffsetDateTime createTimeMax = null;
        OffsetDateTime endTimeMin = null;
        OffsetDateTime endTimeMax = null;
        Boolean isActive = null;
        Long skip = null;
        Long top = null;
        return new PagedFlux<JobExecutionInner>(() -> this.listByAgentSinglePageAsync(resourceGroupName, serverName, jobAgentName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top), nextLink -> this.listByAgentNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<JobExecutionInner> listByAgentAsync(String resourceGroupName, String serverName, String jobAgentName, OffsetDateTime createTimeMin, OffsetDateTime createTimeMax, OffsetDateTime endTimeMin, OffsetDateTime endTimeMax, Boolean isActive, Long skip, Long top, Context context) {
        return new PagedFlux<JobExecutionInner>(() -> this.listByAgentSinglePageAsync(resourceGroupName, serverName, jobAgentName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top, context), nextLink -> this.listByAgentNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<JobExecutionInner> listByAgent(String resourceGroupName, String serverName, String jobAgentName) {
        OffsetDateTime createTimeMin = null;
        OffsetDateTime createTimeMax = null;
        OffsetDateTime endTimeMin = null;
        OffsetDateTime endTimeMax = null;
        Boolean isActive = null;
        Long skip = null;
        Long top = null;
        return new PagedIterable<JobExecutionInner>(this.listByAgentAsync(resourceGroupName, serverName, jobAgentName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<JobExecutionInner> listByAgent(String resourceGroupName, String serverName, String jobAgentName, OffsetDateTime createTimeMin, OffsetDateTime createTimeMax, OffsetDateTime endTimeMin, OffsetDateTime endTimeMax, Boolean isActive, Long skip, Long top, Context context) {
        return new PagedIterable<JobExecutionInner>(this.listByAgentAsync(resourceGroupName, serverName, jobAgentName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JobExecutionInner>> listByJobSinglePageAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, OffsetDateTime createTimeMin, OffsetDateTime createTimeMax, OffsetDateTime endTimeMin, OffsetDateTime endTimeMax, Boolean isActive, Long skip, Long top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByJob(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, jobName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, JobExecutionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobExecutionListResult)res.getValue()).value(), ((JobExecutionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JobExecutionInner>> listByJobSinglePageAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, OffsetDateTime createTimeMin, OffsetDateTime createTimeMax, OffsetDateTime endTimeMin, OffsetDateTime endTimeMax, Boolean isActive, Long skip, Long top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByJob(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, jobName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase<Object, JobExecutionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobExecutionListResult)res.getValue()).value(), ((JobExecutionListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<JobExecutionInner> listByJobAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, OffsetDateTime createTimeMin, OffsetDateTime createTimeMax, OffsetDateTime endTimeMin, OffsetDateTime endTimeMax, Boolean isActive, Long skip, Long top) {
        return new PagedFlux<JobExecutionInner>(() -> this.listByJobSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top), nextLink -> this.listByJobNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<JobExecutionInner> listByJobAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        OffsetDateTime createTimeMin = null;
        OffsetDateTime createTimeMax = null;
        OffsetDateTime endTimeMin = null;
        OffsetDateTime endTimeMax = null;
        Boolean isActive = null;
        Long skip = null;
        Long top = null;
        return new PagedFlux<JobExecutionInner>(() -> this.listByJobSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top), nextLink -> this.listByJobNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<JobExecutionInner> listByJobAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, OffsetDateTime createTimeMin, OffsetDateTime createTimeMax, OffsetDateTime endTimeMin, OffsetDateTime endTimeMax, Boolean isActive, Long skip, Long top, Context context) {
        return new PagedFlux<JobExecutionInner>(() -> this.listByJobSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top, context), nextLink -> this.listByJobNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<JobExecutionInner> listByJob(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        OffsetDateTime createTimeMin = null;
        OffsetDateTime createTimeMax = null;
        OffsetDateTime endTimeMin = null;
        OffsetDateTime endTimeMax = null;
        Boolean isActive = null;
        Long skip = null;
        Long top = null;
        return new PagedIterable<JobExecutionInner>(this.listByJobAsync(resourceGroupName, serverName, jobAgentName, jobName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<JobExecutionInner> listByJob(String resourceGroupName, String serverName, String jobAgentName, String jobName, OffsetDateTime createTimeMin, OffsetDateTime createTimeMax, OffsetDateTime endTimeMin, OffsetDateTime endTimeMax, Boolean isActive, Long skip, Long top, Context context) {
        return new PagedIterable<JobExecutionInner>(this.listByJobAsync(resourceGroupName, serverName, jobAgentName, jobName, createTimeMin, createTimeMax, endTimeMin, endTimeMax, isActive, skip, top, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<JobExecutionInner>> getWithResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (jobExecutionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobExecutionId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<JobExecutionInner>> getWithResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (jobExecutionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobExecutionId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<JobExecutionInner> getAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        return this.getWithResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId).flatMap(res -> Mono.justOrEmpty((JobExecutionInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<JobExecutionInner> getWithResponse(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, Context context) {
        return this.getWithResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public JobExecutionInner get(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        return this.getWithResponse(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (jobExecutionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobExecutionId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (jobExecutionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobExecutionId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<JobExecutionInner>, JobExecutionInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)JobExecutionInner.class), (Type)((Object)JobExecutionInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<JobExecutionInner>, JobExecutionInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)JobExecutionInner.class), (Type)((Object)JobExecutionInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<JobExecutionInner>, JobExecutionInner> beginCreateOrUpdate(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<JobExecutionInner>, JobExecutionInner> beginCreateOrUpdate(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<JobExecutionInner> createOrUpdateAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<JobExecutionInner> createOrUpdateAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public JobExecutionInner createOrUpdate(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        return this.createOrUpdateAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public JobExecutionInner createOrUpdate(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, Context context) {
        return this.createOrUpdateAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelWithResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (jobExecutionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobExecutionId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.cancel(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, this.client.getSubscriptionId(), this.client.getApiVersion(), (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> cancelWithResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (jobExecutionId == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobExecutionId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.cancel(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, this.client.getSubscriptionId(), this.client.getApiVersion(), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        return this.cancelWithResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> cancelWithResponse(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId, Context context) {
        return this.cancelWithResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancel(String resourceGroupName, String serverName, String jobAgentName, String jobName, UUID jobExecutionId) {
        this.cancelWithResponse(resourceGroupName, serverName, jobAgentName, jobName, jobExecutionId, Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, jobName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (jobAgentName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobAgentName is required and cannot be null."));
        }
        if (jobName == null) {
            return Mono.error(new IllegalArgumentException("Parameter jobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), resourceGroupName, serverName, jobAgentName, jobName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<JobExecutionInner>, JobExecutionInner> beginCreateAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, serverName, jobAgentName, jobName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)JobExecutionInner.class), (Type)((Object)JobExecutionInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<JobExecutionInner>, JobExecutionInner> beginCreateAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)JobExecutionInner.class), (Type)((Object)JobExecutionInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<JobExecutionInner>, JobExecutionInner> beginCreate(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        return this.beginCreateAsync(resourceGroupName, serverName, jobAgentName, jobName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<JobExecutionInner>, JobExecutionInner> beginCreate(String resourceGroupName, String serverName, String jobAgentName, String jobName, Context context) {
        return this.beginCreateAsync(resourceGroupName, serverName, jobAgentName, jobName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<JobExecutionInner> createAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        return this.beginCreateAsync(resourceGroupName, serverName, jobAgentName, jobName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<JobExecutionInner> createAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, Context context) {
        return this.beginCreateAsync(resourceGroupName, serverName, jobAgentName, jobName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public JobExecutionInner create(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        return this.createAsync(resourceGroupName, serverName, jobAgentName, jobName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public JobExecutionInner create(String resourceGroupName, String serverName, String jobAgentName, String jobName, Context context) {
        return this.createAsync(resourceGroupName, serverName, jobAgentName, jobName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JobExecutionInner>> listByAgentNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByAgentNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, JobExecutionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobExecutionListResult)res.getValue()).value(), ((JobExecutionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JobExecutionInner>> listByAgentNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByAgentNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, JobExecutionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobExecutionListResult)res.getValue()).value(), ((JobExecutionListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JobExecutionInner>> listByJobNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByJobNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, JobExecutionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobExecutionListResult)res.getValue()).value(), ((JobExecutionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<JobExecutionInner>> listByJobNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByJobNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, JobExecutionInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((JobExecutionListResult)res.getValue()).value(), ((JobExecutionListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientJ")
    public static interface JobExecutionsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/executions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JobExecutionListResult>> listByAgent(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="jobAgentName") String var4, @QueryParam(value="createTimeMin") OffsetDateTime var5, @QueryParam(value="createTimeMax") OffsetDateTime var6, @QueryParam(value="endTimeMin") OffsetDateTime var7, @QueryParam(value="endTimeMax") OffsetDateTime var8, @QueryParam(value="isActive") Boolean var9, @QueryParam(value="$skip") Long var10, @QueryParam(value="$top") Long var11, @PathParam(value="subscriptionId") String var12, @QueryParam(value="api-version") String var13, @HeaderParam(value="Accept") String var14, Context var15);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JobExecutionListResult>> listByJob(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="jobAgentName") String var4, @PathParam(value="jobName") String var5, @QueryParam(value="createTimeMin") OffsetDateTime var6, @QueryParam(value="createTimeMax") OffsetDateTime var7, @QueryParam(value="endTimeMin") OffsetDateTime var8, @QueryParam(value="endTimeMax") OffsetDateTime var9, @QueryParam(value="isActive") Boolean var10, @QueryParam(value="$skip") Long var11, @QueryParam(value="$top") Long var12, @PathParam(value="subscriptionId") String var13, @QueryParam(value="api-version") String var14, @HeaderParam(value="Accept") String var15, Context var16);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions/{jobExecutionId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JobExecutionInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="jobAgentName") String var4, @PathParam(value="jobName") String var5, @PathParam(value="jobExecutionId") UUID var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions/{jobExecutionId}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="jobAgentName") String var4, @PathParam(value="jobName") String var5, @PathParam(value="jobExecutionId") UUID var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/executions/{jobExecutionId}/cancel")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> cancel(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="jobAgentName") String var4, @PathParam(value="jobName") String var5, @PathParam(value="jobExecutionId") UUID var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/start")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="serverName") String var3, @PathParam(value="jobAgentName") String var4, @PathParam(value="jobName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JobExecutionListResult>> listByAgentNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<JobExecutionListResult>> listByJobNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

