/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.model.implementation.RefreshableWrapperImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.SqlServerManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.ReplicationLinkInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ReplicationLink;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ReplicationRole;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ReplicationState;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.time.OffsetDateTime;

class ReplicationLinkImpl
extends RefreshableWrapperImpl<ReplicationLinkInner, ReplicationLink>
implements ReplicationLink {
    private final String sqlServerName;
    private final String resourceGroupName;
    private final SqlServerManager sqlServerManager;
    private final ResourceId resourceId;

    protected ReplicationLinkImpl(String resourceGroupName, String sqlServerName, ReplicationLinkInner innerObject, SqlServerManager sqlServerManager) {
        super(innerObject);
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.sqlServerManager = sqlServerManager;
        this.resourceId = ResourceId.fromString(((ReplicationLinkInner)this.innerModel()).id());
    }

    @Override
    protected Mono<ReplicationLinkInner> getInnerAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getReplicationLinks().getAsync(this.resourceGroupName, this.sqlServerName, this.databaseName(), this.name());
    }

    @Override
    public String sqlServerName() {
        return this.sqlServerName;
    }

    @Override
    public String databaseName() {
        return this.resourceId.parent().name();
    }

    @Override
    public String partnerServer() {
        return ((ReplicationLinkInner)this.innerModel()).partnerServer();
    }

    @Override
    public String partnerDatabase() {
        return ((ReplicationLinkInner)this.innerModel()).partnerDatabase();
    }

    @Override
    public String partnerLocation() {
        return ((ReplicationLinkInner)this.innerModel()).partnerLocation();
    }

    @Override
    public ReplicationRole role() {
        return ((ReplicationLinkInner)this.innerModel()).role();
    }

    @Override
    public ReplicationRole partnerRole() {
        return ((ReplicationLinkInner)this.innerModel()).partnerRole();
    }

    @Override
    public OffsetDateTime startTime() {
        return ((ReplicationLinkInner)this.innerModel()).startTime();
    }

    @Override
    public int percentComplete() {
        return ResourceManagerUtils.toPrimitiveInt(((ReplicationLinkInner)this.innerModel()).percentComplete());
    }

    @Override
    public ReplicationState replicationState() {
        return ((ReplicationLinkInner)this.innerModel()).replicationState();
    }

    @Override
    public boolean isTerminationAllowed() {
        return ((ReplicationLinkInner)this.innerModel()).isTerminationAllowed();
    }

    @Override
    public String replicationMode() {
        return ((ReplicationLinkInner)this.innerModel()).replicationMode();
    }

    @Override
    public void delete() {
        ((SqlManagementClient)this.sqlServerManager.serviceClient()).getReplicationLinks().delete(this.resourceGroupName, this.sqlServerName, this.databaseName(), this.name());
    }

    @Override
    public void failover() {
        ((SqlManagementClient)this.sqlServerManager.serviceClient()).getReplicationLinks().failover(this.resourceGroupName, this.sqlServerName, this.databaseName(), this.name());
    }

    @Override
    public Mono<Void> failoverAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getReplicationLinks().failoverAsync(this.resourceGroupName, this.sqlServerName, this.databaseName(), this.name()).then();
    }

    @Override
    public void forceFailoverAllowDataLoss() {
        ((SqlManagementClient)this.sqlServerManager.serviceClient()).getReplicationLinks().failoverAllowDataLoss(this.resourceGroupName, this.sqlServerName, this.databaseName(), this.name());
    }

    @Override
    public Mono<Void> forceFailoverAllowDataLossAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getReplicationLinks().failoverAllowDataLossAsync(this.resourceGroupName, this.sqlServerName, this.databaseName(), this.name()).then();
    }

    @Override
    public String name() {
        return ((ReplicationLinkInner)this.innerModel()).name();
    }

    @Override
    public String id() {
        return ((ReplicationLinkInner)this.innerModel()).id();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }
}

