/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Region;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.SqlServerManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.FirewallRuleInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlServerImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlFirewallRule;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlFirewallRuleOperations;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlServer;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Objects;

public class SqlFirewallRuleImpl
extends ExternalChildResourceImpl<SqlFirewallRule, FirewallRuleInner, SqlServerImpl, SqlServer>
implements SqlFirewallRule,
SqlFirewallRule.SqlFirewallRuleDefinition<SqlServerImpl>,
SqlFirewallRule.Update,
SqlFirewallRuleOperations.SqlFirewallRuleOperationsDefinition {
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;

    SqlFirewallRuleImpl(String name, SqlServerImpl parent, FirewallRuleInner innerObject, SqlServerManager sqlServerManager) {
        super(name, parent, innerObject);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName();
        this.sqlServerName = parent.name();
    }

    SqlFirewallRuleImpl(String resourceGroupName, String sqlServerName, String name, FirewallRuleInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
    }

    SqlFirewallRuleImpl(String name, FirewallRuleInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
    }

    @Override
    protected Mono<FirewallRuleInner> getInnerAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getFirewallRules().getAsync(this.resourceGroupName, this.sqlServerName, this.name());
    }

    @Override
    public SqlFirewallRuleImpl update() {
        super.prepareUpdate();
        return this;
    }

    @Override
    public String id() {
        return ((FirewallRuleInner)this.innerModel()).id();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public String sqlServerName() {
        return this.sqlServerName;
    }

    @Override
    public String startIpAddress() {
        return ((FirewallRuleInner)this.innerModel()).startIpAddress();
    }

    @Override
    public String endIpAddress() {
        return ((FirewallRuleInner)this.innerModel()).endIpAddress();
    }

    @Override
    public String kind() {
        if (this.parent() != null) {
            return ((SqlServerImpl)this.parent()).name();
        }
        return ((SqlServer)this.sqlServerManager.sqlServers().getById(this.parentId())).kind();
    }

    @Override
    public Region region() {
        if (this.parent() != null) {
            return Region.fromName(((SqlServerImpl)this.parent()).regionName());
        }
        return Region.fromName(((SqlServer)this.sqlServerManager.sqlServers().getById(this.parentId())).regionName());
    }

    @Override
    public void delete() {
        this.deleteResourceAsync().block();
    }

    @Override
    public Mono<Void> deleteAsync() {
        return this.deleteResourceAsync();
    }

    @Override
    public String parentId() {
        return ResourceUtils.parentResourceIdFromResourceId(this.id());
    }

    @Override
    public Mono<SqlFirewallRule> createResourceAsync() {
        SqlFirewallRuleImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getFirewallRules().createOrUpdateAsync(this.resourceGroupName, this.sqlServerName, this.name(), (FirewallRuleInner)this.innerModel()).map(inner -> {
            self.setInner(inner);
            return self;
        });
    }

    @Override
    public Mono<SqlFirewallRule> updateResourceAsync() {
        SqlFirewallRuleImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getFirewallRules().createOrUpdateAsync(this.resourceGroupName, this.sqlServerName, this.name(), (FirewallRuleInner)this.innerModel()).map(inner -> {
            self.setInner(inner);
            return self;
        });
    }

    @Override
    public Mono<Void> deleteResourceAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getFirewallRules().deleteAsync(this.resourceGroupName, this.sqlServerName, this.name());
    }

    @Override
    public SqlFirewallRuleImpl withStartIpAddress(String startIpAddress) {
        ((FirewallRuleInner)this.innerModel()).withStartIpAddress(startIpAddress);
        return this;
    }

    @Override
    public SqlFirewallRuleImpl withEndIpAddress(String endIpAddress) {
        ((FirewallRuleInner)this.innerModel()).withEndIpAddress(endIpAddress);
        return this;
    }

    @Override
    public SqlFirewallRuleImpl withExistingSqlServer(String resourceGroupName, String sqlServerName) {
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        return this;
    }

    @Override
    public SqlFirewallRuleImpl withExistingSqlServer(SqlServer sqlServer) {
        this.resourceGroupName = sqlServer.resourceGroupName();
        this.sqlServerName = sqlServer.name();
        return this;
    }

    @Override
    public SqlFirewallRuleImpl withExistingSqlServerId(String sqlServerId) {
        Objects.requireNonNull(sqlServerId);
        ResourceId resourceId = ResourceId.fromString(sqlServerId);
        this.resourceGroupName = resourceId.resourceGroupName();
        this.sqlServerName = resourceId.name();
        return this;
    }

    @Override
    public SqlFirewallRuleImpl withIpAddressRange(String startIpAddress, String endIpAddress) {
        ((FirewallRuleInner)this.innerModel()).withStartIpAddress(startIpAddress);
        ((FirewallRuleInner)this.innerModel()).withEndIpAddress(endIpAddress);
        return this;
    }

    @Override
    public SqlFirewallRuleImpl withIpAddress(String ipAddress) {
        ((FirewallRuleInner)this.innerModel()).withStartIpAddress(ipAddress);
        ((FirewallRuleInner)this.innerModel()).withEndIpAddress(ipAddress);
        return this;
    }

    @Override
    public SqlServerImpl attach() {
        return (SqlServerImpl)this.parent();
    }
}

