/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.dag.FunctionalTaskItem;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.SqlServerManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.RestorableDroppedDatabaseInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.ServerAutomaticTuningInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.ServerAzureADAdministratorInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.ServerInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.ServerUsageInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.ServerMetricImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlActiveDirectoryAdministratorImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlDatabaseImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlDatabaseOperationsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlDatabasesAsExternalChildResourcesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlElasticPoolImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlElasticPoolOperationsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlElasticPoolsAsExternalChildResourcesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlEncryptionProtectorOperationsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlFailoverGroupOperationsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlFirewallRuleImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlFirewallRuleOperationsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlFirewallRulesAsExternalChildResourcesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlRestorableDroppedDatabaseImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlServerAutomaticTuningImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlServerDnsAliasOperationsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlServerKeyOperationsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlServerSecurityAlertPolicyOperationsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlVirtualNetworkRuleOperationsImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.implementation.SqlVirtualNetworkRulesAsExternalChildResourcesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.AdministratorName;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.AdministratorType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.IdentityType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ResourceIdentity;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ServerMetric;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ServerNetworkAccessFlag;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlDatabaseOperations;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlElasticPoolOperations;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlEncryptionProtectorOperations;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlFailoverGroupOperations;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlFirewallRule;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlFirewallRuleOperations;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlRestorableDroppedDatabase;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlServer;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlServerAutomaticTuning;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlServerDnsAliasOperations;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlServerKeyOperations;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlServerSecurityAlertPolicyOperations;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlVirtualNetworkRule;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.SqlVirtualNetworkRuleOperations;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class SqlServerImpl
extends GroupableResourceImpl<SqlServer, ServerInner, SqlServerImpl, SqlServerManager>
implements SqlServer,
SqlServer.Definition,
SqlServer.Update {
    private final ClientLogger logger = new ClientLogger(this.getClass());
    private FunctionalTaskItem sqlADAdminCreator = null;
    private boolean allowAzureServicesAccess = true;
    private SqlFirewallRulesAsExternalChildResourcesImpl sqlFirewallRules = new SqlFirewallRulesAsExternalChildResourcesImpl(this, "SqlFirewallRule");
    private SqlFirewallRuleOperations.SqlFirewallRuleActionsDefinition sqlFirewallRuleOperations;
    private SqlVirtualNetworkRulesAsExternalChildResourcesImpl sqlVirtualNetworkRules = new SqlVirtualNetworkRulesAsExternalChildResourcesImpl(this, "SqlVirtualNetworkRule");
    private SqlVirtualNetworkRuleOperations.SqlVirtualNetworkRuleActionsDefinition sqlVirtualNetworkRuleOperations;
    private SqlElasticPoolsAsExternalChildResourcesImpl sqlElasticPools = new SqlElasticPoolsAsExternalChildResourcesImpl(this, "SqlElasticPool");
    private SqlElasticPoolOperations.SqlElasticPoolActionsDefinition sqlElasticPoolOperations;
    private SqlDatabasesAsExternalChildResourcesImpl sqlDatabases = new SqlDatabasesAsExternalChildResourcesImpl(this, "SqlDatabase");
    private SqlDatabaseOperations.SqlDatabaseActionsDefinition sqlDatabaseOperations;
    private SqlServerDnsAliasOperations.SqlServerDnsAliasActionsDefinition sqlServerDnsAliasOperations;
    private SqlFailoverGroupOperations.SqlFailoverGroupActionsDefinition sqlFailoverGroupOperations;
    private SqlServerKeyOperations.SqlServerKeyActionsDefinition sqlServerKeyOperations;
    private SqlServerSecurityAlertPolicyOperationsImpl sqlServerSecurityAlertPolicyOperations;
    private SqlEncryptionProtectorOperations.SqlEncryptionProtectorActionsDefinition sqlEncryptionProtectorsOperations;

    protected SqlServerImpl(String name, ServerInner innerObject, SqlServerManager manager) {
        super(name, innerObject, manager);
    }

    @Override
    protected Mono<ServerInner> getInnerAsync() {
        return ((SqlManagementClient)((SqlServerManager)this.manager()).serviceClient()).getServers().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public Mono<SqlServer> createResourceAsync() {
        return ((SqlManagementClient)((SqlServerManager)this.manager()).serviceClient()).getServers().createOrUpdateAsync(this.resourceGroupName(), this.name(), (ServerInner)this.innerModel()).map(serverInner -> {
            this.setInner(serverInner);
            return this;
        });
    }

    @Override
    public void beforeGroupCreateOrUpdate() {
        if (this.isInCreateMode()) {
            if (this.allowAzureServicesAccess) {
                this.sqlFirewallRules.defineInlineFirewallRule("AllowAllWindowsAzureIps").withStartIpAddress("0.0.0.0").withEndIpAddress("0.0.0.0");
            }
            if (this.sqlADAdminCreator != null) {
                this.addPostRunDependent(this.sqlADAdminCreator);
            }
        }
        if (this.sqlElasticPools != null && this.sqlDatabases != null) {
            List<SqlDatabaseImpl> dbToBeRemoved = this.sqlDatabases.getChildren(ExternalChildResourceImpl.PendingOperation.ToBeRemoved);
            List<SqlElasticPoolImpl> epToBeRemoved = this.sqlElasticPools.getChildren(ExternalChildResourceImpl.PendingOperation.ToBeRemoved);
            for (SqlElasticPoolImpl epItem : epToBeRemoved) {
                for (SqlDatabaseImpl dbItem : dbToBeRemoved) {
                    epItem.addParentDependency(dbItem);
                }
            }
            List<SqlDatabaseImpl> dbToBeCreated = this.sqlDatabases.getChildren(ExternalChildResourceImpl.PendingOperation.ToBeCreated);
            List<SqlElasticPoolImpl> epToBeCreated = this.sqlElasticPools.getChildren(ExternalChildResourceImpl.PendingOperation.ToBeCreated);
            for (SqlElasticPoolImpl epItem : epToBeCreated) {
                for (SqlDatabaseImpl dbItem : dbToBeCreated) {
                    if (dbItem.elasticPoolId() == null || !ResourceUtils.nameFromResourceId(dbItem.elasticPoolId()).equals(epItem.name())) continue;
                    dbItem.addParentDependency(epItem);
                }
            }
        }
    }

    @Override
    public Mono<Void> afterPostRunAsync(boolean isGroupFaulted) {
        this.sqlADAdminCreator = null;
        this.sqlFirewallRules.clear();
        this.sqlElasticPools.clear();
        this.sqlDatabases.clear();
        return Mono.empty();
    }

    @Override
    public String fullyQualifiedDomainName() {
        return ((ServerInner)this.innerModel()).fullyQualifiedDomainName();
    }

    @Override
    public String administratorLogin() {
        return ((ServerInner)this.innerModel()).administratorLogin();
    }

    @Override
    public String kind() {
        return ((ServerInner)this.innerModel()).kind();
    }

    @Override
    public String state() {
        return ((ServerInner)this.innerModel()).state();
    }

    @Override
    public boolean isManagedServiceIdentityEnabled() {
        return ((ServerInner)this.innerModel()).identity() != null && ((ServerInner)this.innerModel()).identity().type().equals(IdentityType.SYSTEM_ASSIGNED);
    }

    @Override
    public String systemAssignedManagedServiceIdentityTenantId() {
        return ((ServerInner)this.innerModel()).identity() != null ? ((ServerInner)this.innerModel()).identity().tenantId().toString() : null;
    }

    @Override
    public String systemAssignedManagedServiceIdentityPrincipalId() {
        return ((ServerInner)this.innerModel()).identity() != null ? ((ServerInner)this.innerModel()).identity().principalId().toString() : null;
    }

    @Override
    public IdentityType managedServiceIdentityType() {
        return ((ServerInner)this.innerModel()).identity() != null ? ((ServerInner)this.innerModel()).identity().type() : null;
    }

    @Override
    public List<ServerMetric> listUsageMetrics() {
        ArrayList<ServerMetricImpl> serverMetrics = new ArrayList<ServerMetricImpl>();
        PagedIterable<ServerUsageInner> serverUsageInners = ((SqlManagementClient)((SqlServerManager)this.manager()).serviceClient()).getServerUsages().listByServer(this.resourceGroupName(), this.name());
        for (ServerUsageInner serverUsageInner : serverUsageInners) {
            serverMetrics.add(new ServerMetricImpl(serverUsageInner));
        }
        return Collections.unmodifiableList(serverMetrics);
    }

    @Override
    public List<SqlRestorableDroppedDatabase> listRestorableDroppedDatabases() {
        ArrayList<SqlRestorableDroppedDatabaseImpl> sqlRestorableDroppedDatabases = new ArrayList<SqlRestorableDroppedDatabaseImpl>();
        PagedIterable<RestorableDroppedDatabaseInner> restorableDroppedDatabasesInners = ((SqlManagementClient)((SqlServerManager)this.manager()).serviceClient()).getRestorableDroppedDatabases().listByServer(this.resourceGroupName(), this.name());
        for (RestorableDroppedDatabaseInner restorableDroppedDatabaseInner : restorableDroppedDatabasesInners) {
            sqlRestorableDroppedDatabases.add(new SqlRestorableDroppedDatabaseImpl(this.resourceGroupName(), this.name(), restorableDroppedDatabaseInner, (SqlServerManager)this.manager()));
        }
        return Collections.unmodifiableList(sqlRestorableDroppedDatabases);
    }

    @Override
    public PagedFlux<SqlRestorableDroppedDatabase> listRestorableDroppedDatabasesAsync() {
        SqlServerImpl self = this;
        return PagedConverter.mapPage(((SqlManagementClient)((SqlServerManager)this.manager()).serviceClient()).getRestorableDroppedDatabases().listByServerAsync(this.resourceGroupName(), this.name()), restorableDroppedDatabaseInner -> new SqlRestorableDroppedDatabaseImpl(self.resourceGroupName(), self.name(), (RestorableDroppedDatabaseInner)restorableDroppedDatabaseInner, (SqlServerManager)self.manager()));
    }

    @Override
    public String version() {
        return ((ServerInner)this.innerModel()).version();
    }

    @Override
    public SqlFirewallRule enableAccessFromAzureServices() {
        SqlFirewallRule firewallRule;
        block3: {
            firewallRule = null;
            try {
                firewallRule = (SqlFirewallRule)((SqlServerManager)this.manager()).sqlServers().firewallRules().getBySqlServer(this.resourceGroupName(), this.name(), "AllowAllWindowsAzureIps");
            }
            catch (ManagementException e) {
                if (e.getResponse().getStatusCode() == 404) break block3;
                throw this.logger.logExceptionAsError(e);
            }
        }
        if (firewallRule == null) {
            firewallRule = (SqlFirewallRule)((SqlFirewallRuleOperations.DefinitionStages.WithSqlServer)((SqlServerManager)this.manager()).sqlServers().firewallRules().define("AllowAllWindowsAzureIps")).withExistingSqlServer(this.resourceGroupName(), this.name()).withIpAddress("0.0.0.0").create();
        }
        return firewallRule;
    }

    @Override
    public ServerNetworkAccessFlag publicNetworkAccess() {
        return ((ServerInner)this.innerModel()).publicNetworkAccess();
    }

    @Override
    public void removeAccessFromAzureServices() {
        SqlFirewallRule firewallRule;
        block3: {
            firewallRule = null;
            try {
                firewallRule = (SqlFirewallRule)((SqlServerManager)this.manager()).sqlServers().firewallRules().getBySqlServer(this.resourceGroupName(), this.name(), "AllowAllWindowsAzureIps");
            }
            catch (ManagementException e) {
                if (e.getResponse().getStatusCode() == 404) break block3;
                throw this.logger.logExceptionAsError(e);
            }
        }
        if (firewallRule == null) {
            ((SqlServerManager)this.manager()).sqlServers().firewallRules().deleteBySqlServer(this.resourceGroupName(), this.name(), "AllowAllWindowsAzureIps");
        }
    }

    @Override
    public SqlActiveDirectoryAdministratorImpl setActiveDirectoryAdministrator(String userLogin, String objectId) {
        ServerAzureADAdministratorInner serverAzureADAdministratorInner = new ServerAzureADAdministratorInner().withAdministratorType(AdministratorType.ACTIVE_DIRECTORY).withLogin(userLogin).withSid(UUID.fromString(objectId)).withTenantId(UUID.fromString(((SqlServerManager)this.manager()).tenantId()));
        return new SqlActiveDirectoryAdministratorImpl(((SqlManagementClient)((SqlServerManager)this.manager()).serviceClient()).getServerAzureADAdministrators().createOrUpdate(this.resourceGroupName(), this.name(), AdministratorName.ACTIVE_DIRECTORY, serverAzureADAdministratorInner));
    }

    @Override
    public SqlActiveDirectoryAdministratorImpl getActiveDirectoryAdministrator() {
        ServerAzureADAdministratorInner serverAzureADAdministratorInner = ((SqlManagementClient)((SqlServerManager)this.manager()).serviceClient()).getServerAzureADAdministrators().get(this.resourceGroupName(), this.name(), AdministratorName.ACTIVE_DIRECTORY);
        return serverAzureADAdministratorInner != null ? new SqlActiveDirectoryAdministratorImpl(serverAzureADAdministratorInner) : null;
    }

    @Override
    public void removeActiveDirectoryAdministrator() {
        ((SqlManagementClient)((SqlServerManager)this.manager()).serviceClient()).getServerAzureADAdministrators().deleteAsync(this.resourceGroupName(), this.name(), AdministratorName.ACTIVE_DIRECTORY).then(this.refreshAsync()).block();
    }

    @Override
    public SqlServerAutomaticTuning getServerAutomaticTuning() {
        ServerAutomaticTuningInner serverAutomaticTuningInner = ((SqlManagementClient)((SqlServerManager)this.manager()).serviceClient()).getServerAutomaticTunings().get(this.resourceGroupName(), this.name());
        return serverAutomaticTuningInner != null ? new SqlServerAutomaticTuningImpl(this, serverAutomaticTuningInner) : null;
    }

    @Override
    public SqlFirewallRuleOperations.SqlFirewallRuleActionsDefinition firewallRules() {
        if (this.sqlFirewallRuleOperations == null) {
            this.sqlFirewallRuleOperations = new SqlFirewallRuleOperationsImpl(this, (SqlServerManager)this.manager());
        }
        return this.sqlFirewallRuleOperations;
    }

    @Override
    public SqlVirtualNetworkRuleOperations.SqlVirtualNetworkRuleActionsDefinition virtualNetworkRules() {
        if (this.sqlVirtualNetworkRuleOperations == null) {
            this.sqlVirtualNetworkRuleOperations = new SqlVirtualNetworkRuleOperationsImpl(this, (SqlServerManager)this.manager());
        }
        return this.sqlVirtualNetworkRuleOperations;
    }

    @Override
    public SqlServerImpl withAdministratorLogin(String administratorLogin) {
        ((ServerInner)this.innerModel()).withAdministratorLogin(administratorLogin);
        return this;
    }

    @Override
    public SqlServerImpl withAdministratorPassword(String administratorLoginPassword) {
        ((ServerInner)this.innerModel()).withAdministratorLoginPassword(administratorLoginPassword);
        return this;
    }

    @Override
    public SqlServerImpl withoutAccessFromAzureServices() {
        this.allowAzureServicesAccess = false;
        return this;
    }

    @Override
    public SqlServer.DefinitionStages.WithCreate withActiveDirectoryAdministrator(String userLogin, String objectId) {
        SqlServerImpl self = this;
        this.sqlADAdminCreator = context -> {
            ServerAzureADAdministratorInner serverAzureADAdministratorInner = new ServerAzureADAdministratorInner().withAdministratorType(AdministratorType.ACTIVE_DIRECTORY).withLogin(userLogin).withSid(UUID.fromString(objectId)).withTenantId(UUID.fromString(((SqlServerManager)self.manager()).tenantId()));
            return ((SqlManagementClient)((SqlServerManager)self.manager()).serviceClient()).getServerAzureADAdministrators().createOrUpdateAsync(self.resourceGroupName(), self.name(), AdministratorName.ACTIVE_DIRECTORY, serverAzureADAdministratorInner).flatMap(serverAzureADAdministratorInner1 -> context.voidMono());
        };
        return this;
    }

    public SqlFirewallRuleImpl defineFirewallRule(String name) {
        return this.sqlFirewallRules.defineInlineFirewallRule(name);
    }

    @Override
    public SqlServerImpl withoutFirewallRule(String firewallRuleName) {
        this.sqlFirewallRules.removeInlineFirewallRule(firewallRuleName);
        return this;
    }

    public SqlVirtualNetworkRule.DefinitionStages.Blank<SqlServer.DefinitionStages.WithCreate> defineVirtualNetworkRule(String virtualNetworkRuleName) {
        return this.sqlVirtualNetworkRules.defineInlineVirtualNetworkRule(virtualNetworkRuleName);
    }

    @Override
    public SqlElasticPoolOperations.SqlElasticPoolActionsDefinition elasticPools() {
        if (this.sqlElasticPoolOperations == null) {
            this.sqlElasticPoolOperations = new SqlElasticPoolOperationsImpl(this, (SqlServerManager)this.manager());
        }
        return this.sqlElasticPoolOperations;
    }

    @Override
    public SqlDatabaseOperations.SqlDatabaseActionsDefinition databases() {
        if (this.sqlDatabaseOperations == null) {
            this.sqlDatabaseOperations = new SqlDatabaseOperationsImpl(this, (SqlServerManager)this.manager());
        }
        return this.sqlDatabaseOperations;
    }

    @Override
    public SqlServerDnsAliasOperations.SqlServerDnsAliasActionsDefinition dnsAliases() {
        if (this.sqlServerDnsAliasOperations == null) {
            this.sqlServerDnsAliasOperations = new SqlServerDnsAliasOperationsImpl(this, (SqlServerManager)this.manager());
        }
        return this.sqlServerDnsAliasOperations;
    }

    @Override
    public SqlFailoverGroupOperations.SqlFailoverGroupActionsDefinition failoverGroups() {
        if (this.sqlFailoverGroupOperations == null) {
            this.sqlFailoverGroupOperations = new SqlFailoverGroupOperationsImpl(this, (SqlServerManager)this.manager());
        }
        return this.sqlFailoverGroupOperations;
    }

    @Override
    public SqlServerKeyOperations.SqlServerKeyActionsDefinition serverKeys() {
        if (this.sqlServerKeyOperations == null) {
            this.sqlServerKeyOperations = new SqlServerKeyOperationsImpl(this, (SqlServerManager)this.manager());
        }
        return this.sqlServerKeyOperations;
    }

    @Override
    public SqlEncryptionProtectorOperations.SqlEncryptionProtectorActionsDefinition encryptionProtectors() {
        if (this.sqlEncryptionProtectorsOperations == null) {
            this.sqlEncryptionProtectorsOperations = new SqlEncryptionProtectorOperationsImpl(this, (SqlServerManager)this.manager());
        }
        return this.sqlEncryptionProtectorsOperations;
    }

    @Override
    public SqlServerSecurityAlertPolicyOperations.SqlServerSecurityAlertPolicyActionsDefinition serverSecurityAlertPolicies() {
        if (this.sqlServerSecurityAlertPolicyOperations == null) {
            this.sqlServerSecurityAlertPolicyOperations = new SqlServerSecurityAlertPolicyOperationsImpl(this, (SqlServerManager)this.manager());
        }
        return this.sqlServerSecurityAlertPolicyOperations;
    }

    public SqlElasticPoolImpl defineElasticPool(String name) {
        return this.sqlElasticPools.defineInlineElasticPool(name);
    }

    @Override
    public SqlServerImpl withoutElasticPool(String elasticPoolName) {
        this.sqlElasticPools.removeInlineElasticPool(elasticPoolName);
        return this;
    }

    public SqlDatabaseImpl defineDatabase(String name) {
        return this.sqlDatabases.defineInlineDatabase(name);
    }

    @Override
    public SqlServerImpl withoutDatabase(String databaseName) {
        this.sqlDatabases.removeInlineDatabase(databaseName);
        return this;
    }

    @Override
    public SqlServerImpl withSystemAssignedManagedServiceIdentity() {
        ((ServerInner)this.innerModel()).withIdentity(new ResourceIdentity().withType(IdentityType.SYSTEM_ASSIGNED));
        return this;
    }

    @Override
    public SqlServerImpl enablePublicNetworkAccess() {
        ((ServerInner)this.innerModel()).withPublicNetworkAccess(ServerNetworkAccessFlag.ENABLED);
        return this;
    }

    @Override
    public SqlServerImpl disablePublicNetworkAccess() {
        ((ServerInner)this.innerModel()).withPublicNetworkAccess(ServerNetworkAccessFlag.DISABLED);
        return this;
    }
}

