/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.fluent.models.ElasticPoolUpdateProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ElasticPoolLicenseType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.ElasticPoolPerDatabaseSettings;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.sql.models.Sku;
import java.io.IOException;
import java.util.Map;

public final class ElasticPoolUpdate
implements JsonSerializable<ElasticPoolUpdate> {
    private Sku sku;
    private ElasticPoolUpdateProperties innerProperties;
    private Map<String, String> tags;

    public Sku sku() {
        return this.sku;
    }

    public ElasticPoolUpdate withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    private ElasticPoolUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ElasticPoolUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public Long maxSizeBytes() {
        return this.innerProperties() == null ? null : this.innerProperties().maxSizeBytes();
    }

    public ElasticPoolUpdate withMaxSizeBytes(Long maxSizeBytes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ElasticPoolUpdateProperties();
        }
        this.innerProperties().withMaxSizeBytes(maxSizeBytes);
        return this;
    }

    public Double minCapacity() {
        return this.innerProperties() == null ? null : this.innerProperties().minCapacity();
    }

    public ElasticPoolUpdate withMinCapacity(Double minCapacity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ElasticPoolUpdateProperties();
        }
        this.innerProperties().withMinCapacity(minCapacity);
        return this;
    }

    public ElasticPoolPerDatabaseSettings perDatabaseSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().perDatabaseSettings();
    }

    public ElasticPoolUpdate withPerDatabaseSettings(ElasticPoolPerDatabaseSettings perDatabaseSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ElasticPoolUpdateProperties();
        }
        this.innerProperties().withPerDatabaseSettings(perDatabaseSettings);
        return this;
    }

    public Boolean zoneRedundant() {
        return this.innerProperties() == null ? null : this.innerProperties().zoneRedundant();
    }

    public ElasticPoolUpdate withZoneRedundant(Boolean zoneRedundant) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ElasticPoolUpdateProperties();
        }
        this.innerProperties().withZoneRedundant(zoneRedundant);
        return this;
    }

    public ElasticPoolLicenseType licenseType() {
        return this.innerProperties() == null ? null : this.innerProperties().licenseType();
    }

    public ElasticPoolUpdate withLicenseType(ElasticPoolLicenseType licenseType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ElasticPoolUpdateProperties();
        }
        this.innerProperties().withLicenseType(licenseType);
        return this;
    }

    public String maintenanceConfigurationId() {
        return this.innerProperties() == null ? null : this.innerProperties().maintenanceConfigurationId();
    }

    public ElasticPoolUpdate withMaintenanceConfigurationId(String maintenanceConfigurationId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ElasticPoolUpdateProperties();
        }
        this.innerProperties().withMaintenanceConfigurationId(maintenanceConfigurationId);
        return this;
    }

    public Integer highAvailabilityReplicaCount() {
        return this.innerProperties() == null ? null : this.innerProperties().highAvailabilityReplicaCount();
    }

    public ElasticPoolUpdate withHighAvailabilityReplicaCount(Integer highAvailabilityReplicaCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ElasticPoolUpdateProperties();
        }
        this.innerProperties().withHighAvailabilityReplicaCount(highAvailabilityReplicaCount);
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sku", this.sku);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString((String)element));
        return jsonWriter.writeEndObject();
    }

    public static ElasticPoolUpdate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ElasticPoolUpdate deserializedElasticPoolUpdate = new ElasticPoolUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sku".equals(fieldName)) {
                    deserializedElasticPoolUpdate.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedElasticPoolUpdate.innerProperties = ElasticPoolUpdateProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedElasticPoolUpdate.tags = tags;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedElasticPoolUpdate;
        });
    }
}

