/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.EncryptionScopeKeyVaultProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.EncryptionScopeSource;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.EncryptionScopeState;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class EncryptionScopeProperties
implements JsonSerializable<EncryptionScopeProperties> {
    private EncryptionScopeSource source;
    private EncryptionScopeState state;
    private OffsetDateTime creationTime;
    private OffsetDateTime lastModifiedTime;
    private EncryptionScopeKeyVaultProperties keyVaultProperties;
    private Boolean requireInfrastructureEncryption;

    public EncryptionScopeSource source() {
        return this.source;
    }

    public EncryptionScopeProperties withSource(EncryptionScopeSource source2) {
        this.source = source2;
        return this;
    }

    public EncryptionScopeState state() {
        return this.state;
    }

    public EncryptionScopeProperties withState(EncryptionScopeState state) {
        this.state = state;
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public EncryptionScopeKeyVaultProperties keyVaultProperties() {
        return this.keyVaultProperties;
    }

    public EncryptionScopeProperties withKeyVaultProperties(EncryptionScopeKeyVaultProperties keyVaultProperties) {
        this.keyVaultProperties = keyVaultProperties;
        return this;
    }

    public Boolean requireInfrastructureEncryption() {
        return this.requireInfrastructureEncryption;
    }

    public EncryptionScopeProperties withRequireInfrastructureEncryption(Boolean requireInfrastructureEncryption) {
        this.requireInfrastructureEncryption = requireInfrastructureEncryption;
        return this;
    }

    public void validate() {
        if (this.keyVaultProperties() != null) {
            this.keyVaultProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("source", this.source == null ? null : this.source.toString());
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeJsonField("keyVaultProperties", this.keyVaultProperties);
        jsonWriter.writeBooleanField("requireInfrastructureEncryption", this.requireInfrastructureEncryption);
        return jsonWriter.writeEndObject();
    }

    public static EncryptionScopeProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EncryptionScopeProperties deserializedEncryptionScopeProperties = new EncryptionScopeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("source".equals(fieldName)) {
                    deserializedEncryptionScopeProperties.source = EncryptionScopeSource.fromString(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedEncryptionScopeProperties.state = EncryptionScopeState.fromString(reader.getString());
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedEncryptionScopeProperties.creationTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedEncryptionScopeProperties.lastModifiedTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("keyVaultProperties".equals(fieldName)) {
                    deserializedEncryptionScopeProperties.keyVaultProperties = EncryptionScopeKeyVaultProperties.fromJson(reader);
                    continue;
                }
                if ("requireInfrastructureEncryption".equals(fieldName)) {
                    deserializedEncryptionScopeProperties.requireInfrastructureEncryption = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEncryptionScopeProperties;
        });
    }
}

