/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.ManagementPolicySchema;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ManagementPolicyProperties
implements JsonSerializable<ManagementPolicyProperties> {
    private OffsetDateTime lastModifiedTime;
    private ManagementPolicySchema policy;
    private static final ClientLogger LOGGER = new ClientLogger(ManagementPolicyProperties.class);

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public ManagementPolicySchema policy() {
        return this.policy;
    }

    public ManagementPolicyProperties withPolicy(ManagementPolicySchema policy) {
        this.policy = policy;
        return this;
    }

    public void validate() {
        if (this.policy() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property policy in model ManagementPolicyProperties"));
        }
        this.policy().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("policy", this.policy);
        return jsonWriter.writeEndObject();
    }

    public static ManagementPolicyProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagementPolicyProperties deserializedManagementPolicyProperties = new ManagementPolicyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("policy".equals(fieldName)) {
                    deserializedManagementPolicyProperties.policy = ManagementPolicySchema.fromJson(reader);
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedManagementPolicyProperties.lastModifiedTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagementPolicyProperties;
        });
    }
}

