/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.BlobInventoryCreationTime;
import java.io.IOException;
import java.util.List;

public final class BlobInventoryPolicyFilter
implements JsonSerializable<BlobInventoryPolicyFilter> {
    private List<String> prefixMatch;
    private List<String> excludePrefix;
    private List<String> blobTypes;
    private Boolean includeBlobVersions;
    private Boolean includeSnapshots;
    private Boolean includeDeleted;
    private BlobInventoryCreationTime creationTime;

    public List<String> prefixMatch() {
        return this.prefixMatch;
    }

    public BlobInventoryPolicyFilter withPrefixMatch(List<String> prefixMatch) {
        this.prefixMatch = prefixMatch;
        return this;
    }

    public List<String> excludePrefix() {
        return this.excludePrefix;
    }

    public BlobInventoryPolicyFilter withExcludePrefix(List<String> excludePrefix) {
        this.excludePrefix = excludePrefix;
        return this;
    }

    public List<String> blobTypes() {
        return this.blobTypes;
    }

    public BlobInventoryPolicyFilter withBlobTypes(List<String> blobTypes) {
        this.blobTypes = blobTypes;
        return this;
    }

    public Boolean includeBlobVersions() {
        return this.includeBlobVersions;
    }

    public BlobInventoryPolicyFilter withIncludeBlobVersions(Boolean includeBlobVersions) {
        this.includeBlobVersions = includeBlobVersions;
        return this;
    }

    public Boolean includeSnapshots() {
        return this.includeSnapshots;
    }

    public BlobInventoryPolicyFilter withIncludeSnapshots(Boolean includeSnapshots) {
        this.includeSnapshots = includeSnapshots;
        return this;
    }

    public Boolean includeDeleted() {
        return this.includeDeleted;
    }

    public BlobInventoryPolicyFilter withIncludeDeleted(Boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
        return this;
    }

    public BlobInventoryCreationTime creationTime() {
        return this.creationTime;
    }

    public BlobInventoryPolicyFilter withCreationTime(BlobInventoryCreationTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public void validate() {
        if (this.creationTime() != null) {
            this.creationTime().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("prefixMatch", this.prefixMatch, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("excludePrefix", this.excludePrefix, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeArrayField("blobTypes", this.blobTypes, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeBooleanField("includeBlobVersions", this.includeBlobVersions);
        jsonWriter.writeBooleanField("includeSnapshots", this.includeSnapshots);
        jsonWriter.writeBooleanField("includeDeleted", this.includeDeleted);
        jsonWriter.writeJsonField("creationTime", this.creationTime);
        return jsonWriter.writeEndObject();
    }

    public static BlobInventoryPolicyFilter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BlobInventoryPolicyFilter deserializedBlobInventoryPolicyFilter = new BlobInventoryPolicyFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("prefixMatch".equals(fieldName)) {
                    List<String> prefixMatch = reader.readArray(reader1 -> reader1.getString());
                    deserializedBlobInventoryPolicyFilter.prefixMatch = prefixMatch;
                    continue;
                }
                if ("excludePrefix".equals(fieldName)) {
                    List<String> excludePrefix = reader.readArray(reader1 -> reader1.getString());
                    deserializedBlobInventoryPolicyFilter.excludePrefix = excludePrefix;
                    continue;
                }
                if ("blobTypes".equals(fieldName)) {
                    List<String> blobTypes = reader.readArray(reader1 -> reader1.getString());
                    deserializedBlobInventoryPolicyFilter.blobTypes = blobTypes;
                    continue;
                }
                if ("includeBlobVersions".equals(fieldName)) {
                    deserializedBlobInventoryPolicyFilter.includeBlobVersions = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("includeSnapshots".equals(fieldName)) {
                    deserializedBlobInventoryPolicyFilter.includeSnapshots = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("includeDeleted".equals(fieldName)) {
                    deserializedBlobInventoryPolicyFilter.includeDeleted = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedBlobInventoryPolicyFilter.creationTime = BlobInventoryCreationTime.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBlobInventoryPolicyFilter;
        });
    }
}

