/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.BlobInventoryPolicyRule;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.InventoryRuleType;
import java.io.IOException;
import java.util.List;

public final class BlobInventoryPolicySchema
implements JsonSerializable<BlobInventoryPolicySchema> {
    private boolean enabled;
    private String destination;
    private InventoryRuleType type;
    private List<BlobInventoryPolicyRule> rules;
    private static final ClientLogger LOGGER = new ClientLogger(BlobInventoryPolicySchema.class);

    public boolean enabled() {
        return this.enabled;
    }

    public BlobInventoryPolicySchema withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String destination() {
        return this.destination;
    }

    public InventoryRuleType type() {
        return this.type;
    }

    public BlobInventoryPolicySchema withType(InventoryRuleType type) {
        this.type = type;
        return this;
    }

    public List<BlobInventoryPolicyRule> rules() {
        return this.rules;
    }

    public BlobInventoryPolicySchema withRules(List<BlobInventoryPolicyRule> rules) {
        this.rules = rules;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property type in model BlobInventoryPolicySchema"));
        }
        if (this.rules() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property rules in model BlobInventoryPolicySchema"));
        }
        this.rules().forEach(e -> e.validate());
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static BlobInventoryPolicySchema fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BlobInventoryPolicySchema deserializedBlobInventoryPolicySchema = new BlobInventoryPolicySchema();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedBlobInventoryPolicySchema.enabled = reader.getBoolean();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBlobInventoryPolicySchema.type = InventoryRuleType.fromString(reader.getString());
                    continue;
                }
                if ("rules".equals(fieldName)) {
                    List<BlobInventoryPolicyRule> rules = reader.readArray(reader1 -> BlobInventoryPolicyRule.fromJson(reader1));
                    deserializedBlobInventoryPolicySchema.rules = rules;
                    continue;
                }
                if ("destination".equals(fieldName)) {
                    deserializedBlobInventoryPolicySchema.destination = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBlobInventoryPolicySchema;
        });
    }
}

