/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.TriggerParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.TriggerType;
import java.io.IOException;

public final class ExecutionTrigger
implements JsonSerializable<ExecutionTrigger> {
    private TriggerType type;
    private TriggerParameters parameters;
    private static final ClientLogger LOGGER = new ClientLogger(ExecutionTrigger.class);

    public TriggerType type() {
        return this.type;
    }

    public ExecutionTrigger withType(TriggerType type) {
        this.type = type;
        return this;
    }

    public TriggerParameters parameters() {
        return this.parameters;
    }

    public ExecutionTrigger withParameters(TriggerParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property type in model ExecutionTrigger"));
        }
        if (this.parameters() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property parameters in model ExecutionTrigger"));
        }
        this.parameters().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("parameters", this.parameters);
        return jsonWriter.writeEndObject();
    }

    public static ExecutionTrigger fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExecutionTrigger deserializedExecutionTrigger = new ExecutionTrigger();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedExecutionTrigger.type = TriggerType.fromString(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    deserializedExecutionTrigger.parameters = TriggerParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExecutionTrigger;
        });
    }
}

