/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.storage.models.LeaseShareAction;
import java.io.IOException;

public final class LeaseShareRequest
implements JsonSerializable<LeaseShareRequest> {
    private LeaseShareAction action;
    private String leaseId;
    private Integer breakPeriod;
    private Integer leaseDuration;
    private String proposedLeaseId;
    private static final ClientLogger LOGGER = new ClientLogger(LeaseShareRequest.class);

    public LeaseShareAction action() {
        return this.action;
    }

    public LeaseShareRequest withAction(LeaseShareAction action) {
        this.action = action;
        return this;
    }

    public String leaseId() {
        return this.leaseId;
    }

    public LeaseShareRequest withLeaseId(String leaseId) {
        this.leaseId = leaseId;
        return this;
    }

    public Integer breakPeriod() {
        return this.breakPeriod;
    }

    public LeaseShareRequest withBreakPeriod(Integer breakPeriod) {
        this.breakPeriod = breakPeriod;
        return this;
    }

    public Integer leaseDuration() {
        return this.leaseDuration;
    }

    public LeaseShareRequest withLeaseDuration(Integer leaseDuration) {
        this.leaseDuration = leaseDuration;
        return this;
    }

    public String proposedLeaseId() {
        return this.proposedLeaseId;
    }

    public LeaseShareRequest withProposedLeaseId(String proposedLeaseId) {
        this.proposedLeaseId = proposedLeaseId;
        return this;
    }

    public void validate() {
        if (this.action() == null) {
            throw LOGGER.atError().log(new IllegalArgumentException("Missing required property action in model LeaseShareRequest"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("action", this.action == null ? null : this.action.toString());
        jsonWriter.writeStringField("leaseId", this.leaseId);
        jsonWriter.writeNumberField("breakPeriod", this.breakPeriod);
        jsonWriter.writeNumberField("leaseDuration", this.leaseDuration);
        jsonWriter.writeStringField("proposedLeaseId", this.proposedLeaseId);
        return jsonWriter.writeEndObject();
    }

    public static LeaseShareRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LeaseShareRequest deserializedLeaseShareRequest = new LeaseShareRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("action".equals(fieldName)) {
                    deserializedLeaseShareRequest.action = LeaseShareAction.fromString(reader.getString());
                    continue;
                }
                if ("leaseId".equals(fieldName)) {
                    deserializedLeaseShareRequest.leaseId = reader.getString();
                    continue;
                }
                if ("breakPeriod".equals(fieldName)) {
                    deserializedLeaseShareRequest.breakPeriod = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("leaseDuration".equals(fieldName)) {
                    deserializedLeaseShareRequest.leaseDuration = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("proposedLeaseId".equals(fieldName)) {
                    deserializedLeaseShareRequest.proposedLeaseId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLeaseShareRequest;
        });
    }
}

