/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.ExternalChildResourcesCachedImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.fluent.EndpointsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.fluent.models.EndpointInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.fluent.models.ProfileInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.implementation.TrafficManagerAzureEndpointImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.implementation.TrafficManagerEndpointImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.implementation.TrafficManagerExternalEndpointImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.implementation.TrafficManagerNestedProfileEndpointImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.implementation.TrafficManagerProfileImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.EndpointType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.TrafficManagerAzureEndpoint;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.TrafficManagerEndpoint;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.TrafficManagerExternalEndpoint;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.TrafficManagerNestedProfileEndpoint;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.TrafficManagerProfile;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class TrafficManagerEndpointsImpl
extends ExternalChildResourcesCachedImpl<TrafficManagerEndpointImpl, TrafficManagerEndpoint, EndpointInner, TrafficManagerProfileImpl, TrafficManagerProfile> {
    private final ClientLogger logger = new ClientLogger(this.getClass());
    private final EndpointsClient client;

    TrafficManagerEndpointsImpl(EndpointsClient client, TrafficManagerProfileImpl parent) {
        super(parent, parent.taskGroup(), "Endpoint");
        this.client = client;
        this.cacheCollection();
    }

    List<EndpointInner> allEndpointsInners() {
        ArrayList<EndpointInner> allEndpoints = new ArrayList<EndpointInner>();
        for (TrafficManagerEndpointImpl epImpl : this.collection().values()) {
            allEndpoints.add((EndpointInner)epImpl.innerModel());
        }
        return allEndpoints;
    }

    Map<String, TrafficManagerAzureEndpoint> azureEndpointsAsMap() {
        HashMap<String, TrafficManagerAzureEndpointImpl> result = new HashMap<String, TrafficManagerAzureEndpointImpl>();
        for (Map.Entry entry : this.collection().entrySet()) {
            TrafficManagerEndpointImpl endpoint = (TrafficManagerEndpointImpl)entry.getValue();
            if (endpoint.endpointType() != EndpointType.AZURE) continue;
            TrafficManagerAzureEndpointImpl azureEndpoint = new TrafficManagerAzureEndpointImpl(entry.getKey(), (TrafficManagerProfileImpl)this.getParent(), (EndpointInner)endpoint.innerModel(), this.client);
            result.put(entry.getKey(), azureEndpoint);
        }
        return Collections.unmodifiableMap(result);
    }

    Map<String, TrafficManagerExternalEndpoint> externalEndpointsAsMap() {
        HashMap<String, TrafficManagerExternalEndpointImpl> result = new HashMap<String, TrafficManagerExternalEndpointImpl>();
        for (Map.Entry entry : this.collection().entrySet()) {
            TrafficManagerEndpointImpl endpoint = (TrafficManagerEndpointImpl)entry.getValue();
            if (endpoint.endpointType() != EndpointType.EXTERNAL) continue;
            TrafficManagerExternalEndpointImpl externalEndpoint = new TrafficManagerExternalEndpointImpl(entry.getKey(), (TrafficManagerProfileImpl)this.getParent(), (EndpointInner)endpoint.innerModel(), this.client);
            result.put(entry.getKey(), externalEndpoint);
        }
        return Collections.unmodifiableMap(result);
    }

    Map<String, TrafficManagerNestedProfileEndpoint> nestedProfileEndpointsAsMap() {
        HashMap<String, TrafficManagerNestedProfileEndpointImpl> result = new HashMap<String, TrafficManagerNestedProfileEndpointImpl>();
        for (Map.Entry entry : this.collection().entrySet()) {
            TrafficManagerEndpointImpl endpoint = (TrafficManagerEndpointImpl)entry.getValue();
            if (endpoint.endpointType() != EndpointType.NESTED_PROFILE) continue;
            TrafficManagerNestedProfileEndpointImpl nestedProfileEndpoint = new TrafficManagerNestedProfileEndpointImpl(entry.getKey(), (TrafficManagerProfileImpl)this.getParent(), (EndpointInner)endpoint.innerModel(), this.client);
            result.put(entry.getKey(), nestedProfileEndpoint);
        }
        return Collections.unmodifiableMap(result);
    }

    public TrafficManagerEndpointImpl defineAzureTargetEndpoint(String name) {
        TrafficManagerEndpointImpl endpoint = (TrafficManagerEndpointImpl)this.prepareInlineDefine(name);
        endpoint.withEndpointType(EndpointType.AZURE);
        return endpoint;
    }

    public TrafficManagerEndpointImpl defineExteralTargetEndpoint(String name) {
        TrafficManagerEndpointImpl endpoint = (TrafficManagerEndpointImpl)this.prepareInlineDefine(name);
        endpoint.withEndpointType(EndpointType.EXTERNAL);
        return endpoint;
    }

    public TrafficManagerEndpointImpl defineNestedProfileTargetEndpoint(String name) {
        TrafficManagerEndpointImpl endpoint = (TrafficManagerEndpointImpl)this.prepareInlineDefine(name);
        endpoint.withEndpointType(EndpointType.NESTED_PROFILE);
        return endpoint;
    }

    public TrafficManagerEndpointImpl updateAzureEndpoint(String name) {
        TrafficManagerEndpointImpl endpoint = (TrafficManagerEndpointImpl)this.prepareInlineUpdate(name);
        if (endpoint.endpointType() != EndpointType.AZURE) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("An azure endpoint with name " + name + " not found in the profile"));
        }
        return endpoint;
    }

    public TrafficManagerEndpointImpl updateExternalEndpoint(String name) {
        TrafficManagerEndpointImpl endpoint = (TrafficManagerEndpointImpl)this.prepareInlineUpdate(name);
        if (endpoint.endpointType() != EndpointType.EXTERNAL) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("An external endpoint with name " + name + " not found in the profile"));
        }
        return endpoint;
    }

    public TrafficManagerEndpointImpl updateNestedProfileEndpoint(String name) {
        TrafficManagerEndpointImpl endpoint = (TrafficManagerEndpointImpl)this.prepareInlineUpdate(name);
        if (endpoint.endpointType() != EndpointType.NESTED_PROFILE) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("A nested profile endpoint with name " + name + " not found in the profile"));
        }
        return endpoint;
    }

    public void remove(String name) {
        this.prepareInlineRemove(name);
    }

    public void addEndpoint(TrafficManagerEndpointImpl endpoint) {
        this.addChildResource(endpoint);
    }

    @Override
    protected List<TrafficManagerEndpointImpl> listChildResources() {
        ArrayList<TrafficManagerEndpointImpl> childResources = new ArrayList<TrafficManagerEndpointImpl>();
        if (((ProfileInner)((TrafficManagerProfileImpl)this.getParent()).innerModel()).endpoints() != null) {
            for (EndpointInner inner : ((ProfileInner)((TrafficManagerProfileImpl)this.getParent()).innerModel()).endpoints()) {
                childResources.add(new TrafficManagerEndpointImpl(inner.name(), (TrafficManagerProfileImpl)this.getParent(), inner, this.client));
            }
        }
        return childResources;
    }

    @Override
    protected Flux<TrafficManagerEndpointImpl> listChildResourcesAsync() {
        return Flux.fromIterable(this.listChildResources());
    }

    @Override
    protected TrafficManagerEndpointImpl newChildResource(String name) {
        TrafficManagerEndpointImpl endpoint = new TrafficManagerEndpointImpl(name, (TrafficManagerProfileImpl)this.getParent(), new EndpointInner(), this.client);
        return endpoint.withRoutingWeight(1).withTrafficEnabled();
    }
}

