/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.implementation;

import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.TrafficManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.fluent.ProfilesClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.fluent.TrafficManagerManagementClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.fluent.models.EndpointInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.fluent.models.ProfileInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.implementation.GeographicHierarchiesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.implementation.TrafficManagerProfileImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.CheckProfileDnsNameAvailabilityResult;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.CheckTrafficManagerRelativeDnsNameAvailabilityParameters;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.DnsConfig;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.GeographicHierarchies;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.GeographicLocation;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.MonitorConfig;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.TrafficManagerProfile;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.TrafficManagerProfiles;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.ArrayList;

public class TrafficManagerProfilesImpl
extends TopLevelModifiableResourcesImpl<TrafficManagerProfile, TrafficManagerProfileImpl, ProfileInner, ProfilesClient, TrafficManager>
implements TrafficManagerProfiles {
    private GeographicHierarchies geographicHierarchies;

    public TrafficManagerProfilesImpl(TrafficManager trafficManager) {
        super(((TrafficManagerManagementClient)trafficManager.serviceClient()).getProfiles(), trafficManager);
        this.geographicHierarchies = new GeographicHierarchiesImpl(trafficManager, ((TrafficManagerManagementClient)trafficManager.serviceClient()).getGeographicHierarchies());
    }

    @Override
    public CheckProfileDnsNameAvailabilityResult checkDnsNameAvailability(String dnsNameLabel) {
        return this.checkDnsNameAvailabilityAsync(dnsNameLabel).block();
    }

    @Override
    public Mono<CheckProfileDnsNameAvailabilityResult> checkDnsNameAvailabilityAsync(String dnsNameLabel) {
        CheckTrafficManagerRelativeDnsNameAvailabilityParameters parameter = new CheckTrafficManagerRelativeDnsNameAvailabilityParameters().withName(dnsNameLabel).withType("Microsoft.Network/trafficManagerProfiles");
        return ((ProfilesClient)this.inner()).checkTrafficManagerRelativeDnsNameAvailabilityAsync(parameter).map(CheckProfileDnsNameAvailabilityResult::new);
    }

    @Override
    public GeographicLocation getGeographicHierarchyRoot() {
        return this.geographicHierarchies.getRoot();
    }

    @Override
    protected TrafficManagerProfileImpl wrapModel(String name) {
        return new TrafficManagerProfileImpl(name, new ProfileInner(), (TrafficManager)this.manager());
    }

    @Override
    protected TrafficManagerProfileImpl wrapModel(ProfileInner inner) {
        if (inner == null) {
            return null;
        }
        return new TrafficManagerProfileImpl(inner.name(), inner, (TrafficManager)this.manager());
    }

    @Override
    public TrafficManagerProfileImpl define(String name) {
        return this.setDefaults(this.wrapModel(name));
    }

    private TrafficManagerProfileImpl setDefaults(TrafficManagerProfileImpl profile) {
        ((ProfileInner)profile.innerModel()).withMonitorConfig(new MonitorConfig());
        profile.withHttpMonitoring();
        ((ProfileInner)profile.innerModel()).withDnsConfig(new DnsConfig());
        profile.withTimeToLive(300);
        ((ProfileInner)profile.innerModel()).withLocation("global");
        ((ProfileInner)profile.innerModel()).withEndpoints(new ArrayList<EndpointInner>());
        return profile;
    }
}

