/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.MonitorConfigCustomHeadersItem;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.MonitorConfigExpectedStatusCodeRangesItem;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.MonitorProtocol;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.ProfileMonitorStatus;
import java.io.IOException;
import java.util.List;

public final class MonitorConfig
implements JsonSerializable<MonitorConfig> {
    private ProfileMonitorStatus profileMonitorStatus;
    private MonitorProtocol protocol;
    private Long port;
    private String path;
    private Long intervalInSeconds;
    private Long timeoutInSeconds;
    private Long toleratedNumberOfFailures;
    private List<MonitorConfigCustomHeadersItem> customHeaders;
    private List<MonitorConfigExpectedStatusCodeRangesItem> expectedStatusCodeRanges;

    public ProfileMonitorStatus profileMonitorStatus() {
        return this.profileMonitorStatus;
    }

    public MonitorConfig withProfileMonitorStatus(ProfileMonitorStatus profileMonitorStatus) {
        this.profileMonitorStatus = profileMonitorStatus;
        return this;
    }

    public MonitorProtocol protocol() {
        return this.protocol;
    }

    public MonitorConfig withProtocol(MonitorProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public Long port() {
        return this.port;
    }

    public MonitorConfig withPort(Long port) {
        this.port = port;
        return this;
    }

    public String path() {
        return this.path;
    }

    public MonitorConfig withPath(String path) {
        this.path = path;
        return this;
    }

    public Long intervalInSeconds() {
        return this.intervalInSeconds;
    }

    public MonitorConfig withIntervalInSeconds(Long intervalInSeconds) {
        this.intervalInSeconds = intervalInSeconds;
        return this;
    }

    public Long timeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public MonitorConfig withTimeoutInSeconds(Long timeoutInSeconds) {
        this.timeoutInSeconds = timeoutInSeconds;
        return this;
    }

    public Long toleratedNumberOfFailures() {
        return this.toleratedNumberOfFailures;
    }

    public MonitorConfig withToleratedNumberOfFailures(Long toleratedNumberOfFailures) {
        this.toleratedNumberOfFailures = toleratedNumberOfFailures;
        return this;
    }

    public List<MonitorConfigCustomHeadersItem> customHeaders() {
        return this.customHeaders;
    }

    public MonitorConfig withCustomHeaders(List<MonitorConfigCustomHeadersItem> customHeaders) {
        this.customHeaders = customHeaders;
        return this;
    }

    public List<MonitorConfigExpectedStatusCodeRangesItem> expectedStatusCodeRanges() {
        return this.expectedStatusCodeRanges;
    }

    public MonitorConfig withExpectedStatusCodeRanges(List<MonitorConfigExpectedStatusCodeRangesItem> expectedStatusCodeRanges) {
        this.expectedStatusCodeRanges = expectedStatusCodeRanges;
        return this;
    }

    public void validate() {
        if (this.customHeaders() != null) {
            this.customHeaders().forEach(e -> e.validate());
        }
        if (this.expectedStatusCodeRanges() != null) {
            this.expectedStatusCodeRanges().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("profileMonitorStatus", this.profileMonitorStatus == null ? null : this.profileMonitorStatus.toString());
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeNumberField("port", this.port);
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeNumberField("intervalInSeconds", this.intervalInSeconds);
        jsonWriter.writeNumberField("timeoutInSeconds", this.timeoutInSeconds);
        jsonWriter.writeNumberField("toleratedNumberOfFailures", this.toleratedNumberOfFailures);
        jsonWriter.writeArrayField("customHeaders", this.customHeaders, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        jsonWriter.writeArrayField("expectedStatusCodeRanges", this.expectedStatusCodeRanges, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static MonitorConfig fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MonitorConfig deserializedMonitorConfig = new MonitorConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("profileMonitorStatus".equals(fieldName)) {
                    deserializedMonitorConfig.profileMonitorStatus = ProfileMonitorStatus.fromString(reader.getString());
                    continue;
                }
                if ("protocol".equals(fieldName)) {
                    deserializedMonitorConfig.protocol = MonitorProtocol.fromString(reader.getString());
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedMonitorConfig.port = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("path".equals(fieldName)) {
                    deserializedMonitorConfig.path = reader.getString();
                    continue;
                }
                if ("intervalInSeconds".equals(fieldName)) {
                    deserializedMonitorConfig.intervalInSeconds = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("timeoutInSeconds".equals(fieldName)) {
                    deserializedMonitorConfig.timeoutInSeconds = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("toleratedNumberOfFailures".equals(fieldName)) {
                    deserializedMonitorConfig.toleratedNumberOfFailures = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("customHeaders".equals(fieldName)) {
                    List<MonitorConfigCustomHeadersItem> customHeaders = reader.readArray(reader1 -> MonitorConfigCustomHeadersItem.fromJson(reader1));
                    deserializedMonitorConfig.customHeaders = customHeaders;
                    continue;
                }
                if ("expectedStatusCodeRanges".equals(fieldName)) {
                    List<MonitorConfigExpectedStatusCodeRangesItem> expectedStatusCodeRanges = reader.readArray(reader1 -> MonitorConfigExpectedStatusCodeRangesItem.fromJson(reader1));
                    deserializedMonitorConfig.expectedStatusCodeRanges = expectedStatusCodeRanges;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMonitorConfig;
        });
    }
}

