/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceClient;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.cryptography.AsyncKeyEncryptionKey;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.CryptographyAsyncClient;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.CryptographyServiceVersion;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.KeyEncryptionKeyClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.models.KeyWrapAlgorithm;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.JsonWebKey;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

@ServiceClient(builder=KeyEncryptionKeyClientBuilder.class, isAsync=true)
public final class KeyEncryptionKeyAsyncClient
extends CryptographyAsyncClient
implements AsyncKeyEncryptionKey {
    private static final ClientLogger LOGGER = new ClientLogger(KeyEncryptionKeyAsyncClient.class);

    KeyEncryptionKeyAsyncClient(String keyId, HttpPipeline pipeline, CryptographyServiceVersion version, boolean disableKeyCaching) {
        super(keyId, pipeline, version, disableKeyCaching);
    }

    KeyEncryptionKeyAsyncClient(JsonWebKey jsonWebKey) {
        super(jsonWebKey);
    }

    @Override
    public Mono<String> getKeyId() {
        return Mono.defer(() -> Mono.just(this.keyId));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<byte[]> wrapKey(String algorithm, byte[] key) {
        try {
            KeyWrapAlgorithm wrapAlgorithm = KeyWrapAlgorithm.fromString(algorithm);
            return this.wrapKey(wrapAlgorithm, key).flatMap(keyWrapResult -> Mono.just(keyWrapResult.getEncryptedKey()));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<byte[]> unwrapKey(String algorithm, byte[] encryptedKey) {
        try {
            KeyWrapAlgorithm wrapAlgorithm = KeyWrapAlgorithm.fromString(algorithm);
            return this.unwrapKey(wrapAlgorithm, encryptedKey).flatMap(keyUnwrapResult -> Mono.just(keyUnwrapResult.getKey()));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }
}

