/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceClient;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.cryptography.KeyEncryptionKey;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.CryptographyClient;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.CryptographyServiceVersion;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.KeyEncryptionKeyClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.models.KeyWrapAlgorithm;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.JsonWebKey;

@ServiceClient(builder=KeyEncryptionKeyClientBuilder.class)
public final class KeyEncryptionKeyClient
extends CryptographyClient
implements KeyEncryptionKey {
    KeyEncryptionKeyClient(String keyId, HttpPipeline pipeline, CryptographyServiceVersion version, boolean disableKeyCaching) {
        super(keyId, pipeline, version, disableKeyCaching);
    }

    KeyEncryptionKeyClient(JsonWebKey jsonWebKey) {
        super(jsonWebKey);
    }

    @Override
    public String getKeyId() {
        return this.keyId;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public byte[] wrapKey(String algorithm, byte[] key) {
        KeyWrapAlgorithm wrapAlgorithm = KeyWrapAlgorithm.fromString(algorithm);
        return this.wrapKey(wrapAlgorithm, key).getEncryptedKey();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public byte[] unwrapKey(String algorithm, byte[] encryptedKey) {
        KeyWrapAlgorithm wrapAlgorithm = KeyWrapAlgorithm.fromString(algorithm);
        return this.unwrapKey(wrapAlgorithm, encryptedKey).getKey();
    }
}

