/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.exception.HttpResponseException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.implementation.AesKeyCryptographyClient;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.implementation.CryptographyClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.implementation.EcKeyCryptographyClient;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.implementation.LocalKeyCryptographyClient;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.implementation.RsaKeyCryptographyClient;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.models.KeyWrapAlgorithm;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.models.SignatureAlgorithm;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.JsonWebKeyEncryptionAlgorithm;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.JsonWebKeySignatureAlgorithm;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.SecretKey;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.JsonWebKey;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.KeyOperation;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.KeyType;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.KeyVaultKey;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public final class CryptographyUtils {
    public static final String SECRETS_COLLECTION = "secrets";

    private CryptographyUtils() {
    }

    public static List<String> unpackAndValidateId(String keyId, ClientLogger logger) {
        if (CoreUtils.isNullOrEmpty(keyId)) {
            throw logger.logExceptionAsError(new IllegalArgumentException("'keyId' cannot be null or empty."));
        }
        try {
            String keyVersion;
            URL url = new URL(keyId);
            String[] tokens = url.getPath().split("/");
            String vaultUrl = url.getProtocol() + "://" + url.getHost();
            if (url.getPort() != -1) {
                vaultUrl = vaultUrl + ":" + url.getPort();
            }
            String keyCollection = tokens.length >= 2 ? tokens[1] : null;
            String keyName = tokens.length >= 3 ? tokens[2] : null;
            String string = keyVersion = tokens.length >= 4 ? tokens[3] : null;
            if (CoreUtils.isNullOrEmpty(vaultUrl)) {
                throw logger.logExceptionAsError(new IllegalArgumentException("Key endpoint in key identifier is invalid."));
            }
            if (CoreUtils.isNullOrEmpty(keyName)) {
                throw logger.logExceptionAsError(new IllegalArgumentException("Key name in key identifier is invalid."));
            }
            return Arrays.asList(vaultUrl, keyCollection, keyName, keyVersion);
        }
        catch (MalformedURLException e) {
            throw logger.logExceptionAsError(new IllegalArgumentException("The key identifier is malformed.", e));
        }
    }

    public static LocalKeyCryptographyClient retrieveJwkAndCreateLocalClient(CryptographyClientImpl implClient) {
        if (!CoreUtils.isNullOrEmpty(implClient.getKeyCollection())) {
            JsonWebKey jsonWebKey;
            JsonWebKey jsonWebKey2 = jsonWebKey = SECRETS_COLLECTION.equals(implClient.getKeyCollection()) ? implClient.getSecretKey() : implClient.getKey(Context.NONE).getValue().getKey();
            if (jsonWebKey == null) {
                throw new IllegalStateException("Could not retrieve JSON Web Key to perform local cryptographic operations.");
            }
            if (!jsonWebKey.isValid()) {
                throw new IllegalStateException("The retrieved JSON Web Key is not valid.");
            }
            return CryptographyUtils.createLocalClient(jsonWebKey, implClient);
        }
        throw new IllegalStateException("Could not create a local cryptography client.");
    }

    public static Mono<LocalKeyCryptographyClient> retrieveJwkAndCreateLocalAsyncClient(CryptographyClientImpl implClient) {
        if (!CoreUtils.isNullOrEmpty(implClient.getKeyCollection())) {
            Mono<JsonWebKey> jsonWebKeyMono = SECRETS_COLLECTION.equals(implClient.getKeyCollection()) ? implClient.getSecretKeyAsync() : implClient.getKeyAsync().map(keyVaultKeyResponse -> ((KeyVaultKey)keyVaultKeyResponse.getValue()).getKey());
            return jsonWebKeyMono.handle((jsonWebKey, sink2) -> {
                if (!jsonWebKey.isValid()) {
                    sink2.error(new IllegalStateException("The retrieved JSON Web Key is not valid."));
                } else {
                    sink2.next(CryptographyUtils.createLocalClient(jsonWebKey, implClient));
                }
            });
        }
        return Mono.error(new IllegalStateException("Could not create a local cryptography client. Key collection is null or empty."));
    }

    public static LocalKeyCryptographyClient createLocalClient(JsonWebKey jsonWebKey, CryptographyClientImpl implClient) {
        if (!KeyType.values().contains(jsonWebKey.getKeyType())) {
            throw new IllegalArgumentException(String.format("The JSON Web Key type: %s is not supported.", jsonWebKey.getKeyType().toString()));
        }
        if (jsonWebKey.getKeyType().equals(KeyType.RSA) || jsonWebKey.getKeyType().equals(KeyType.RSA_HSM)) {
            return new RsaKeyCryptographyClient(jsonWebKey, implClient);
        }
        if (jsonWebKey.getKeyType().equals(KeyType.EC) || jsonWebKey.getKeyType().equals(KeyType.EC_HSM)) {
            return new EcKeyCryptographyClient(jsonWebKey, implClient);
        }
        if (jsonWebKey.getKeyType().equals(KeyType.OCT) || jsonWebKey.getKeyType().equals(KeyType.OCT_HSM)) {
            return new AesKeyCryptographyClient(jsonWebKey, implClient);
        }
        throw new IllegalStateException("Could not create local cryptography client.");
    }

    public static void verifyKeyPermissions(JsonWebKey jsonWebKey, KeyOperation keyOperation) {
        if (!jsonWebKey.getKeyOps().contains(keyOperation)) {
            String keyOperationName = keyOperation == null ? null : keyOperation.toString().toLowerCase(Locale.ROOT);
            throw new UnsupportedOperationException(String.format("The %s operation is not allowed for key with id: %s", keyOperationName, jsonWebKey.getId()));
        }
    }

    public static boolean isThrowableRetryable(Throwable e) {
        if (e instanceof HttpResponseException) {
            int statusCode = ((HttpResponseException)e).getResponse().getStatusCode();
            return statusCode != 501 && statusCode != 505 && (statusCode >= 500 || statusCode == 408 || statusCode == 429);
        }
        return false;
    }

    static void validate(byte[] key, int keySizeInBytes) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (key.length < keySizeInBytes) {
            throw new IllegalArgumentException(String.format("key must be at least %d bits long", keySizeInBytes << 3));
        }
    }

    static boolean sequenceEqualConstantTime(byte[] self, byte[] other) {
        if (self == null) {
            throw new IllegalArgumentException("self");
        }
        if (other == null) {
            throw new IllegalArgumentException("other");
        }
        long difference = (long)self.length & 0xFFFFFFFFL ^ (long)other.length & 0xFFFFFFFFL;
        for (int i = 0; i < self.length && i < other.length; ++i) {
            difference |= (long)(self[i] ^ other[i]) & 0xFFFFFFFFL;
        }
        return difference == 0L;
    }

    static JsonWebKey transformSecretKey(SecretKey secretKey) {
        return new JsonWebKey().setId(secretKey.getId()).setK(Base64.getUrlDecoder().decode(secretKey.getValue())).setKeyType(KeyType.OCT).setKeyOps(Arrays.asList(KeyOperation.WRAP_KEY, KeyOperation.UNWRAP_KEY, KeyOperation.ENCRYPT, KeyOperation.DECRYPT));
    }

    static JsonWebKeyEncryptionAlgorithm mapKeyEncryptionAlgorithm(EncryptionAlgorithm algorithm) {
        return JsonWebKeyEncryptionAlgorithm.fromString(Objects.toString(algorithm, null));
    }

    static JsonWebKeySignatureAlgorithm mapKeySignatureAlgorithm(SignatureAlgorithm algorithm) {
        return JsonWebKeySignatureAlgorithm.fromString(Objects.toString(algorithm, null));
    }

    static JsonWebKeyEncryptionAlgorithm mapWrapAlgorithm(KeyWrapAlgorithm algorithm) {
        return JsonWebKeyEncryptionAlgorithm.fromString(Objects.toString(algorithm, null));
    }
}

