/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;
import java.util.Objects;

public final class EncryptParameters {
    private final EncryptionAlgorithm algorithm;
    private final byte[] plaintext;
    private final byte[] iv;
    private final byte[] additionalAuthenticatedData;

    public static EncryptParameters createA128CbcParameters(byte[] plaintext) {
        return EncryptParameters.createA128CbcParameters(plaintext, null);
    }

    public static EncryptParameters createA128CbcParameters(byte[] plaintext, byte[] iv) {
        return new EncryptParameters(EncryptionAlgorithm.A128CBC, plaintext, iv, null);
    }

    public static EncryptParameters createA128CbcPadParameters(byte[] plaintext) {
        return EncryptParameters.createA128CbcPadParameters(plaintext, null);
    }

    public static EncryptParameters createA128CbcPadParameters(byte[] plaintext, byte[] iv) {
        return new EncryptParameters(EncryptionAlgorithm.A128CBCPAD, plaintext, iv, null);
    }

    public static EncryptParameters createA128GcmParameters(byte[] plaintext) {
        return EncryptParameters.createA128GcmParameters(plaintext, null);
    }

    public static EncryptParameters createA128GcmParameters(byte[] plaintext, byte[] additionalAuthenticatedData) {
        return new EncryptParameters(EncryptionAlgorithm.A128GCM, plaintext, null, additionalAuthenticatedData);
    }

    public static EncryptParameters createA192CbcParameters(byte[] plaintext) {
        return EncryptParameters.createA192CbcParameters(plaintext, null);
    }

    public static EncryptParameters createA192CbcParameters(byte[] plaintext, byte[] iv) {
        return new EncryptParameters(EncryptionAlgorithm.A192CBC, plaintext, iv, null);
    }

    public static EncryptParameters createA192CbcPadParameters(byte[] plaintext) {
        return EncryptParameters.createA192CbcPadParameters(plaintext, null);
    }

    public static EncryptParameters createA192CbcPadParameters(byte[] plaintext, byte[] iv) {
        return new EncryptParameters(EncryptionAlgorithm.A192CBCPAD, plaintext, iv, null);
    }

    public static EncryptParameters createA192GcmParameters(byte[] plaintext) {
        return EncryptParameters.createA192GcmParameters(plaintext, null);
    }

    public static EncryptParameters createA192GcmParameters(byte[] plaintext, byte[] additionalAuthenticatedData) {
        return new EncryptParameters(EncryptionAlgorithm.A192GCM, plaintext, null, additionalAuthenticatedData);
    }

    public static EncryptParameters createA256CbcParameters(byte[] plaintext) {
        return EncryptParameters.createA256CbcParameters(plaintext, null);
    }

    public static EncryptParameters createA256CbcParameters(byte[] plaintext, byte[] iv) {
        return new EncryptParameters(EncryptionAlgorithm.A256CBC, plaintext, iv, null);
    }

    public static EncryptParameters createA256CbcPadParameters(byte[] plaintext) {
        return EncryptParameters.createA256CbcPadParameters(plaintext, null);
    }

    public static EncryptParameters createA256CbcPadParameters(byte[] plaintext, byte[] iv) {
        return new EncryptParameters(EncryptionAlgorithm.A256CBCPAD, plaintext, iv, null);
    }

    public static EncryptParameters createA256GcmParameters(byte[] plaintext) {
        return EncryptParameters.createA256GcmParameters(plaintext, null);
    }

    public static EncryptParameters createA256GcmParameters(byte[] plaintext, byte[] additionalAuthenticatedData) {
        return new EncryptParameters(EncryptionAlgorithm.A256GCM, plaintext, null, additionalAuthenticatedData);
    }

    public static EncryptParameters createRsa15Parameters(byte[] plaintext) {
        return new EncryptParameters(EncryptionAlgorithm.RSA1_5, plaintext, null, null);
    }

    public static EncryptParameters createRsaOaepParameters(byte[] plaintext) {
        return new EncryptParameters(EncryptionAlgorithm.RSA_OAEP, plaintext, null, null);
    }

    public static EncryptParameters createRsaOaep256Parameters(byte[] plaintext) {
        return new EncryptParameters(EncryptionAlgorithm.RSA_OAEP_256, plaintext, null, null);
    }

    EncryptParameters(EncryptionAlgorithm algorithm, byte[] plaintext, byte[] iv, byte[] additionalAuthenticatedData) {
        Objects.requireNonNull(algorithm, "Encryption algorithm cannot be null.");
        Objects.requireNonNull(plaintext, "Plaintext content to be encrypted cannot be null.");
        this.algorithm = algorithm;
        this.plaintext = CoreUtils.clone(plaintext);
        this.iv = CoreUtils.clone(iv);
        this.additionalAuthenticatedData = CoreUtils.clone(additionalAuthenticatedData);
    }

    public EncryptionAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getPlainText() {
        return CoreUtils.clone(this.plaintext);
    }

    public byte[] getIv() {
        return CoreUtils.clone(this.iv);
    }

    public byte[] getAdditionalAuthenticatedData() {
        return CoreUtils.clone(this.additionalAuthenticatedData);
    }
}

