/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.implementation.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.implementation.models.SecretAttributes;
import java.io.IOException;
import java.util.Map;

public class SecretItem
implements JsonSerializable<SecretItem> {
    private String id;
    private SecretAttributes attributes;
    private Map<String, String> tags;
    private String contentType;
    private Boolean managed;

    public String getId() {
        return this.id;
    }

    public SecretItem setId(String id) {
        this.id = id;
        return this;
    }

    public SecretAttributes getAttributes() {
        return this.attributes;
    }

    public SecretItem setAttributes(SecretAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public SecretItem setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public SecretItem setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public Boolean isManaged() {
        return this.managed;
    }

    SecretItem setManaged(Boolean managed) {
        this.managed = managed;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("attributes", this.attributes);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeStringField("contentType", this.contentType);
        return jsonWriter.writeEndObject();
    }

    public static SecretItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecretItem deserializedSecretItem = new SecretItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSecretItem.id = reader.getString();
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    deserializedSecretItem.attributes = SecretAttributes.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedSecretItem.tags = tags;
                    continue;
                }
                if ("contentType".equals(fieldName)) {
                    deserializedSecretItem.contentType = reader.getString();
                    continue;
                }
                if ("managed".equals(fieldName)) {
                    deserializedSecretItem.managed = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecretItem;
        });
    }
}

