/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.blob.models;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaders;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpRequest;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.ResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.StreamResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.ProgressReporter;
import com.dataiku.dss.shadelibazure.com.azure.core.util.io.IOUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.accesshelpers.BlobDownloadAsyncResponseConstructorProxy;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.models.BlobsDownloadHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.util.ModelHelper;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobDownloadHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.DownloadRetryOptions;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.util.Objects;
import java.util.function.BiFunction;

public final class BlobDownloadAsyncResponse
extends ResponseBase<BlobDownloadHeaders, Flux<ByteBuffer>>
implements Closeable {
    private static final ByteBuffer EMPTY_BUFFER;
    private final StreamResponse sourceResponse;
    private final BiFunction<Throwable, Long, Mono<StreamResponse>> onErrorResume;
    private final DownloadRetryOptions retryOptions;

    public BlobDownloadAsyncResponse(HttpRequest request, int statusCode, HttpHeaders headers, Flux<ByteBuffer> value, BlobDownloadHeaders deserializedHeaders) {
        super(request, statusCode, headers, value, deserializedHeaders);
        this.sourceResponse = null;
        this.onErrorResume = null;
        this.retryOptions = null;
    }

    BlobDownloadAsyncResponse(StreamResponse sourceResponse, BiFunction<Throwable, Long, Mono<StreamResponse>> onErrorResume, DownloadRetryOptions retryOptions) {
        super(sourceResponse.getRequest(), sourceResponse.getStatusCode(), sourceResponse.getHeaders(), BlobDownloadAsyncResponse.createResponseFlux(sourceResponse, onErrorResume, retryOptions), BlobDownloadAsyncResponse.extractHeaders(sourceResponse));
        this.sourceResponse = Objects.requireNonNull(sourceResponse, "'sourceResponse' must not be null");
        this.onErrorResume = Objects.requireNonNull(onErrorResume, "'onErrorResume' must not be null");
        this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' must not be null");
    }

    private static BlobDownloadHeaders extractHeaders(StreamResponse response) {
        HttpHeaders headers = response.getHeaders();
        return ModelHelper.populateBlobDownloadHeaders(new BlobsDownloadHeaders(headers), ModelHelper.getErrorCode(headers));
    }

    private static Flux<ByteBuffer> createResponseFlux(StreamResponse sourceResponse, BiFunction<Throwable, Long, Mono<StreamResponse>> onErrorResume, DownloadRetryOptions retryOptions) {
        return FluxUtil.createRetriableDownloadFlux(sourceResponse::getValue, (throwable, position) -> ((Mono)onErrorResume.apply((Throwable)throwable, (Long)position)).flatMapMany(StreamResponse::getValue), retryOptions.getMaxRetryRequests()).defaultIfEmpty(EMPTY_BUFFER);
    }

    public Mono<Void> writeValueToAsync(AsynchronousByteChannel channel, ProgressReporter progressReporter) {
        Objects.requireNonNull(channel, "'channel' must not be null");
        if (this.sourceResponse != null) {
            return IOUtils.transferStreamResponseToAsynchronousByteChannel(channel, this.sourceResponse, this.onErrorResume, progressReporter, this.retryOptions.getMaxRetryRequests());
        }
        if (super.getValue() != null) {
            return FluxUtil.writeToAsynchronousByteChannel(FluxUtil.addProgressReporting((Flux)super.getValue(), progressReporter), channel);
        }
        return Mono.empty();
    }

    @Override
    public void close() throws IOException {
        if (this.sourceResponse != null) {
            this.sourceResponse.close();
        } else {
            ((Flux)super.getValue()).subscribe().dispose();
        }
    }

    static {
        BlobDownloadAsyncResponseConstructorProxy.setAccessor(BlobDownloadAsyncResponse::new);
        EMPTY_BUFFER = ByteBuffer.allocate(0);
    }
}

