/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.core.client.traits.AzureNamedKeyCredentialTrait;
import com.dataiku.dss.shadelibazure.com.azure.core.client.traits.AzureSasCredentialTrait;
import com.dataiku.dss.shadelibazure.com.azure.core.client.traits.ConfigurationTrait;
import com.dataiku.dss.shadelibazure.com.azure.core.client.traits.EndpointTrait;
import com.dataiku.dss.shadelibazure.com.azure.core.client.traits.HttpTrait;
import com.dataiku.dss.shadelibazure.com.azure.core.client.traits.TokenCredentialTrait;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.AzureNamedKeyCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.AzureSasCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpClient;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelinePosition;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpLogOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpPipelinePolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.RetryOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.util.ClientOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Configuration;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.BlobContainerClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.BlobUrlParts;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobAudience;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.StorageSharedKeyCredential;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.policy.RequestRetryOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.DataLakeFileSystemAsyncClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.DataLakeFileSystemClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.DataLakeServiceVersion;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.Transforms;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.implementation.util.BuilderHelper;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.implementation.util.DataLakeImplUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.implementation.util.TransformUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.CustomerProvidedKey;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.DataLakeAudience;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.options.FileSystemEncryptionScopeOptions;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={DataLakeFileSystemClient.class, DataLakeFileSystemAsyncClient.class})
public class DataLakeFileSystemClientBuilder
implements TokenCredentialTrait<DataLakeFileSystemClientBuilder>,
AzureNamedKeyCredentialTrait<DataLakeFileSystemClientBuilder>,
AzureSasCredentialTrait<DataLakeFileSystemClientBuilder>,
HttpTrait<DataLakeFileSystemClientBuilder>,
ConfigurationTrait<DataLakeFileSystemClientBuilder>,
EndpointTrait<DataLakeFileSystemClientBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(DataLakeFileSystemClientBuilder.class);
    private final BlobContainerClientBuilder blobContainerClientBuilder;
    private String endpoint;
    private String accountName;
    private String fileSystemName;
    private StorageSharedKeyCredential storageSharedKeyCredential;
    private TokenCredential tokenCredential;
    private AzureSasCredential azureSasCredential;
    private HttpClient httpClient;
    private final List<HttpPipelinePolicy> perCallPolicies = new ArrayList<HttpPipelinePolicy>();
    private final List<HttpPipelinePolicy> perRetryPolicies = new ArrayList<HttpPipelinePolicy>();
    private HttpLogOptions logOptions;
    private RequestRetryOptions retryOptions;
    private RetryOptions coreRetryOptions;
    private HttpPipeline httpPipeline;
    private ClientOptions clientOptions = new ClientOptions();
    private Configuration configuration;
    private DataLakeServiceVersion version;
    private DataLakeAudience audience;

    public DataLakeFileSystemClientBuilder() {
        this.logOptions = DataLakeFileSystemClientBuilder.getDefaultHttpLogOptions();
        this.blobContainerClientBuilder = new BlobContainerClientBuilder();
        this.blobContainerClientBuilder.addPolicy(BuilderHelper.getBlobUserAgentModificationPolicy());
    }

    private DataLakeServiceVersion getServiceVersion() {
        return this.version != null ? this.version : DataLakeServiceVersion.getLatest();
    }

    private HttpPipeline constructPipeline() {
        return this.httpPipeline != null ? this.httpPipeline : BuilderHelper.buildPipeline(this.storageSharedKeyCredential, this.tokenCredential, this.azureSasCredential, this.endpoint, this.retryOptions, this.coreRetryOptions, this.logOptions, this.clientOptions, this.httpClient, this.perCallPolicies, this.perRetryPolicies, this.configuration, this.audience, LOGGER);
    }

    public DataLakeFileSystemClient buildClient() {
        DataLakeFileSystemAsyncClient asyncClient = this.buildAsyncClient();
        String dataLakeFileSystemName = CoreUtils.isNullOrEmpty(this.fileSystemName) ? "$root" : this.fileSystemName;
        return new DataLakeFileSystemClient(asyncClient, this.blobContainerClientBuilder.buildClient(), asyncClient.getHttpPipeline(), this.endpoint, this.getServiceVersion(), this.accountName, dataLakeFileSystemName, this.azureSasCredential, this.tokenCredential != null);
    }

    public DataLakeFileSystemAsyncClient buildAsyncClient() {
        String dataLakeFileSystemName = CoreUtils.isNullOrEmpty(this.fileSystemName) ? "$root" : this.fileSystemName;
        return new DataLakeFileSystemAsyncClient(this.constructPipeline(), this.endpoint, this.getServiceVersion(), this.accountName, dataLakeFileSystemName, this.blobContainerClientBuilder.buildAsyncClient(), this.azureSasCredential, this.tokenCredential != null);
    }

    @Override
    public DataLakeFileSystemClientBuilder endpoint(String endpoint) {
        endpoint = DataLakeImplUtils.endpointToDesiredEndpoint(endpoint, "dfs", "blob");
        this.blobContainerClientBuilder.endpoint(DataLakeImplUtils.endpointToDesiredEndpoint(endpoint, "blob", "dfs"));
        try {
            URL url = new URL(endpoint);
            BlobUrlParts parts = BlobUrlParts.parse(url);
            this.accountName = parts.getAccountName();
            this.fileSystemName = parts.getBlobContainerName() == null ? this.fileSystemName : parts.getBlobContainerName();
            this.endpoint = BuilderHelper.getEndpoint(parts);
            String sasToken = parts.getCommonSasQueryParameters().encode();
            if (!CoreUtils.isNullOrEmpty(sasToken)) {
                this.sasToken(sasToken);
            }
        }
        catch (MalformedURLException ex) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("The Azure Storage Datalake endpoint url is malformed.", ex));
        }
        return this;
    }

    public DataLakeFileSystemClientBuilder credential(StorageSharedKeyCredential credential) {
        this.blobContainerClientBuilder.credential(credential);
        this.storageSharedKeyCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.tokenCredential = null;
        this.azureSasCredential = null;
        return this;
    }

    @Override
    public DataLakeFileSystemClientBuilder credential(AzureNamedKeyCredential credential) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        return this.credential(StorageSharedKeyCredential.fromAzureNamedKeyCredential(credential));
    }

    @Override
    public DataLakeFileSystemClientBuilder credential(TokenCredential credential) {
        this.blobContainerClientBuilder.credential(credential);
        this.tokenCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.storageSharedKeyCredential = null;
        this.azureSasCredential = null;
        return this;
    }

    public DataLakeFileSystemClientBuilder sasToken(String sasToken) {
        this.blobContainerClientBuilder.sasToken(sasToken);
        this.azureSasCredential = new AzureSasCredential(Objects.requireNonNull(sasToken, "'sasToken' cannot be null."));
        this.storageSharedKeyCredential = null;
        this.tokenCredential = null;
        return this;
    }

    @Override
    public DataLakeFileSystemClientBuilder credential(AzureSasCredential credential) {
        this.blobContainerClientBuilder.credential(credential);
        this.azureSasCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        return this;
    }

    public DataLakeFileSystemClientBuilder setAnonymousAccess() {
        this.blobContainerClientBuilder.setAnonymousAccess();
        this.storageSharedKeyCredential = null;
        this.tokenCredential = null;
        this.azureSasCredential = null;
        return this;
    }

    public DataLakeFileSystemClientBuilder fileSystemEncryptionScopeOptions(FileSystemEncryptionScopeOptions fileSystemEncryptionScopeOptions) {
        this.blobContainerClientBuilder.blobContainerEncryptionScope(Transforms.toBlobContainerEncryptionScope(fileSystemEncryptionScopeOptions));
        return this;
    }

    public DataLakeFileSystemClientBuilder fileSystemName(String fileSystemName) {
        this.blobContainerClientBuilder.containerName(fileSystemName);
        this.fileSystemName = fileSystemName;
        return this;
    }

    @Override
    public DataLakeFileSystemClientBuilder httpClient(HttpClient httpClient) {
        this.blobContainerClientBuilder.httpClient(httpClient);
        if (this.httpClient != null && httpClient == null) {
            LOGGER.info("'httpClient' is being set to 'null' when it was previously configured.");
        }
        this.httpClient = httpClient;
        return this;
    }

    public static HttpLogOptions getDefaultHttpLogOptions() {
        return BuilderHelper.getDefaultHttpLogOptions();
    }

    @Override
    public DataLakeFileSystemClientBuilder addPolicy(HttpPipelinePolicy pipelinePolicy) {
        this.blobContainerClientBuilder.addPolicy(pipelinePolicy);
        Objects.requireNonNull(pipelinePolicy, "'pipelinePolicy' cannot be null");
        if (pipelinePolicy.getPipelinePosition() == HttpPipelinePosition.PER_CALL) {
            this.perCallPolicies.add(pipelinePolicy);
        } else {
            this.perRetryPolicies.add(pipelinePolicy);
        }
        return this;
    }

    @Override
    public DataLakeFileSystemClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.blobContainerClientBuilder.httpLogOptions(logOptions);
        this.logOptions = Objects.requireNonNull(logOptions, "'logOptions' cannot be null.");
        return this;
    }

    @Override
    public DataLakeFileSystemClientBuilder configuration(Configuration configuration) {
        this.blobContainerClientBuilder.configuration(configuration);
        this.configuration = configuration;
        return this;
    }

    public DataLakeFileSystemClientBuilder retryOptions(RequestRetryOptions retryOptions) {
        this.blobContainerClientBuilder.retryOptions(retryOptions);
        this.retryOptions = retryOptions;
        return this;
    }

    @Override
    public DataLakeFileSystemClientBuilder retryOptions(RetryOptions retryOptions) {
        this.blobContainerClientBuilder.retryOptions(retryOptions);
        this.coreRetryOptions = retryOptions;
        return this;
    }

    @Override
    public DataLakeFileSystemClientBuilder pipeline(HttpPipeline httpPipeline) {
        this.blobContainerClientBuilder.pipeline(httpPipeline);
        if (this.httpPipeline != null && httpPipeline == null) {
            LOGGER.info("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.httpPipeline = httpPipeline;
        return this;
    }

    @Override
    public DataLakeFileSystemClientBuilder clientOptions(ClientOptions clientOptions) {
        this.blobContainerClientBuilder.clientOptions(clientOptions);
        this.clientOptions = Objects.requireNonNull(clientOptions, "'clientOptions' cannot be null.");
        return this;
    }

    public DataLakeFileSystemClientBuilder serviceVersion(DataLakeServiceVersion version) {
        this.blobContainerClientBuilder.serviceVersion(TransformUtils.toBlobServiceVersion(version));
        this.version = version;
        return this;
    }

    public DataLakeFileSystemClientBuilder customerProvidedKey(CustomerProvidedKey customerProvidedKey) {
        if (customerProvidedKey == null) {
            this.blobContainerClientBuilder.customerProvidedKey(null);
        } else {
            this.blobContainerClientBuilder.customerProvidedKey(Transforms.toBlobCustomerProvidedKey(customerProvidedKey));
        }
        return this;
    }

    public DataLakeFileSystemClientBuilder audience(DataLakeAudience audience) {
        this.audience = audience;
        if (audience != null) {
            this.blobContainerClientBuilder.audience(BlobAudience.fromString(audience.toString()));
        }
        return this;
    }
}

