/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceClient;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.AzureSasCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.SimpleResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.BlobContainerAsyncClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.BlobServiceAsyncClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobContainerItem;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobServiceProperties;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.sas.AccountSasSignatureValues;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.DataLakeFileSystemAsyncClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.DataLakeServiceClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.DataLakeServiceVersion;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.Transforms;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.implementation.util.DataLakeImplUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.DataLakeServiceProperties;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.FileSystemItem;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.ListFileSystemsOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.PublicAccessType;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.UserDelegationKey;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.options.FileSystemUndeleteOptions;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@ServiceClient(builder=DataLakeServiceClientBuilder.class, isAsync=true)
public class DataLakeServiceAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(DataLakeServiceAsyncClient.class);
    private final HttpPipeline pipeline;
    private final String url;
    private final String accountName;
    private final DataLakeServiceVersion serviceVersion;
    private final BlobServiceAsyncClient blobServiceAsyncClient;
    private final AzureSasCredential sasToken;
    private final boolean isTokenCredentialAuthenticated;

    DataLakeServiceAsyncClient(HttpPipeline pipeline, String url, DataLakeServiceVersion serviceVersion, String accountName, BlobServiceAsyncClient blobServiceAsyncClient, AzureSasCredential sasToken, boolean isTokenCredentialAuthenticated) {
        this.pipeline = pipeline;
        this.url = url;
        this.serviceVersion = serviceVersion;
        this.accountName = accountName;
        this.blobServiceAsyncClient = blobServiceAsyncClient;
        this.sasToken = sasToken;
        this.isTokenCredentialAuthenticated = isTokenCredentialAuthenticated;
    }

    public DataLakeFileSystemAsyncClient getFileSystemAsyncClient(String fileSystemName) {
        if (CoreUtils.isNullOrEmpty(fileSystemName)) {
            fileSystemName = "$root";
        }
        return new DataLakeFileSystemAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), fileSystemName, this.blobServiceAsyncClient.getBlobContainerAsyncClient(fileSystemName), this.sasToken, this.isTokenCredentialAuthenticated);
    }

    public HttpPipeline getHttpPipeline() {
        return this.pipeline;
    }

    public DataLakeServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataLakeFileSystemAsyncClient> createFileSystem(String fileSystemName) {
        return this.createFileSystemWithResponse(fileSystemName, null, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataLakeFileSystemAsyncClient>> createFileSystemWithResponse(String fileSystemName, Map<String, String> metadata, PublicAccessType accessType) {
        DataLakeFileSystemAsyncClient dataLakeFileSystemAsyncClient = this.getFileSystemAsyncClient(fileSystemName);
        return dataLakeFileSystemAsyncClient.createWithResponse(metadata, accessType).map(response -> new SimpleResponse<DataLakeFileSystemAsyncClient>((Response<?>)response, dataLakeFileSystemAsyncClient));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteFileSystem(String fileSystemName) {
        return this.deleteFileSystemWithResponse(fileSystemName, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteFileSystemWithResponse(String fileSystemName, DataLakeRequestConditions requestConditions) {
        return this.getFileSystemAsyncClient(fileSystemName).deleteWithResponse(requestConditions);
    }

    public String getAccountUrl() {
        return this.url;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<FileSystemItem> listFileSystems() {
        return this.listFileSystems(new ListFileSystemsOptions());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<FileSystemItem> listFileSystems(ListFileSystemsOptions options) {
        try {
            return this.listFileSystemsWithOptionalTimeout(options, null);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError(LOGGER, ex);
        }
    }

    PagedFlux<FileSystemItem> listFileSystemsWithOptionalTimeout(ListFileSystemsOptions options, Duration timeout2) {
        PagedFlux<BlobContainerItem> inputPagedFlux = this.blobServiceAsyncClient.listBlobContainers(Transforms.toListBlobContainersOptions(options));
        return PagedFlux.create(() -> (continuationToken, pageSize) -> {
            Flux flux = continuationToken != null && pageSize != null ? inputPagedFlux.byPage(continuationToken, pageSize) : (continuationToken != null ? inputPagedFlux.byPage((String)continuationToken) : (pageSize != null ? inputPagedFlux.byPage(pageSize) : inputPagedFlux.byPage()));
            flux = flux.onErrorMap(DataLakeImplUtils::transformBlobStorageException);
            if (timeout2 != null) {
                flux = flux.timeout(timeout2);
            }
            return flux.map(blobsPagedResponse -> new PagedResponseBase(blobsPagedResponse.getRequest(), blobsPagedResponse.getStatusCode(), blobsPagedResponse.getHeaders(), blobsPagedResponse.getValue().stream().map(Transforms::toFileSystemItem).collect(Collectors.toList()), (String)blobsPagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataLakeServiceProperties> getProperties() {
        return this.getPropertiesWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataLakeServiceProperties>> getPropertiesWithResponse() {
        return this.blobServiceAsyncClient.getPropertiesWithResponse().onErrorMap(DataLakeImplUtils::transformBlobStorageException).map(response -> new SimpleResponse<DataLakeServiceProperties>((Response<?>)response, Transforms.toDataLakeServiceProperties((BlobServiceProperties)response.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setProperties(DataLakeServiceProperties properties) {
        return this.setPropertiesWithResponse(properties).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setPropertiesWithResponse(DataLakeServiceProperties properties) {
        return this.blobServiceAsyncClient.setPropertiesWithResponse(Transforms.toBlobServiceProperties(properties)).onErrorMap(DataLakeImplUtils::transformBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<UserDelegationKey> getUserDelegationKey(OffsetDateTime start, OffsetDateTime expiry) {
        return this.getUserDelegationKeyWithResponse(start, expiry).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<UserDelegationKey>> getUserDelegationKeyWithResponse(OffsetDateTime start, OffsetDateTime expiry) {
        return this.blobServiceAsyncClient.getUserDelegationKeyWithResponse(start, expiry).onErrorMap(DataLakeImplUtils::transformBlobStorageException).map(response -> new SimpleResponse<UserDelegationKey>((Response<?>)response, Transforms.toDataLakeUserDelegationKey((com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.UserDelegationKey)response.getValue())));
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues) {
        return this.blobServiceAsyncClient.generateAccountSas(accountSasSignatureValues);
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues, Context context) {
        return this.generateAccountSas(accountSasSignatureValues, null, context);
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues, Consumer<String> stringToSignHandler, Context context) {
        return this.blobServiceAsyncClient.generateAccountSas(accountSasSignatureValues, stringToSignHandler, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataLakeFileSystemAsyncClient> undeleteFileSystem(String deletedFileSystemName, String deletedFileSystemVersion) {
        return this.undeleteFileSystemWithResponse(new FileSystemUndeleteOptions(deletedFileSystemName, deletedFileSystemVersion)).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataLakeFileSystemAsyncClient>> undeleteFileSystemWithResponse(FileSystemUndeleteOptions options) {
        return this.blobServiceAsyncClient.undeleteBlobContainerWithResponse(Transforms.toBlobContainerUndeleteOptions(options)).onErrorMap(DataLakeImplUtils::transformBlobStorageException).map(response -> new SimpleResponse<DataLakeFileSystemAsyncClient>((Response<?>)response, this.getFileSystemAsyncClient(((BlobContainerAsyncClient)response.getValue()).getBlobContainerName())));
    }
}

