/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaderName;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobAccessPolicy;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobAnalyticsLogging;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobContainerAccessPolicies;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobContainerEncryptionScope;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobContainerItem;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobContainerItemProperties;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobContainerListDetails;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobContainerProperties;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobCorsRule;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobDownloadAsyncResponse;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobDownloadHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobDownloadResponse;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobHttpHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobMetrics;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobProperties;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobQueryArrowField;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobQueryArrowFieldType;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobQueryArrowSerialization;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobQueryAsyncResponse;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobQueryDelimitedSerialization;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobQueryError;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobQueryHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobQueryJsonSerialization;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobQueryParquetSerialization;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobQueryProgress;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobQueryResponse;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobQuerySerialization;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobRange;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobRequestConditions;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobRetentionPolicy;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobServiceProperties;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobSignedIdentifier;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.ListBlobContainersOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.StaticWebsite;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.options.BlobInputStreamOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.options.BlobQueryOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.options.BlockBlobOutputStreamOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.options.UndeleteBlobContainerOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.implementation.models.BlobItemInternal;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.implementation.models.BlobPrefix;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.implementation.models.CpkInfo;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.implementation.models.Path;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.implementation.util.AccessorUtility;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.AccessTier;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.ArchiveStatus;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.ConsistentReadControl;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.CopyStatusType;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.CustomerProvidedKey;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.DataLakeAccessPolicy;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.DataLakeAnalyticsLogging;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.DataLakeCorsRule;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.DataLakeMetrics;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.DataLakeRetentionPolicy;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.DataLakeServiceProperties;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.DataLakeSignedIdentifier;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.DataLakeStaticWebsite;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.DownloadRetryOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.EncryptionAlgorithmType;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.FileQueryArrowField;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.FileQueryArrowSerialization;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.FileQueryAsyncResponse;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.FileQueryDelimitedSerialization;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.FileQueryError;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.FileQueryHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.FileQueryJsonSerialization;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.FileQueryParquetSerialization;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.FileQueryProgress;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.FileQueryResponse;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.FileQuerySerialization;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.FileRange;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.FileReadAsyncResponse;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.FileReadHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.FileReadResponse;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.FileSystemAccessPolicies;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.FileSystemItem;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.FileSystemItemProperties;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.FileSystemListDetails;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.FileSystemProperties;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.LeaseDurationType;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.LeaseStateType;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.LeaseStatusType;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.ListFileSystemsOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.PathAccessControlEntry;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.PathDeletedItem;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.PathHttpHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.PathItem;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.PathProperties;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.PublicAccessType;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.UserDelegationKey;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.options.DataLakeFileInputStreamOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.options.DataLakeFileOutputStreamOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.options.FileQueryOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.options.FileSystemEncryptionScopeOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.options.FileSystemUndeleteOptions;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

class Transforms {
    private static final ClientLogger LOGGER = new ClientLogger(Transforms.class);
    private static final String SERIALIZATION_MESSAGE = String.format("'serialization' must be one of %s, %s, %s or %s.", FileQueryJsonSerialization.class.getSimpleName(), FileQueryDelimitedSerialization.class.getSimpleName(), FileQueryArrowSerialization.class.getSimpleName(), FileQueryParquetSerialization.class.getSimpleName());
    private static final long EPOCH_CONVERSION;
    public static final HttpHeaderName X_MS_ENCRYPTION_CONTEXT;
    public static final HttpHeaderName X_MS_OWNER;
    public static final HttpHeaderName X_MS_GROUP;
    public static final HttpHeaderName X_MS_PERMISSIONS;
    public static final HttpHeaderName X_MS_CONTINUATION;
    public static final HttpHeaderName X_MS_ACL;

    Transforms() {
    }

    static com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.PublicAccessType toBlobPublicAccessType(PublicAccessType fileSystemPublicAccessType) {
        if (fileSystemPublicAccessType == null) {
            return null;
        }
        return com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.PublicAccessType.fromString(fileSystemPublicAccessType.toString());
    }

    private static LeaseDurationType toDataLakeLeaseDurationType(com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.LeaseDurationType blobLeaseDurationType) {
        if (blobLeaseDurationType == null) {
            return null;
        }
        return LeaseDurationType.fromString(blobLeaseDurationType.toString());
    }

    private static LeaseStateType toDataLakeLeaseStateType(com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.LeaseStateType blobLeaseStateType) {
        if (blobLeaseStateType == null) {
            return null;
        }
        return LeaseStateType.fromString(blobLeaseStateType.toString());
    }

    private static LeaseStatusType toDataLakeLeaseStatusType(com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.LeaseStatusType blobLeaseStatusType) {
        if (blobLeaseStatusType == null) {
            return null;
        }
        return LeaseStatusType.fromString(blobLeaseStatusType.toString());
    }

    private static PublicAccessType toDataLakePublicAccessType(com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.PublicAccessType blobPublicAccessType) {
        if (blobPublicAccessType == null) {
            return null;
        }
        return PublicAccessType.fromString(blobPublicAccessType.toString());
    }

    private static CopyStatusType toDataLakeCopyStatusType(com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.CopyStatusType blobCopyStatus) {
        if (blobCopyStatus == null) {
            return null;
        }
        return CopyStatusType.fromString(blobCopyStatus.toString());
    }

    private static ArchiveStatus toDataLakeArchiveStatus(com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.ArchiveStatus blobArchiveStatus) {
        if (blobArchiveStatus == null) {
            return null;
        }
        return ArchiveStatus.fromString(blobArchiveStatus.toString());
    }

    private static AccessTier toDataLakeAccessTier(com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.AccessTier blobAccessTier) {
        if (blobAccessTier == null) {
            return null;
        }
        return AccessTier.fromString(blobAccessTier.toString());
    }

    static FileSystemProperties toFileSystemProperties(BlobContainerProperties blobContainerProperties) {
        if (blobContainerProperties == null) {
            return null;
        }
        FileSystemProperties fileSystemProperties = new FileSystemProperties(blobContainerProperties.getMetadata(), blobContainerProperties.getETag(), blobContainerProperties.getLastModified(), Transforms.toDataLakeLeaseDurationType(blobContainerProperties.getLeaseDuration()), Transforms.toDataLakeLeaseStateType(blobContainerProperties.getLeaseState()), Transforms.toDataLakeLeaseStatusType(blobContainerProperties.getLeaseStatus()), Transforms.toDataLakePublicAccessType(blobContainerProperties.getBlobPublicAccess()), blobContainerProperties.hasImmutabilityPolicy(), blobContainerProperties.hasLegalHold());
        return AccessorUtility.getFileSystemPropertiesAccessor().setFileSystemProperties(fileSystemProperties, blobContainerProperties.getDefaultEncryptionScope(), blobContainerProperties.isEncryptionScopeOverridePrevented());
    }

    private static BlobContainerListDetails toBlobContainerListDetails(FileSystemListDetails fileSystemListDetails) {
        if (fileSystemListDetails == null) {
            return null;
        }
        return new BlobContainerListDetails().setRetrieveMetadata(fileSystemListDetails.getRetrieveMetadata()).setRetrieveDeleted(fileSystemListDetails.getRetrieveDeleted()).setRetrieveSystemContainers(fileSystemListDetails.getRetrieveSystemFileSystems());
    }

    static ListBlobContainersOptions toListBlobContainersOptions(ListFileSystemsOptions listFileSystemsOptions) {
        if (listFileSystemsOptions == null) {
            return null;
        }
        return new ListBlobContainersOptions().setDetails(Transforms.toBlobContainerListDetails(listFileSystemsOptions.getDetails())).setMaxResultsPerPage(listFileSystemsOptions.getMaxResultsPerPage()).setPrefix(listFileSystemsOptions.getPrefix());
    }

    static UserDelegationKey toDataLakeUserDelegationKey(com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.UserDelegationKey blobUserDelegationKey) {
        if (blobUserDelegationKey == null) {
            return null;
        }
        return new UserDelegationKey().setSignedExpiry(blobUserDelegationKey.getSignedExpiry()).setSignedObjectId(blobUserDelegationKey.getSignedObjectId()).setSignedTenantId(blobUserDelegationKey.getSignedTenantId()).setSignedService(blobUserDelegationKey.getSignedService()).setSignedStart(blobUserDelegationKey.getSignedStart()).setSignedVersion(blobUserDelegationKey.getSignedVersion()).setValue(blobUserDelegationKey.getValue());
    }

    static BlobHttpHeaders toBlobHttpHeaders(PathHttpHeaders pathHTTPHeaders) {
        if (pathHTTPHeaders == null) {
            return null;
        }
        return new BlobHttpHeaders().setCacheControl(pathHTTPHeaders.getCacheControl()).setContentDisposition(pathHTTPHeaders.getContentDisposition()).setContentEncoding(pathHTTPHeaders.getContentEncoding()).setContentLanguage(pathHTTPHeaders.getContentLanguage()).setContentType(pathHTTPHeaders.getContentType()).setContentMd5(pathHTTPHeaders.getContentMd5());
    }

    static BlobInputStreamOptions toBlobInputStreamOptions(DataLakeFileInputStreamOptions options) {
        if (options == null) {
            return null;
        }
        return new BlobInputStreamOptions().setBlockSize(options.getBlockSize()).setRange(Transforms.toBlobRange(options.getRange())).setRequestConditions(Transforms.toBlobRequestConditions(options.getRequestConditions())).setConsistentReadControl(Transforms.toBlobConsistentReadControl(options.getConsistentReadControl()));
    }

    static com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.ConsistentReadControl toBlobConsistentReadControl(ConsistentReadControl datalakeConsistentReadControl) {
        if (datalakeConsistentReadControl == null) {
            return null;
        }
        switch (datalakeConsistentReadControl) {
            case NONE: {
                return com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.ConsistentReadControl.NONE;
            }
            case ETAG: {
                return com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.ConsistentReadControl.ETAG;
            }
        }
        throw new IllegalArgumentException("Could not convert ConsistentReadControl");
    }

    static BlobRange toBlobRange(FileRange fileRange) {
        if (fileRange == null) {
            return null;
        }
        return new BlobRange(fileRange.getOffset(), fileRange.getCount());
    }

    static com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.DownloadRetryOptions toBlobDownloadRetryOptions(DownloadRetryOptions dataLakeOptions) {
        if (dataLakeOptions == null) {
            return null;
        }
        return new com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.DownloadRetryOptions().setMaxRetryRequests(dataLakeOptions.getMaxRetryRequests());
    }

    static PathProperties toPathProperties(BlobProperties properties) {
        return Transforms.toPathProperties(properties, null);
    }

    static PathProperties toPathProperties(BlobProperties properties, Response<?> r) {
        if (properties == null) {
            return null;
        }
        PathProperties pathProperties = new PathProperties(properties.getCreationTime(), properties.getLastModified(), properties.getETag(), properties.getBlobSize(), properties.getContentType(), properties.getContentMd5(), properties.getContentEncoding(), properties.getContentDisposition(), properties.getContentLanguage(), properties.getCacheControl(), Transforms.toDataLakeLeaseStatusType(properties.getLeaseStatus()), Transforms.toDataLakeLeaseStateType(properties.getLeaseState()), Transforms.toDataLakeLeaseDurationType(properties.getLeaseDuration()), properties.getCopyId(), Transforms.toDataLakeCopyStatusType(properties.getCopyStatus()), properties.getCopySource(), properties.getCopyProgress(), properties.getCopyCompletionTime(), properties.getCopyStatusDescription(), properties.isServerEncrypted(), properties.isIncrementalCopy(), Transforms.toDataLakeAccessTier(properties.getAccessTier()), Transforms.toDataLakeArchiveStatus(properties.getArchiveStatus()), properties.getEncryptionKeySha256(), properties.getAccessTierChangeTime(), properties.getMetadata(), properties.getExpiresOn());
        if (r == null) {
            return pathProperties;
        }
        String encryptionContext = r.getHeaders().getValue(X_MS_ENCRYPTION_CONTEXT);
        String owner = r.getHeaders().getValue(X_MS_OWNER);
        String group = r.getHeaders().getValue(X_MS_GROUP);
        String permissions = r.getHeaders().getValue(X_MS_PERMISSIONS);
        String acl = r.getHeaders().getValue(X_MS_ACL);
        return AccessorUtility.getPathPropertiesAccessor().setPathProperties(pathProperties, properties.getEncryptionScope(), encryptionContext, owner, group, permissions, acl);
    }

    static FileSystemItem toFileSystemItem(BlobContainerItem blobContainerItem) {
        if (blobContainerItem == null) {
            return null;
        }
        return new FileSystemItem().setName(blobContainerItem.getName()).setDeleted(blobContainerItem.isDeleted()).setVersion(blobContainerItem.getVersion()).setMetadata(blobContainerItem.getMetadata()).setProperties(Transforms.toFileSystemItemProperties(blobContainerItem.getProperties()));
    }

    private static FileSystemItemProperties toFileSystemItemProperties(BlobContainerItemProperties blobContainerItemProperties) {
        if (blobContainerItemProperties == null) {
            return null;
        }
        return new FileSystemItemProperties().setETag(blobContainerItemProperties.getETag()).setLastModified(blobContainerItemProperties.getLastModified()).setLeaseStatus(Transforms.toDataLakeLeaseStatusType(blobContainerItemProperties.getLeaseStatus())).setLeaseState(Transforms.toDataLakeLeaseStateType(blobContainerItemProperties.getLeaseState())).setLeaseDuration(Transforms.toDataLakeLeaseDurationType(blobContainerItemProperties.getLeaseDuration())).setPublicAccess(Transforms.toDataLakePublicAccessType(blobContainerItemProperties.getPublicAccess())).setHasLegalHold(blobContainerItemProperties.isHasLegalHold()).setHasImmutabilityPolicy(blobContainerItemProperties.isHasImmutabilityPolicy()).setEncryptionScope(blobContainerItemProperties.getDefaultEncryptionScope()).setEncryptionScopeOverridePrevented(blobContainerItemProperties.isEncryptionScopeOverridePrevented());
    }

    static PathItem toPathItem(Path path) {
        if (path == null) {
            return null;
        }
        PathItem pathItem = new PathItem(path.getETag(), Transforms.parseDateOrNull(path.getLastModified()), path.getContentLength() == null ? 0L : path.getContentLength(), path.getGroup(), path.isDirectory() != null && path.isDirectory() != false, path.getName(), path.getOwner(), path.getPermissions(), Transforms.parseWindowsFileTimeOrDateString(path.getCreationTime()), Transforms.parseWindowsFileTimeOrDateString(path.getExpiryTime()));
        return AccessorUtility.getPathItemAccessor().setPathItemProperties(pathItem, path.getEncryptionScope(), path.getEncryptionContext());
    }

    static OffsetDateTime parseWindowsFileTimeOrDateString(String date) {
        if (date == null) {
            return null;
        }
        try {
            return Transforms.fromWindowsFileTimeOrNull(Long.parseLong(date));
        }
        catch (Exception ex) {
            if (ex instanceof NumberFormatException) {
                return Transforms.parseDateOrNull(date);
            }
            throw LOGGER.logExceptionAsError(new RuntimeException("Failed to parse date string: " + date, ex));
        }
    }

    private static OffsetDateTime parseDateOrNull(String date) {
        try {
            return date == null ? null : OffsetDateTime.parse(date, DateTimeFormatter.RFC_1123_DATE_TIME);
        }
        catch (Exception ex) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Failed to parse date string: " + date, ex));
        }
    }

    private static OffsetDateTime fromWindowsFileTimeOrNull(long fileTime) {
        if (fileTime == 0L) {
            return null;
        }
        long fileTimeMs = fileTime / 10000L;
        long fileTimeUnixEpoch = fileTimeMs - EPOCH_CONVERSION;
        return Instant.ofEpochMilli(fileTimeUnixEpoch).atOffset(ZoneOffset.UTC);
    }

    static BlobRequestConditions toBlobRequestConditions(DataLakeRequestConditions requestConditions) {
        if (requestConditions == null) {
            return null;
        }
        return new BlobRequestConditions().setLeaseId(requestConditions.getLeaseId()).setIfUnmodifiedSince(requestConditions.getIfUnmodifiedSince()).setIfNoneMatch(requestConditions.getIfNoneMatch()).setIfMatch(requestConditions.getIfMatch()).setIfModifiedSince(requestConditions.getIfModifiedSince());
    }

    static FileReadResponse toFileReadResponse(BlobDownloadResponse r) {
        if (r == null) {
            return null;
        }
        return new FileReadResponse(Transforms.toFileReadAsyncResponse(new BlobDownloadAsyncResponse(r.getRequest(), r.getStatusCode(), r.getHeaders(), null, (BlobDownloadHeaders)r.getDeserializedHeaders())));
    }

    static FileReadAsyncResponse toFileReadAsyncResponse(BlobDownloadAsyncResponse r) {
        if (r == null) {
            return null;
        }
        return new FileReadAsyncResponse(r.getRequest(), r.getStatusCode(), r.getHeaders(), (Flux)r.getValue(), Transforms.toPathReadHeaders((BlobDownloadHeaders)r.getDeserializedHeaders(), r.getHeaders().getValue(X_MS_ENCRYPTION_CONTEXT), r.getHeaders().getValue(X_MS_ACL)));
    }

    private static FileReadHeaders toPathReadHeaders(BlobDownloadHeaders h2, String encryptionContext, String acl) {
        if (h2 == null) {
            return null;
        }
        return new FileReadHeaders().setLastModified(h2.getLastModified()).setMetadata(h2.getMetadata()).setContentLength(h2.getContentLength()).setContentType(h2.getContentType()).setContentRange(h2.getContentRange()).setETag(h2.getETag()).setContentMd5(h2.getContentMd5()).setContentEncoding(h2.getContentEncoding()).setCacheControl(h2.getCacheControl()).setContentDisposition(h2.getContentDisposition()).setContentLanguage(h2.getContentLanguage()).setCopyCompletionTime(h2.getCopyCompletionTime()).setCopyStatusDescription(h2.getCopyStatusDescription()).setCopyId(h2.getCopyId()).setCopyProgress(h2.getCopyProgress()).setCopySource(h2.getCopySource()).setCopyStatus(Transforms.toDataLakeCopyStatusType(h2.getCopyStatus())).setLeaseDuration(Transforms.toDataLakeLeaseDurationType(h2.getLeaseDuration())).setLeaseState(Transforms.toDataLakeLeaseStateType(h2.getLeaseState())).setLeaseStatus(Transforms.toDataLakeLeaseStatusType(h2.getLeaseStatus())).setClientRequestId(h2.getClientRequestId()).setRequestId(h2.getRequestId()).setVersion(h2.getVersion()).setAcceptRanges(h2.getAcceptRanges()).setDateProperty(h2.getDateProperty()).setServerEncrypted(h2.isServerEncrypted()).setEncryptionKeySha256(h2.getEncryptionKeySha256()).setFileContentMd5(h2.getBlobContentMD5()).setContentCrc64(h2.getContentCrc64()).setErrorCode(h2.getErrorCode()).setCreationTime(h2.getCreationTime()).setEncryptionContext(encryptionContext).setAccessControlList(PathAccessControlEntry.parseList(acl));
    }

    static List<BlobSignedIdentifier> toBlobIdentifierList(List<DataLakeSignedIdentifier> identifiers) {
        if (identifiers == null) {
            return null;
        }
        ArrayList<BlobSignedIdentifier> blobIdentifiers = new ArrayList<BlobSignedIdentifier>();
        for (DataLakeSignedIdentifier identifier : identifiers) {
            blobIdentifiers.add(Transforms.toBlobIdentifier(identifier));
        }
        return blobIdentifiers;
    }

    private static BlobSignedIdentifier toBlobIdentifier(DataLakeSignedIdentifier identifier) {
        if (identifier == null) {
            return null;
        }
        return new BlobSignedIdentifier().setId(identifier.getId()).setAccessPolicy(Transforms.toBlobAccessPolicy(identifier.getAccessPolicy()));
    }

    private static BlobAccessPolicy toBlobAccessPolicy(DataLakeAccessPolicy accessPolicy) {
        if (accessPolicy == null) {
            return null;
        }
        return new BlobAccessPolicy().setExpiresOn(accessPolicy.getExpiresOn()).setStartsOn(accessPolicy.getStartsOn()).setPermissions(accessPolicy.getPermissions());
    }

    static FileSystemAccessPolicies toFileSystemAccessPolicies(BlobContainerAccessPolicies accessPolicies) {
        if (accessPolicies == null) {
            return null;
        }
        return new FileSystemAccessPolicies(Transforms.toDataLakePublicAccessType(accessPolicies.getBlobAccessType()), Transforms.toDataLakeIdentifierList(accessPolicies.getIdentifiers()));
    }

    static List<DataLakeSignedIdentifier> toDataLakeIdentifierList(List<BlobSignedIdentifier> identifiers) {
        if (identifiers == null) {
            return null;
        }
        ArrayList<DataLakeSignedIdentifier> dataLakeIdentifiers = new ArrayList<DataLakeSignedIdentifier>();
        for (BlobSignedIdentifier identifier : identifiers) {
            dataLakeIdentifiers.add(Transforms.toDataLakeIdentifier(identifier));
        }
        return dataLakeIdentifiers;
    }

    private static DataLakeSignedIdentifier toDataLakeIdentifier(BlobSignedIdentifier identifier) {
        if (identifier == null) {
            return null;
        }
        return new DataLakeSignedIdentifier().setId(identifier.getId()).setAccessPolicy(Transforms.toDataLakeAccessPolicy(identifier.getAccessPolicy()));
    }

    private static DataLakeAccessPolicy toDataLakeAccessPolicy(BlobAccessPolicy accessPolicy) {
        if (accessPolicy == null) {
            return null;
        }
        return new DataLakeAccessPolicy().setExpiresOn(accessPolicy.getExpiresOn()).setStartsOn(accessPolicy.getStartsOn()).setPermissions(accessPolicy.getPermissions());
    }

    static BlobQuerySerialization toBlobQuerySerialization(FileQuerySerialization ser) {
        if (ser == null) {
            return null;
        }
        if (ser instanceof FileQueryJsonSerialization) {
            FileQueryJsonSerialization jsonSer = (FileQueryJsonSerialization)ser;
            return new BlobQueryJsonSerialization().setRecordSeparator(jsonSer.getRecordSeparator());
        }
        if (ser instanceof FileQueryDelimitedSerialization) {
            FileQueryDelimitedSerialization delSer = (FileQueryDelimitedSerialization)ser;
            return new BlobQueryDelimitedSerialization().setColumnSeparator(delSer.getColumnSeparator()).setEscapeChar(delSer.getEscapeChar()).setFieldQuote(delSer.getFieldQuote()).setHeadersPresent(delSer.isHeadersPresent()).setRecordSeparator(delSer.getRecordSeparator());
        }
        if (ser instanceof FileQueryArrowSerialization) {
            FileQueryArrowSerialization arrSer = (FileQueryArrowSerialization)ser;
            return new BlobQueryArrowSerialization().setSchema(Transforms.toBlobQueryArrowSchema(arrSer.getSchema()));
        }
        if (ser instanceof FileQueryParquetSerialization) {
            return new BlobQueryParquetSerialization();
        }
        throw new IllegalArgumentException(SERIALIZATION_MESSAGE);
    }

    private static List<BlobQueryArrowField> toBlobQueryArrowSchema(List<FileQueryArrowField> schema) {
        if (schema == null) {
            return null;
        }
        ArrayList<BlobQueryArrowField> blobSchema = new ArrayList<BlobQueryArrowField>(schema.size());
        for (FileQueryArrowField field : schema) {
            blobSchema.add(Transforms.toBlobQueryArrowField(field));
        }
        return blobSchema;
    }

    private static BlobQueryArrowField toBlobQueryArrowField(FileQueryArrowField field) {
        if (field == null) {
            return null;
        }
        return new BlobQueryArrowField(BlobQueryArrowFieldType.fromString(field.getType().toString())).setName(field.getName()).setPrecision(field.getPrecision()).setScale(field.getScale());
    }

    static Consumer<BlobQueryError> toBlobQueryErrorConsumer(Consumer<FileQueryError> er) {
        if (er == null) {
            return null;
        }
        return error -> er.accept(Transforms.toFileQueryError(error));
    }

    static Consumer<BlobQueryProgress> toBlobQueryProgressConsumer(Consumer<FileQueryProgress> pr) {
        if (pr == null) {
            return null;
        }
        return progress -> pr.accept(Transforms.toFileQueryProgress(progress));
    }

    private static FileQueryError toFileQueryError(BlobQueryError error) {
        if (error == null) {
            return null;
        }
        return new FileQueryError(error.isFatal(), error.getName(), error.getDescription(), error.getPosition());
    }

    private static FileQueryProgress toFileQueryProgress(BlobQueryProgress progress) {
        if (progress == null) {
            return null;
        }
        return new FileQueryProgress(progress.getBytesScanned(), progress.getTotalBytes());
    }

    static FileQueryResponse toFileQueryResponse(BlobQueryResponse r) {
        if (r == null) {
            return null;
        }
        return new FileQueryResponse(Transforms.toFileQueryAsyncResponse(new BlobQueryAsyncResponse(r.getRequest(), r.getStatusCode(), r.getHeaders(), null, (BlobQueryHeaders)r.getDeserializedHeaders())));
    }

    static FileQueryAsyncResponse toFileQueryAsyncResponse(BlobQueryAsyncResponse r) {
        if (r == null) {
            return null;
        }
        return new FileQueryAsyncResponse(r.getRequest(), r.getStatusCode(), r.getHeaders(), (Flux)r.getValue(), Transforms.toFileQueryHeaders((BlobQueryHeaders)r.getDeserializedHeaders()));
    }

    private static FileQueryHeaders toFileQueryHeaders(BlobQueryHeaders h2) {
        if (h2 == null) {
            return null;
        }
        return new FileQueryHeaders().setLastModified(h2.getLastModified()).setMetadata(h2.getMetadata()).setContentLength(h2.getContentLength()).setContentType(h2.getContentType()).setContentRange(h2.getContentRange()).setETag(h2.getETag()).setContentMd5(h2.getContentMd5()).setContentEncoding(h2.getContentEncoding()).setCacheControl(h2.getCacheControl()).setContentDisposition(h2.getContentDisposition()).setContentLanguage(h2.getContentLanguage()).setCopyCompletionTime(h2.getCopyCompletionTime()).setCopyStatusDescription(h2.getCopyStatusDescription()).setCopyId(h2.getCopyId()).setCopyProgress(h2.getCopyProgress()).setCopySource(h2.getCopySource()).setCopyStatus(Transforms.toDataLakeCopyStatusType(h2.getCopyStatus())).setLeaseDuration(Transforms.toDataLakeLeaseDurationType(h2.getLeaseDuration())).setLeaseState(Transforms.toDataLakeLeaseStateType(h2.getLeaseState())).setLeaseStatus(Transforms.toDataLakeLeaseStatusType(h2.getLeaseStatus())).setClientRequestId(h2.getClientRequestId()).setRequestId(h2.getRequestId()).setVersion(h2.getVersion()).setAcceptRanges(h2.getAcceptRanges()).setDateProperty(h2.getDateProperty()).setServerEncrypted(h2.isServerEncrypted()).setEncryptionKeySha256(h2.getEncryptionKeySha256()).setFileContentMd5(h2.getContentMd5()).setContentCrc64(h2.getContentCrc64()).setErrorCode(h2.getErrorCode());
    }

    static BlobQueryOptions toBlobQueryOptions(FileQueryOptions options) {
        if (options == null) {
            return null;
        }
        if (options.getOutputStream() == null) {
            return new BlobQueryOptions(options.getExpression()).setInputSerialization(Transforms.toBlobQuerySerialization(options.getInputSerialization())).setOutputSerialization(Transforms.toBlobQuerySerialization(options.getOutputSerialization())).setRequestConditions(Transforms.toBlobRequestConditions(options.getRequestConditions())).setErrorConsumer(Transforms.toBlobQueryErrorConsumer(options.getErrorConsumer())).setProgressConsumer(Transforms.toBlobQueryProgressConsumer(options.getProgressConsumer()));
        }
        return new BlobQueryOptions(options.getExpression(), options.getOutputStream()).setInputSerialization(Transforms.toBlobQuerySerialization(options.getInputSerialization())).setOutputSerialization(Transforms.toBlobQuerySerialization(options.getOutputSerialization())).setRequestConditions(Transforms.toBlobRequestConditions(options.getRequestConditions())).setErrorConsumer(Transforms.toBlobQueryErrorConsumer(options.getErrorConsumer())).setProgressConsumer(Transforms.toBlobQueryProgressConsumer(options.getProgressConsumer()));
    }

    static UndeleteBlobContainerOptions toBlobContainerUndeleteOptions(FileSystemUndeleteOptions options) {
        if (options == null) {
            return null;
        }
        return new UndeleteBlobContainerOptions(options.getDeletedFileSystemName(), options.getDeletedFileSystemVersion()).setDestinationContainerName(options.getDestinationFileSystemName());
    }

    static DataLakeServiceProperties toDataLakeServiceProperties(BlobServiceProperties blobProps) {
        if (blobProps == null) {
            return null;
        }
        return new DataLakeServiceProperties().setDefaultServiceVersion(blobProps.getDefaultServiceVersion()).setCors(blobProps.getCors().stream().map(Transforms::toDataLakeCorsRule).collect(Collectors.toList())).setDeleteRetentionPolicy(Transforms.toDataLakeRetentionPolicy(blobProps.getDeleteRetentionPolicy())).setHourMetrics(Transforms.toDataLakeMetrics(blobProps.getHourMetrics())).setMinuteMetrics(Transforms.toDataLakeMetrics(blobProps.getMinuteMetrics())).setLogging(Transforms.toDataLakeAnalyticsLogging(blobProps.getLogging())).setStaticWebsite(Transforms.toDataLakeStaticWebsite(blobProps.getStaticWebsite()));
    }

    static DataLakeStaticWebsite toDataLakeStaticWebsite(StaticWebsite staticWebsite) {
        if (staticWebsite == null) {
            return null;
        }
        return new DataLakeStaticWebsite().setDefaultIndexDocumentPath(staticWebsite.getDefaultIndexDocumentPath()).setEnabled(staticWebsite.isEnabled()).setErrorDocument404Path(staticWebsite.getErrorDocument404Path()).setIndexDocument(staticWebsite.getIndexDocument());
    }

    static DataLakeAnalyticsLogging toDataLakeAnalyticsLogging(BlobAnalyticsLogging blobLogging) {
        if (blobLogging == null) {
            return null;
        }
        return new DataLakeAnalyticsLogging().setDelete(blobLogging.isDelete()).setRead(blobLogging.isRead()).setWrite(blobLogging.isWrite()).setRetentionPolicy(Transforms.toDataLakeRetentionPolicy(blobLogging.getRetentionPolicy())).setVersion(blobLogging.getVersion());
    }

    static DataLakeCorsRule toDataLakeCorsRule(BlobCorsRule blobRule) {
        if (blobRule == null) {
            return null;
        }
        return new DataLakeCorsRule().setAllowedHeaders(blobRule.getAllowedHeaders()).setAllowedMethods(blobRule.getAllowedMethods()).setAllowedOrigins(blobRule.getAllowedOrigins()).setExposedHeaders(blobRule.getExposedHeaders()).setMaxAgeInSeconds(blobRule.getMaxAgeInSeconds());
    }

    static DataLakeMetrics toDataLakeMetrics(BlobMetrics blobMetrics) {
        if (blobMetrics == null) {
            return null;
        }
        return new DataLakeMetrics().setEnabled(blobMetrics.isEnabled()).setIncludeApis(blobMetrics.isIncludeApis()).setVersion(blobMetrics.getVersion()).setRetentionPolicy(Transforms.toDataLakeRetentionPolicy(blobMetrics.getRetentionPolicy()));
    }

    static DataLakeRetentionPolicy toDataLakeRetentionPolicy(BlobRetentionPolicy blobPolicy) {
        if (blobPolicy == null) {
            return null;
        }
        return new DataLakeRetentionPolicy().setDays(blobPolicy.getDays()).setEnabled(blobPolicy.isEnabled());
    }

    static BlobServiceProperties toBlobServiceProperties(DataLakeServiceProperties datalakeProperties) {
        if (datalakeProperties == null) {
            return null;
        }
        return new BlobServiceProperties().setDefaultServiceVersion(datalakeProperties.getDefaultServiceVersion()).setCors(datalakeProperties.getCors().stream().map(Transforms::toBlobCorsRule).collect(Collectors.toList())).setDeleteRetentionPolicy(Transforms.toBlobRetentionPolicy(datalakeProperties.getDeleteRetentionPolicy())).setHourMetrics(Transforms.toBlobMetrics(datalakeProperties.getHourMetrics())).setMinuteMetrics(Transforms.toBlobMetrics(datalakeProperties.getMinuteMetrics())).setLogging(Transforms.toBlobAnalyticsLogging(datalakeProperties.getLogging())).setStaticWebsite(Transforms.toBlobStaticWebsite(datalakeProperties.getStaticWebsite()));
    }

    static StaticWebsite toBlobStaticWebsite(DataLakeStaticWebsite staticWebsite) {
        if (staticWebsite == null) {
            return null;
        }
        return new StaticWebsite().setDefaultIndexDocumentPath(staticWebsite.getDefaultIndexDocumentPath()).setEnabled(staticWebsite.isEnabled()).setErrorDocument404Path(staticWebsite.getErrorDocument404Path()).setIndexDocument(staticWebsite.getIndexDocument());
    }

    static BlobAnalyticsLogging toBlobAnalyticsLogging(DataLakeAnalyticsLogging datalakeLogging) {
        if (datalakeLogging == null) {
            return null;
        }
        return new BlobAnalyticsLogging().setDelete(datalakeLogging.isDelete()).setRead(datalakeLogging.isRead()).setWrite(datalakeLogging.isWrite()).setRetentionPolicy(Transforms.toBlobRetentionPolicy(datalakeLogging.getRetentionPolicy())).setVersion(datalakeLogging.getVersion());
    }

    static BlobCorsRule toBlobCorsRule(DataLakeCorsRule datalakeRule) {
        if (datalakeRule == null) {
            return null;
        }
        return new BlobCorsRule().setAllowedHeaders(datalakeRule.getAllowedHeaders()).setAllowedMethods(datalakeRule.getAllowedMethods()).setAllowedOrigins(datalakeRule.getAllowedOrigins()).setExposedHeaders(datalakeRule.getExposedHeaders()).setMaxAgeInSeconds(datalakeRule.getMaxAgeInSeconds());
    }

    static BlobMetrics toBlobMetrics(DataLakeMetrics datalakeMetrics) {
        if (datalakeMetrics == null) {
            return null;
        }
        return new BlobMetrics().setEnabled(datalakeMetrics.isEnabled()).setIncludeApis(datalakeMetrics.isIncludeApis()).setVersion(datalakeMetrics.getVersion()).setRetentionPolicy(Transforms.toBlobRetentionPolicy(datalakeMetrics.getRetentionPolicy()));
    }

    static BlobRetentionPolicy toBlobRetentionPolicy(DataLakeRetentionPolicy datalakePolicy) {
        if (datalakePolicy == null) {
            return null;
        }
        return new BlobRetentionPolicy().setDays(datalakePolicy.getDays()).setEnabled(datalakePolicy.isEnabled());
    }

    static PathDeletedItem toPathDeletedItem(BlobItemInternal blobItem) {
        if (blobItem == null) {
            return null;
        }
        return new PathDeletedItem(blobItem.getName(), false, blobItem.getDeletionId(), blobItem.getProperties().getDeletedTime(), blobItem.getProperties().getRemainingRetentionDays());
    }

    static PathDeletedItem toPathDeletedItem(BlobPrefix blobPrefix) {
        return new PathDeletedItem(blobPrefix.getName(), true, null, null, null);
    }

    static com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.CustomerProvidedKey toBlobCustomerProvidedKey(CustomerProvidedKey key) {
        if (key == null) {
            return null;
        }
        return new com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.CustomerProvidedKey(key.getKey());
    }

    static CpkInfo fromBlobCpkInfo(com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.CpkInfo info) {
        if (info == null) {
            return null;
        }
        return new CpkInfo().setEncryptionKey(info.getEncryptionKey()).setEncryptionAlgorithm(EncryptionAlgorithmType.fromString(info.getEncryptionAlgorithm().toString())).setEncryptionKeySha256(info.getEncryptionKeySha256());
    }

    static BlobContainerEncryptionScope toBlobContainerEncryptionScope(FileSystemEncryptionScopeOptions fileSystemEncryptionScope) {
        if (fileSystemEncryptionScope == null) {
            return null;
        }
        return new BlobContainerEncryptionScope().setDefaultEncryptionScope(fileSystemEncryptionScope.getDefaultEncryptionScope()).setEncryptionScopeOverridePrevented(fileSystemEncryptionScope.isEncryptionScopeOverridePrevented());
    }

    static BlockBlobOutputStreamOptions toBlockBlobOutputStreamOptions(DataLakeFileOutputStreamOptions options) {
        if (options == null) {
            return null;
        }
        return new BlockBlobOutputStreamOptions().setParallelTransferOptions(options.getParallelTransferOptions()).setHeaders(Transforms.toBlobHttpHeaders(options.getHeaders())).setMetadata(options.getMetadata()).setTags(options.getTags()).setTier(options.getAccessTier()).setRequestConditions(Transforms.toBlobRequestConditions(options.getRequestConditions()));
    }

    static {
        X_MS_ENCRYPTION_CONTEXT = HttpHeaderName.fromString("x-ms-encryption-context");
        X_MS_OWNER = HttpHeaderName.fromString("x-ms-owner");
        X_MS_GROUP = HttpHeaderName.fromString("x-ms-group");
        X_MS_PERMISSIONS = HttpHeaderName.fromString("x-ms-permissions");
        X_MS_CONTINUATION = HttpHeaderName.fromString("x-ms-continuation");
        X_MS_ACL = HttpHeaderName.fromString("x-ms-acl");
        GregorianCalendar unixEpoch = new GregorianCalendar();
        unixEpoch.clear();
        unixEpoch.set(1970, 0, 1, 0, 0, 0);
        GregorianCalendar windowsEpoch = new GregorianCalendar();
        windowsEpoch.clear();
        windowsEpoch.set(1601, 0, 1, 0, 0, 0);
        EPOCH_CONVERSION = unixEpoch.getTimeInMillis() - windowsEpoch.getTimeInMillis();
    }
}

