/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.implementation.util;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobStorageException;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.DataLakeStorageException;
import com.dataiku.dss.shadelibazure.reactor.core.Exceptions;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class DataLakeImplUtils {
    public static String endpointToDesiredEndpoint(String endpoint, String desiredEndpoint, String currentEndpoint) {
        String desiredStringToMatch = "." + desiredEndpoint + ".";
        String currentRegexToMatch = "\\." + currentEndpoint + "\\.";
        if (endpoint.contains(desiredStringToMatch)) {
            return endpoint;
        }
        return endpoint.replaceFirst(currentRegexToMatch, desiredStringToMatch);
    }

    public static Throwable transformBlobStorageException(Throwable ex) {
        if (ex instanceof BlobStorageException) {
            return DataLakeImplUtils.transformSingleBlobStorageException((BlobStorageException)ex);
        }
        if (Exceptions.isMultiple(ex)) {
            List<Throwable> suppressed = Exceptions.unwrapMultiple(ex);
            suppressed = suppressed.stream().map(e -> {
                if (e instanceof BlobStorageException) {
                    return DataLakeImplUtils.transformSingleBlobStorageException((BlobStorageException)e);
                }
                return e;
            }).collect(Collectors.toList());
            return Exceptions.multiple(suppressed);
        }
        return ex;
    }

    private static DataLakeStorageException transformSingleBlobStorageException(BlobStorageException ex) {
        return new DataLakeStorageException(ex.getServiceMessage(), ex.getResponse(), ex.getValue());
    }

    public static <T> T returnOrConvertException(Supplier<T> supplier, ClientLogger logger) {
        try {
            return supplier.get();
        }
        catch (BlobStorageException ex) {
            throw logger.logExceptionAsError((RuntimeException)DataLakeImplUtils.transformBlobStorageException(ex));
        }
    }
}

