/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.specialized;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.BlobContainerClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.specialized.BlobLeaseClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.specialized.SpecializedBlobClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.DataLakeDirectoryAsyncClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.DataLakeDirectoryClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.DataLakeFileAsyncClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.DataLakeFileClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.DataLakeFileSystemAsyncClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.DataLakeFileSystemClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.DataLakeServiceVersion;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.implementation.util.DataLakeImplUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.implementation.util.TransformUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.specialized.DataLakeLeaseAsyncClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.specialized.DataLakeLeaseClient;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={DataLakeLeaseClient.class, DataLakeLeaseAsyncClient.class})
public final class DataLakeLeaseClientBuilder {
    final BlobLeaseClientBuilder blobLeaseClientBuilder = new BlobLeaseClientBuilder();

    public DataLakeLeaseClient buildClient() {
        return new DataLakeLeaseClient(this.blobLeaseClientBuilder.buildClient());
    }

    public DataLakeLeaseAsyncClient buildAsyncClient() {
        return new DataLakeLeaseAsyncClient(this.blobLeaseClientBuilder.buildAsyncClient());
    }

    public DataLakeLeaseClientBuilder fileClient(DataLakeFileClient dataLakeFileClient) {
        Objects.requireNonNull(dataLakeFileClient);
        this.blobLeaseClientBuilder.blobClient(this.getSpecializedBlobClientBuilder(dataLakeFileClient.getFileUrl(), dataLakeFileClient.getHttpPipeline(), dataLakeFileClient.getServiceVersion()).buildBlockBlobClient());
        return this;
    }

    public DataLakeLeaseClientBuilder fileAsyncClient(DataLakeFileAsyncClient dataLakeFileAsyncClient) {
        Objects.requireNonNull(dataLakeFileAsyncClient);
        this.blobLeaseClientBuilder.blobAsyncClient(this.getSpecializedBlobClientBuilder(dataLakeFileAsyncClient.getFileUrl(), dataLakeFileAsyncClient.getHttpPipeline(), dataLakeFileAsyncClient.getServiceVersion()).buildBlockBlobAsyncClient());
        return this;
    }

    public DataLakeLeaseClientBuilder directoryClient(DataLakeDirectoryClient dataLakeDirectoryClient) {
        Objects.requireNonNull(dataLakeDirectoryClient);
        this.blobLeaseClientBuilder.blobClient(this.getSpecializedBlobClientBuilder(dataLakeDirectoryClient.getDirectoryUrl(), dataLakeDirectoryClient.getHttpPipeline(), dataLakeDirectoryClient.getServiceVersion()).buildBlockBlobClient());
        return this;
    }

    public DataLakeLeaseClientBuilder directoryAsyncClient(DataLakeDirectoryAsyncClient dataLakeDirectoryAsyncClient) {
        Objects.requireNonNull(dataLakeDirectoryAsyncClient);
        this.blobLeaseClientBuilder.blobAsyncClient(this.getSpecializedBlobClientBuilder(dataLakeDirectoryAsyncClient.getDirectoryUrl(), dataLakeDirectoryAsyncClient.getHttpPipeline(), dataLakeDirectoryAsyncClient.getServiceVersion()).buildBlockBlobAsyncClient());
        return this;
    }

    public DataLakeLeaseClientBuilder fileSystemClient(DataLakeFileSystemClient dataLakeFileSystemClient) {
        Objects.requireNonNull(dataLakeFileSystemClient);
        this.blobLeaseClientBuilder.containerClient(this.getBlobContainerClientBuilder(dataLakeFileSystemClient.getFileSystemUrl(), dataLakeFileSystemClient.getHttpPipeline(), dataLakeFileSystemClient.getServiceVersion()).buildClient());
        return this;
    }

    public DataLakeLeaseClientBuilder fileSystemAsyncClient(DataLakeFileSystemAsyncClient dataLakeFileSystemAsyncClient) {
        Objects.requireNonNull(dataLakeFileSystemAsyncClient);
        this.blobLeaseClientBuilder.containerClient(this.getBlobContainerClientBuilder(dataLakeFileSystemAsyncClient.getFileSystemUrl(), dataLakeFileSystemAsyncClient.getHttpPipeline(), dataLakeFileSystemAsyncClient.getServiceVersion()).buildClient());
        return this;
    }

    public DataLakeLeaseClientBuilder leaseId(String leaseId) {
        this.blobLeaseClientBuilder.leaseId(leaseId);
        return this;
    }

    private SpecializedBlobClientBuilder getSpecializedBlobClientBuilder(String dfsEndpoint, HttpPipeline pipeline, DataLakeServiceVersion version) {
        String blobEndpoint = DataLakeImplUtils.endpointToDesiredEndpoint(dfsEndpoint, "blob", "dfs");
        return new SpecializedBlobClientBuilder().pipeline(pipeline).endpoint(blobEndpoint).serviceVersion(TransformUtils.toBlobServiceVersion(version));
    }

    private BlobContainerClientBuilder getBlobContainerClientBuilder(String dfsEndpoint, HttpPipeline pipeline, DataLakeServiceVersion version) {
        String blobEndpoint = DataLakeImplUtils.endpointToDesiredEndpoint(dfsEndpoint, "blob", "dfs");
        return new BlobContainerClientBuilder().pipeline(pipeline).endpoint(blobEndpoint).serviceVersion(TransformUtils.toBlobServiceVersion(version));
    }
}

