/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.microsoft.graph.content;

import com.dataiku.dss.shadelibazure.com.google.gson.JsonElement;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.content.BatchRequestContent;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.content.BatchResponseContent;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.content.BatchResponseStep;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.core.ClientException;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.core.IBaseClient;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.http.BaseRequest;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.http.HttpMethod;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.options.Option;
import com.dataiku.dss.shadelibazure.javax.annotation.Nonnull;
import com.dataiku.dss.shadelibazure.javax.annotation.Nullable;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class BatchRequest
extends BaseRequest<BatchResponseContent> {
    public BatchRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nonnull List<? extends Option> options) {
        super(requestUrl, client, options, BatchResponseContent.class);
    }

    @Nullable
    public BatchResponseContent post(@Nullable BatchRequestContent content) throws ClientException {
        this.setHttpMethod(HttpMethod.POST);
        BatchResponseContent response = this.getClient().getHttpProvider().send(this, BatchResponseContent.class, content);
        this.setSerializerOnSteps(response);
        return response;
    }

    @Nullable
    public CompletableFuture<BatchResponseContent> postAsync(@Nullable BatchRequestContent content) throws ClientException {
        this.setHttpMethod(HttpMethod.POST);
        return this.getClient().getHttpProvider().sendAsync(this, BatchResponseContent.class, content).thenApply(response -> {
            this.setSerializerOnSteps((BatchResponseContent)response);
            return response;
        });
    }

    private void setSerializerOnSteps(BatchResponseContent response) {
        if (response.responses != null) {
            for (BatchResponseStep<JsonElement> step : response.responses) {
                step.serializer = this.getClient().getSerializer();
            }
        }
    }
}

