/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.microsoft.graph.http;

import com.dataiku.dss.shadelibazure.com.google.common.io.ByteStreams;
import com.dataiku.dss.shadelibazure.com.google.gson.Gson;
import com.dataiku.dss.shadelibazure.com.google.gson.GsonBuilder;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.core.ClientException;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.http.GraphError;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.http.GraphErrorResponse;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.http.GraphFatalServiceException;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.http.GraphInnerError;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.http.IHttpRequest;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.logger.ILogger;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.logger.LoggerLevel;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.options.HeaderOption;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.serializer.ISerializer;
import com.dataiku.dss.shadelibazure.javax.annotation.Nonnull;
import com.dataiku.dss.shadelibazure.javax.annotation.Nullable;
import com.dataiku.dss.shadelibazure.okhttp3.Headers;
import com.dataiku.dss.shadelibazure.okhttp3.Response;
import com.dataiku.dss.shadelibazure.okhttp3.ResponseBody;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class GraphServiceException
extends ClientException {
    private static final long serialVersionUID = -7416427229421064119L;
    protected static final char NEW_LINE = '\n';
    protected static final String TRUNCATION_MARKER = "[...]";
    protected static final int MAX_BREVITY_LENGTH = 50;
    protected static final int MAX_BYTE_COUNT_BEFORE_TRUNCATION = 8;
    public static final int INTERNAL_SERVER_ERROR = 500;
    private final transient GraphErrorResponse error;
    private final String method;
    private final String url;
    private final List<String> requestHeaders;
    private final String requestBody;
    private final int responseCode;
    private final String responseMessage;
    private final List<String> responseHeaders;
    private final boolean verbose;
    private static String[] requestHeadersToRedact = new String[]{"Authorization"};

    protected GraphServiceException(@Nonnull String method, @Nonnull String url, @Nonnull List<String> requestHeaders, @Nullable String requestBody, int responseCode, @Nonnull String responseMessage, @Nonnull List<String> responseHeaders, @Nullable GraphErrorResponse error, boolean verbose) {
        super(responseMessage, null);
        this.method = Objects.requireNonNull(method, "parameter method cannot be null");
        this.url = Objects.requireNonNull(url, "parameter url cannot be null");
        this.requestHeaders = Objects.requireNonNull(requestHeaders, "parameter requestHeaders cannot be null");
        this.requestBody = requestBody;
        this.responseCode = responseCode;
        this.responseMessage = Objects.requireNonNull(responseMessage, "parameter responseMessage cannot be null");
        this.responseHeaders = Objects.requireNonNull(responseHeaders, "parameter responseHeaders cannot be null");
        this.error = error;
        this.verbose = verbose;
        block0: for (String requestHeader : requestHeaders) {
            for (String headerKeyToRedact : requestHeadersToRedact) {
                if (!requestHeader.startsWith(headerKeyToRedact)) continue;
                Collections.replaceAll(requestHeaders, requestHeader, headerKeyToRedact + " : [PII_REDACTED]");
                continue block0;
            }
        }
    }

    @Nullable
    public String getResponseMessage() {
        return this.responseMessage;
    }

    @Override
    @Nullable
    public String getMessage() {
        return this.getMessage(this.verbose);
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    @Nonnull
    public List<String> getResponseHeaders() {
        return Collections.unmodifiableList(this.responseHeaders);
    }

    @Nullable
    public GraphErrorResponse getError() {
        return this.error.copy();
    }

    @Nonnull
    public String getMethod() {
        return this.method;
    }

    @Nonnull
    public String getUrl() {
        return this.url;
    }

    @Nonnull
    public List<String> getRequestHeaders() {
        return Collections.unmodifiableList(this.requestHeaders);
    }

    @Nullable
    public String getMessage(boolean verbose) {
        StringBuilder sb = new StringBuilder();
        if (this.error != null && this.error.error != null) {
            sb.append("Error code: ").append(this.error.error.code).append('\n');
            sb.append("Error message: ").append(this.error.error.message).append('\n');
            sb.append('\n');
        }
        sb.append(this.method).append(' ').append(this.url).append('\n');
        for (String header : this.requestHeaders) {
            if (verbose) {
                sb.append(header);
            } else {
                String truncatedHeader = header.substring(0, Math.min(50, header.length()));
                sb.append(truncatedHeader);
                if (truncatedHeader.length() == 50) {
                    sb.append(TRUNCATION_MARKER);
                }
            }
            sb.append('\n');
        }
        if (this.requestBody != null) {
            if (verbose) {
                sb.append(this.requestBody);
            } else {
                sb.append(TRUNCATION_MARKER);
            }
        }
        sb.append('\n').append('\n');
        sb.append(this.responseCode).append(" : ").append(this.responseMessage).append('\n');
        for (String header : this.responseHeaders) {
            if (verbose) {
                sb.append(header).append('\n');
                continue;
            }
            if (!header.toLowerCase(Locale.ROOT).startsWith("x-throwsite")) continue;
            sb.append(header).append('\n');
        }
        if (verbose && this.error != null && this.error.rawObject != null) {
            try {
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                sb.append(gson.toJson(this.error.rawObject)).append('\n');
            }
            catch (RuntimeException ignored) {
                sb.append("[Warning: Unable to parse error message body]").append('\n');
            }
        } else if (!verbose) {
            sb.append(TRUNCATION_MARKER).append('\n').append('\n');
            sb.append("[Some information was truncated for brevity, enable debug logging for more details]");
        }
        return sb.toString();
    }

    @Nullable
    public GraphError getServiceError() {
        return this.error.error;
    }

    @Nonnull
    public static <T> GraphServiceException createFromResponse(@Nonnull IHttpRequest request, @Nullable T serializable, @Nonnull ISerializer serializer, @Nonnull Response response, @Nonnull ILogger logger) throws IOException {
        String requestBody;
        boolean isVerbose;
        Objects.requireNonNull(response, "response parameter cannot be null");
        Objects.requireNonNull(request, "request parameter cannot be null");
        Objects.requireNonNull(serializer, "serializer parameter cannot be null");
        Objects.requireNonNull(logger, "logger parameter cannot be null");
        String method = response.request().method();
        String url = request.getRequestUrl().toString();
        LinkedList<String> requestHeaders = new LinkedList<String>();
        for (HeaderOption option : request.getHeaders()) {
            requestHeaders.add(option.getName() + " : " + option.getValue());
        }
        boolean bl = isVerbose = logger.getLoggingLevel() == LoggerLevel.DEBUG;
        if (serializable instanceof byte[]) {
            byte[] bytes = (byte[])serializable;
            StringBuilder sb = new StringBuilder();
            sb.append("byte[").append(bytes.length).append("]");
            sb.append(" {");
            if (isVerbose) {
                sb.append(Arrays.toString(bytes));
            } else {
                for (int i = 0; i < 8 && i < bytes.length; ++i) {
                    sb.append(bytes[i]).append(", ");
                }
                if (bytes.length > 8) {
                    sb.append(TRUNCATION_MARKER).append("}");
                }
            }
            requestBody = sb.toString();
        } else {
            requestBody = serializable != null ? serializer.serializeObject(serializable) : null;
        }
        int responseCode = response.code();
        Map<String, String> headers = GraphServiceException.getResponseHeadersAsMapStringString(response);
        String responseMessage = response.message();
        GraphErrorResponse error = GraphServiceException.parseErrorResponse(serializer, response);
        return GraphServiceException.createFromResponse(url, method, requestHeaders, requestBody, headers, responseMessage, responseCode, error, isVerbose);
    }

    @Nonnull
    public static GraphServiceException createFromResponse(@Nullable String url, @Nullable String method, @Nonnull List<String> requestHeaders, @Nullable String requestBody, @Nonnull Map<String, String> headers, @Nonnull String responseMessage, int responseCode, @Nonnull GraphErrorResponse error, boolean isVerbose) {
        Objects.requireNonNull(headers, "parameter headers cannot be null");
        LinkedList<String> responseHeaders = new LinkedList<String>();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            responseHeaders.add(entry.getKey() + (entry.getKey() == null ? "" : " : ") + entry.getValue());
        }
        if (responseCode >= 500) {
            return new GraphFatalServiceException(method == null ? "" : method, url == null ? "" : url, requestHeaders, requestBody, responseCode, responseMessage, responseHeaders, error, isVerbose);
        }
        return new GraphServiceException(method == null ? "" : method, url == null ? "" : url, requestHeaders, requestBody, responseCode, responseMessage, responseHeaders, error, isVerbose);
    }

    private static GraphErrorResponse parseErrorResponse(@Nonnull ISerializer serializer, @Nonnull Response response) throws IOException {
        GraphErrorResponse error;
        byte[] responseBytes;
        block15: {
            Objects.requireNonNull(serializer, "serializer is required.");
            Objects.requireNonNull(response, "response is required.");
            try (ResponseBody body = response.body();){
                if (body == null) {
                    responseBytes = new byte[]{};
                    break block15;
                }
                try (InputStream is = body.byteStream();){
                    responseBytes = ByteStreams.toByteArray(is);
                }
            }
        }
        try {
            error = serializer.deserializeObject(new ByteArrayInputStream(responseBytes), GraphErrorResponse.class, response.headers().toMultimap());
        }
        catch (Exception ex) {
            error = new GraphErrorResponse();
            error.error = new GraphError();
            error.error.code = "Unable to parse error response message";
            error.error.message = "Raw error: " + new String(responseBytes, StandardCharsets.UTF_8);
            error.error.innererror = new GraphInnerError();
            error.error.innererror.code = ex.getMessage();
        }
        return error;
    }

    @Nonnull
    protected static Map<String, String> getResponseHeadersAsMapStringString(@Nonnull Response response) {
        TreeMap<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        Headers responseHeaders = response.headers();
        for (int index = 0; index < responseHeaders.size(); ++index) {
            String headerName = responseHeaders.name(index);
            String headerValue = responseHeaders.value(index);
            if (headerName == null || headerValue == null) break;
            headers.put(headerName, headerValue);
        }
        return headers;
    }
}

