/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.microsoft.graph.serializer;

import com.dataiku.dss.shadelibazure.com.google.common.annotations.VisibleForTesting;
import com.dataiku.dss.shadelibazure.com.google.common.base.CaseFormat;
import com.dataiku.dss.shadelibazure.com.google.gson.JsonObject;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.logger.ILogger;
import com.dataiku.dss.shadelibazure.javax.annotation.Nonnull;
import com.dataiku.dss.shadelibazure.javax.annotation.Nullable;
import java.util.Locale;
import java.util.Objects;

public class DerivedClassIdentifier {
    private static final String ODATA_TYPE_KEY = "@odata.type";
    private final ILogger logger;

    public DerivedClassIdentifier(@Nonnull ILogger logger) {
        this.logger = Objects.requireNonNull(logger, "logger parameter cannot be null");
    }

    @Nullable
    public Class<?> identify(@Nonnull JsonObject jsonObject, @Nullable Class<?> parentClass) {
        Objects.requireNonNull(jsonObject, "parameter jsonObject cannot be null");
        if (jsonObject.get(ODATA_TYPE_KEY) != null) {
            String odataType = jsonObject.get(ODATA_TYPE_KEY).getAsString();
            String derivedType = DerivedClassIdentifier.oDataTypeToClassName(odataType);
            try {
                Class<?> derivedClass = Class.forName(derivedType);
                if (parentClass == null || parentClass.isAssignableFrom(derivedClass)) {
                    return derivedClass;
                }
                return null;
            }
            catch (ClassNotFoundException e) {
                this.logger.logDebug("Unable to find a corresponding class for derived type " + derivedType + ". Falling back to parent class.");
                return null;
            }
        }
        return null;
    }

    @VisibleForTesting
    static String oDataTypeToClassName(@Nonnull String odataType) {
        Objects.requireNonNull(odataType);
        int lastDotIndex = odataType.lastIndexOf(".");
        return (odataType.substring(0, lastDotIndex).toLowerCase(Locale.ROOT) + ".models." + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, odataType.substring(lastDotIndex + 1))).replace("#", "com.");
    }
}

