/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.auth;

import com.dataiku.dss.shadelibazure.com.nimbusds.common.contenttype.ContentType;
import com.dataiku.dss.shadelibazure.com.nimbusds.jose.JOSEException;
import com.dataiku.dss.shadelibazure.com.nimbusds.jose.JWSAlgorithm;
import com.dataiku.dss.shadelibazure.com.nimbusds.jwt.SignedJWT;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.assertions.jwt.JWTAssertionFactory;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.auth.JWTAuthentication;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.auth.JWTAuthenticationClaimsSet;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.auth.Secret;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.id.Audience;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.id.ClientID;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.id.Issuer;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.util.URLUtils;
import com.dataiku.dss.shadelibazure.net.jcip.annotations.Immutable;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Immutable
public final class ClientSecretJWT
extends JWTAuthentication {
    public static Set<JWSAlgorithm> supportedJWAs() {
        return Collections.unmodifiableSet(new HashSet<JWSAlgorithm>(JWSAlgorithm.Family.HMAC_SHA));
    }

    public ClientSecretJWT(ClientID clientID, URI audience, JWSAlgorithm jwsAlgorithm, Secret clientSecret) throws JOSEException {
        this(new Issuer(clientID), clientID, audience, jwsAlgorithm, clientSecret);
    }

    public ClientSecretJWT(Issuer iss, ClientID clientID, URI audience, JWSAlgorithm jwsAlgorithm, Secret clientSecret) throws JOSEException {
        this(JWTAssertionFactory.create(new JWTAuthenticationClaimsSet(iss, clientID, new Audience(audience)), jwsAlgorithm, clientSecret));
    }

    public ClientSecretJWT(SignedJWT clientAssertion) {
        super(ClientAuthenticationMethod.CLIENT_SECRET_JWT, clientAssertion);
        if (!JWSAlgorithm.Family.HMAC_SHA.contains(clientAssertion.getHeader().getAlgorithm())) {
            throw new IllegalArgumentException("The client assertion JWT must be HMAC-signed (HS256, HS384 or HS512)");
        }
    }

    public static ClientSecretJWT parse(Map<String, List<String>> params) throws ParseException {
        ClientSecretJWT clientSecretJWT;
        JWTAuthentication.ensureClientAssertionType(params);
        SignedJWT clientAssertion = JWTAuthentication.parseClientAssertion(params);
        try {
            clientSecretJWT = new ClientSecretJWT(clientAssertion);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(e.getMessage(), e);
        }
        ClientID clientID = JWTAuthentication.parseClientID(params);
        if (clientID != null && !clientID.equals(clientSecretJWT.getClientID())) {
            throw new ParseException("Invalid client secret JWT authentication: The client identifier doesn't match the client assertion subject");
        }
        return clientSecretJWT;
    }

    public static ClientSecretJWT parse(String paramsString) throws ParseException {
        Map<String, List<String>> params = URLUtils.parseParameters(paramsString);
        return ClientSecretJWT.parse(params);
    }

    public static ClientSecretJWT parse(HTTPRequest httpRequest) throws ParseException {
        httpRequest.ensureMethod(HTTPRequest.Method.POST);
        httpRequest.ensureEntityContentType(ContentType.APPLICATION_URLENCODED);
        return ClientSecretJWT.parse(httpRequest.getBodyAsFormParameters());
    }
}

