/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.federation.api;

import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.id.Issuer;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.id.Subject;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.util.URIUtils;
import com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.federation.api.FederationAPIRequest;
import com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import com.dataiku.dss.shadelibazure.net.jcip.annotations.Immutable;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Immutable
public class FetchEntityStatementRequest
extends FederationAPIRequest {
    private final Issuer issuer;
    private final Subject subject;

    public FetchEntityStatementRequest(URI endpoint, Issuer issuer, Subject subject) {
        super(endpoint);
        this.issuer = issuer;
        this.subject = subject;
    }

    public FetchEntityStatementRequest(URI endpoint, EntityID issuer, EntityID subject) {
        this(endpoint, issuer != null ? new Issuer(issuer.getValue()) : null, subject != null ? new Subject(subject.getValue()) : null);
    }

    public Issuer getIssuer() {
        return this.issuer;
    }

    public EntityID getIssuerEntityID() {
        return this.getIssuer() != null ? new EntityID(this.getIssuer().getValue()) : null;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public EntityID getSubjectEntityID() {
        return this.getSubject() != null ? new EntityID(this.getSubject().getValue()) : null;
    }

    @Override
    public Map<String, List<String>> toParameters() {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        if (this.getIssuer() != null) {
            params.put("iss", Collections.singletonList(this.getIssuer().getValue()));
        }
        if (this.getSubject() != null) {
            params.put("sub", Collections.singletonList(this.getSubject().getValue()));
        }
        return params;
    }

    public static FetchEntityStatementRequest parse(Map<String, List<String>> params) throws ParseException {
        String value = MultivaluedMapUtils.getFirstValue(params, "iss");
        Issuer issuer = null;
        if (value != null) {
            issuer = new Issuer(value);
        }
        value = MultivaluedMapUtils.getFirstValue(params, "sub");
        Subject subject = null;
        if (value != null) {
            subject = new Subject(value);
        }
        return new FetchEntityStatementRequest(null, issuer, subject);
    }

    public static FetchEntityStatementRequest parse(HTTPRequest httpRequest) throws ParseException {
        httpRequest.ensureMethod(HTTPRequest.Method.GET);
        FetchEntityStatementRequest request = FetchEntityStatementRequest.parse(httpRequest.getQueryStringParameters());
        return new FetchEntityStatementRequest(URIUtils.getBaseURI(httpRequest.getURI()), request.getIssuer(), request.getSubject());
    }
}

