/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.id;

import com.dataiku.dss.shadelibazure.com.nimbusds.jose.util.Base64URL;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.id.Subject;
import com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.id.PairwiseSubjectCodec;
import com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.id.SectorID;
import com.dataiku.dss.shadelibazure.net.jcip.annotations.ThreadSafe;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;

@ThreadSafe
public class HashBasedPairwiseSubjectCodec
extends PairwiseSubjectCodec {
    public static final String HASH_ALGORITHM = "SHA-256";

    public HashBasedPairwiseSubjectCodec(byte[] salt) {
        super(Objects.requireNonNull(salt));
    }

    public HashBasedPairwiseSubjectCodec(Base64URL salt) {
        super(salt.decode());
    }

    @Override
    public Subject encode(SectorID sectorID, Subject localSub) {
        MessageDigest sha256;
        try {
            sha256 = this.getProvider() != null ? MessageDigest.getInstance(HASH_ALGORITHM, this.getProvider()) : MessageDigest.getInstance(HASH_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        sha256.update(sectorID.getValue().getBytes(CHARSET));
        sha256.update(localSub.getValue().getBytes(CHARSET));
        byte[] hash = sha256.digest(this.getSalt());
        return new Subject(Base64URL.encode(hash).toString());
    }
}

