/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.org.apache.iceberg.azure.adlsv2;

import com.dataiku.dss.shadelib.org.apache.iceberg.common.DynConstructors;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.BulkDeletionFailureException;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.DelegateFileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileInfo;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.InputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.OutputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.metrics.MetricsContext;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.SerializableMap;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.Tasks;
import com.dataiku.dss.shadelib.org.apache.iceberg.util.ThreadPools;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpClient;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.DataLakeFileClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.DataLakeFileSystemClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.DataLakeFileSystemClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.DataLakeStorageException;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.ListPathsOptions;
import com.dataiku.dss.shadelibazure.org.apache.iceberg.azure.AzureProperties;
import com.dataiku.dss.shadelibazure.org.apache.iceberg.azure.adlsv2.ADLSInputFile;
import com.dataiku.dss.shadelibazure.org.apache.iceberg.azure.adlsv2.ADLSLocation;
import com.dataiku.dss.shadelibazure.org.apache.iceberg.azure.adlsv2.ADLSOutputFile;
import com.dataiku.dss.shadelibazure.org.apache.iceberg.azure.adlsv2.VendedAdlsCredentialProvider;
import com.dataiku.dss.shadelibazure.org.apache.iceberg.azure.adlsv2.VendedAzureSasCredentialPolicy;
import com.dataiku.dss.shadelibazure.org.slf4j.Logger;
import com.dataiku.dss.shadelibazure.org.slf4j.LoggerFactory;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

public class ADLSFileIO
implements DelegateFileIO {
    private static final Logger LOG = LoggerFactory.getLogger(ADLSFileIO.class);
    private static final String DEFAULT_METRICS_IMPL = "com.dataiku.dss.shadelib.org.apache.iceberg.hadoop.HadoopMetricsContext";
    private static final HttpClient HTTP = HttpClient.createDefault();
    private AzureProperties azureProperties;
    private MetricsContext metrics = MetricsContext.nullMetrics();
    private SerializableMap<String, String> properties;
    private VendedAdlsCredentialProvider vendedAdlsCredentialProvider;

    public ADLSFileIO() {
    }

    @VisibleForTesting
    ADLSFileIO(AzureProperties azureProperties) {
        this.azureProperties = azureProperties;
    }

    public InputFile newInputFile(String path) {
        return new ADLSInputFile(path, this.fileClient(path), this.azureProperties, this.metrics);
    }

    public InputFile newInputFile(String path, long length) {
        return new ADLSInputFile(path, length, this.fileClient(path), this.azureProperties, this.metrics);
    }

    public OutputFile newOutputFile(String path) {
        return new ADLSOutputFile(path, this.fileClient(path), this.azureProperties, this.metrics);
    }

    public void deleteFile(String path) {
        try {
            this.fileClient(path).delete();
        }
        catch (RuntimeException e) {
            LOG.warn("Failed to delete path: {}", (Object)path, (Object)e);
        }
    }

    public Map<String, String> properties() {
        return this.properties.immutableMap();
    }

    public DataLakeFileSystemClient client(String path) {
        ADLSLocation location = new ADLSLocation(path);
        return this.client(location);
    }

    @VisibleForTesting
    DataLakeFileSystemClient client(ADLSLocation location) {
        DataLakeFileSystemClientBuilder clientBuilder = new DataLakeFileSystemClientBuilder().httpClient(HTTP);
        location.container().ifPresent(clientBuilder::fileSystemName);
        Optional.ofNullable(this.vendedAdlsCredentialProvider).map(p -> new VendedAzureSasCredentialPolicy(location.host(), (VendedAdlsCredentialProvider)p)).ifPresent(clientBuilder::addPolicy);
        this.azureProperties.applyClientConfiguration(location.host(), clientBuilder);
        return clientBuilder.buildClient();
    }

    private DataLakeFileClient fileClient(String path) {
        ADLSLocation location = new ADLSLocation(path);
        return this.client(location).getFileClient(location.path());
    }

    public void initialize(Map<String, String> props) {
        this.properties = SerializableMap.copyOf(props);
        this.azureProperties = new AzureProperties((Map<String, String>)this.properties);
        this.initMetrics((Map<String, String>)this.properties);
        this.azureProperties.vendedAdlsCredentialProvider().ifPresent(provider -> {
            this.vendedAdlsCredentialProvider = provider;
        });
    }

    private void initMetrics(Map<String, String> props) {
        try {
            DynConstructors.Ctor ctor = DynConstructors.builder(MetricsContext.class).hiddenImpl(DEFAULT_METRICS_IMPL, new Class[]{String.class}).buildChecked();
            MetricsContext context = (MetricsContext)ctor.newInstance(new Object[]{"adls"});
            context.initialize(props);
            this.metrics = context;
        }
        catch (ClassCastException | NoClassDefFoundError | NoSuchMethodException e) {
            LOG.warn("Unable to load metrics class: '{}', falling back to null metrics", (Object)DEFAULT_METRICS_IMPL);
        }
    }

    public void deleteFiles(Iterable<String> pathsToDelete) throws BulkDeletionFailureException {
        AtomicInteger failureCount = new AtomicInteger();
        Tasks.foreach(pathsToDelete).executeWith(ThreadPools.getWorkerPool()).noRetry().suppressFailureWhenFinished().onFailure((file, exc) -> {
            failureCount.incrementAndGet();
            LOG.warn("Failed to delete file {}", file, (Object)exc);
        }).run(this::deleteFile);
        if (failureCount.get() > 0) {
            throw new BulkDeletionFailureException(failureCount.get());
        }
    }

    public Iterable<FileInfo> listPrefix(String prefix) {
        ADLSLocation location = new ADLSLocation(prefix);
        ListPathsOptions options = new ListPathsOptions();
        options.setPath(location.path());
        options.setRecursive(true);
        return () -> {
            try {
                return this.client(location).listPaths(options, null).stream().filter(pathItem -> !pathItem.isDirectory()).map(pathItem -> new FileInfo(pathItem.getName(), pathItem.getContentLength(), pathItem.getCreationTime().toInstant().toEpochMilli())).iterator();
            }
            catch (DataLakeStorageException e) {
                if (e.getStatusCode() != 404) {
                    throw e;
                }
                return Collections.emptyIterator();
            }
        };
    }

    public void deletePrefix(String prefix) {
        block2: {
            ADLSLocation location = new ADLSLocation(prefix);
            try {
                this.client(location).deleteDirectoryWithResponse(location.path(), true, null, null, Context.NONE).getValue();
            }
            catch (DataLakeStorageException e) {
                if (e.getStatusCode() == 404) break block2;
                throw e;
            }
        }
    }

    public void close() {
        if (this.vendedAdlsCredentialProvider != null) {
            this.vendedAdlsCredentialProvider.close();
        }
        super.close();
    }
}

