/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.org.apache.iceberg.azure.adlsv2;

import com.dataiku.dss.shadelib.org.apache.iceberg.io.PositionOutputStream;
import com.dataiku.dss.shadelib.org.apache.iceberg.metrics.Counter;
import com.dataiku.dss.shadelib.org.apache.iceberg.metrics.MetricsContext;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Joiner;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.ParallelTransferOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.DataLakeFileClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.options.DataLakeFileOutputStreamOptions;
import com.dataiku.dss.shadelibazure.org.apache.iceberg.azure.AzureProperties;
import com.dataiku.dss.shadelibazure.org.slf4j.Logger;
import com.dataiku.dss.shadelibazure.org.slf4j.LoggerFactory;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

class ADLSOutputStream
extends PositionOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(ADLSOutputStream.class);
    private final StackTraceElement[] createStack;
    private final DataLakeFileClient fileClient;
    private final AzureProperties azureProperties;
    private OutputStream stream;
    private final Counter writeBytes;
    private final Counter writeOperations;
    private long pos;
    private boolean closed;

    ADLSOutputStream(DataLakeFileClient fileClient, AzureProperties azureProperties, MetricsContext metrics) throws IOException {
        this.fileClient = fileClient;
        this.azureProperties = azureProperties;
        this.createStack = Thread.currentThread().getStackTrace();
        this.writeBytes = metrics.counter("write.bytes", MetricsContext.Unit.BYTES);
        this.writeOperations = metrics.counter("write.operations");
        this.openStream();
    }

    public long getPos() {
        return this.pos;
    }

    public void flush() throws IOException {
        this.stream.flush();
    }

    public void write(int b) throws IOException {
        this.stream.write(b);
        ++this.pos;
        this.writeBytes.increment();
        this.writeOperations.increment();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.stream.write(b, off, len);
        this.pos += (long)len;
        this.writeBytes.increment(len);
        this.writeOperations.increment();
    }

    private void openStream() {
        DataLakeFileOutputStreamOptions options = new DataLakeFileOutputStreamOptions();
        ParallelTransferOptions transferOptions = new ParallelTransferOptions();
        this.azureProperties.adlsWriteBlockSize().ifPresent(transferOptions::setBlockSizeLong);
        try {
            this.stream = new BufferedOutputStream(this.fileClient.getOutputStream(options));
        }
        catch (RuntimeException e) {
            LOG.error("Failed to open output stream for file {}", (Object)this.fileClient.getFilePath(), (Object)e);
            throw e;
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        super.close();
        this.closed = true;
        if (this.stream != null) {
            this.stream.close();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.closed) {
            this.close();
            String trace = Joiner.on((String)"\n\t").join((Object[])Arrays.copyOfRange(this.createStack, 1, this.createStack.length));
            LOG.warn("Unclosed output stream created by:\n\t{}", (Object)trace);
        }
    }
}

