/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.org.apache.iceberg.azure.adlsv2;

import com.dataiku.dss.shadelib.org.apache.iceberg.metrics.MetricsContext;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.DataLakeFileClient;
import com.dataiku.dss.shadelibazure.org.apache.iceberg.azure.AzureProperties;
import com.dataiku.dss.shadelibazure.org.slf4j.Logger;
import com.dataiku.dss.shadelibazure.org.slf4j.LoggerFactory;

abstract class BaseADLSFile {
    private static final Logger LOG = LoggerFactory.getLogger(BaseADLSFile.class);
    private final String location;
    private final DataLakeFileClient fileClient;
    private final AzureProperties azureProperties;
    private final MetricsContext metrics;

    BaseADLSFile(String location, DataLakeFileClient fileClient, AzureProperties azureProperties, MetricsContext metrics) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Cannot initialize ADLS file with null location");
        Preconditions.checkArgument((fileClient != null ? 1 : 0) != 0, (Object)"Cannot initialize ADLS file with null file client");
        Preconditions.checkArgument((azureProperties != null ? 1 : 0) != 0, (Object)"Cannot initialize ADLS file with null properties");
        Preconditions.checkArgument((metrics != null ? 1 : 0) != 0, (Object)"Cannot initialize ADLS file with null metrics");
        this.location = location;
        this.fileClient = fileClient;
        this.azureProperties = azureProperties;
        this.metrics = metrics;
    }

    protected AzureProperties azureProperties() {
        return this.azureProperties;
    }

    protected MetricsContext metrics() {
        return this.metrics;
    }

    protected DataLakeFileClient fileClient() {
        return this.fileClient;
    }

    public String location() {
        return this.location;
    }

    public boolean exists() {
        try {
            return this.fileClient().exists();
        }
        catch (RuntimeException e) {
            LOG.error("Failed to check if the file exists at path {}", (Object)this.location, (Object)e);
            throw e;
        }
    }

    public String toString() {
        return this.location;
    }
}

