/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.org.apache.iceberg.azure.adlsv2;

import com.dataiku.dss.shadelibazure.com.azure.core.credential.AzureSasCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineCallContext;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineNextPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.AzureSasCredentialPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpPipelinePolicy;
import com.dataiku.dss.shadelibazure.org.apache.iceberg.azure.adlsv2.VendedAdlsCredentialProvider;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

class VendedAzureSasCredentialPolicy
implements HttpPipelinePolicy {
    private final String account;
    private final VendedAdlsCredentialProvider vendedAdlsCredentialProvider;
    private volatile AzureSasCredential azureSasCredential;
    private AzureSasCredentialPolicy azureSasCredentialPolicy;

    VendedAzureSasCredentialPolicy(String account, VendedAdlsCredentialProvider vendedAdlsCredentialProvider) {
        this.account = account;
        this.vendedAdlsCredentialProvider = vendedAdlsCredentialProvider;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext httpPipelineCallContext, HttpPipelineNextPolicy httpPipelineNextPolicy) {
        return this.maybeUpdateCredential().then(Mono.defer(() -> this.azureSasCredentialPolicy.process(httpPipelineCallContext, httpPipelineNextPolicy)));
    }

    @Override
    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        this.maybeUpdateCredential().block();
        return this.azureSasCredentialPolicy.processSync(context, next);
    }

    private Mono<Void> maybeUpdateCredential() {
        return this.vendedAdlsCredentialProvider.credentialForAccount(this.account).flatMap(sasToken -> {
            if (this.azureSasCredential == null) {
                VendedAzureSasCredentialPolicy vendedAzureSasCredentialPolicy = this;
                synchronized (vendedAzureSasCredentialPolicy) {
                    if (this.azureSasCredential == null) {
                        this.azureSasCredential = new AzureSasCredential((String)sasToken);
                        this.azureSasCredentialPolicy = new AzureSasCredentialPolicy(this.azureSasCredential, false);
                        return Mono.empty();
                    }
                }
            }
            this.azureSasCredential.update((String)sasToken);
            return Mono.empty();
        });
    }
}

