/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.core.publisher;

import com.dataiku.dss.shadelibazure.io.micrometer.context.ContextSnapshot;
import com.dataiku.dss.shadelibazure.org.reactivestreams.Subscription;
import com.dataiku.dss.shadelibazure.reactor.core.CoreSubscriber;
import com.dataiku.dss.shadelibazure.reactor.core.Exceptions;
import com.dataiku.dss.shadelibazure.reactor.core.Fuseable;
import com.dataiku.dss.shadelibazure.reactor.core.Scannable;
import com.dataiku.dss.shadelibazure.reactor.core.observability.SignalListener;
import com.dataiku.dss.shadelibazure.reactor.core.observability.SignalListenerFactory;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.ContextPropagation;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.FluxOperator;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.InnerOperator;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.InternalProducerAttr;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Operators;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.SignalType;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import com.dataiku.dss.shadelibazure.reactor.util.context.Context;

final class FluxTapRestoringThreadLocals<T, STATE>
extends FluxOperator<T, T> {
    final SignalListenerFactory<T, STATE> tapFactory;
    final STATE commonTapState;

    FluxTapRestoringThreadLocals(Flux<? extends T> source2, SignalListenerFactory<T, STATE> tapFactory) {
        super(source2);
        this.tapFactory = tapFactory;
        this.commonTapState = tapFactory.initializePublisherState(source2);
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Context alteredContext;
        SignalListener<T> signalListener;
        try {
            signalListener = this.tapFactory.createListener(this.source, actual.currentContext().readOnly(), this.commonTapState);
        }
        catch (Throwable generatorError) {
            Operators.error(actual, generatorError);
            return;
        }
        try {
            signalListener.doFirst();
        }
        catch (Throwable listenerError) {
            signalListener.handleListenerError(listenerError);
            Operators.error(actual, listenerError);
            return;
        }
        try {
            alteredContext = signalListener.addToContext(actual.currentContext());
        }
        catch (Throwable e) {
            IllegalStateException listenerError = new IllegalStateException("Unable to augment tap Context at subscription via addToContext", e);
            signalListener.handleListenerError(listenerError);
            Operators.error(actual, listenerError);
            return;
        }
        try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(alteredContext);){
            this.source.subscribe(new TapSubscriber<T>(actual, signalListener, alteredContext));
        }
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        if (key == InternalProducerAttr.INSTANCE) {
            return true;
        }
        return super.scanUnsafe(key);
    }

    static class TapSubscriber<T>
    implements Fuseable.ConditionalSubscriber<T>,
    InnerOperator<T, T> {
        final CoreSubscriber<? super T> actual;
        final Fuseable.ConditionalSubscriber<? super T> actualConditional;
        final Context context;
        final SignalListener<T> listener;
        boolean done;
        Subscription s;

        TapSubscriber(CoreSubscriber<? super T> actual, SignalListener<T> signalListener, Context ctx) {
            this.actual = actual;
            this.listener = signalListener;
            this.context = ctx;
            this.actualConditional = actual instanceof Fuseable.ConditionalSubscriber ? (Fuseable.ConditionalSubscriber)actual : null;
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public Context currentContext() {
            return this.context;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            if (key == Scannable.Attr.RUN_STYLE) {
                return Scannable.Attr.RunStyle.SYNC;
            }
            if (key == InternalProducerAttr.INSTANCE) {
                return true;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        protected void handleListenerErrorPreSubscription(Throwable listenerError, Subscription toCancel) {
            toCancel.cancel();
            this.listener.handleListenerError(listenerError);
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                Operators.error(this.actual, listenerError);
            }
        }

        protected void handleListenerErrorAndTerminate(Throwable listenerError) {
            this.s.cancel();
            this.listener.handleListenerError(listenerError);
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                this.actual.onError(listenerError);
            }
        }

        protected void handleListenerErrorMultipleAndTerminate(Throwable listenerError, Throwable originalError) {
            this.s.cancel();
            this.listener.handleListenerError(listenerError);
            RuntimeException multiple = Exceptions.multiple(listenerError, originalError);
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                this.actual.onError(multiple);
            }
        }

        protected void handleListenerErrorPostTermination(Throwable listenerError) {
            this.listener.handleListenerError(listenerError);
            Operators.onErrorDropped(listenerError, this.actual.currentContext());
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (Operators.validate(this.s, s2)) {
                this.s = s2;
                try {
                    this.listener.doOnSubscription();
                }
                catch (Throwable observerError) {
                    this.handleListenerErrorPreSubscription(observerError, s2);
                    return;
                }
                try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                    this.actual.onSubscribe(this);
                }
            }
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                try {
                    this.listener.doOnMalformedOnNext(t);
                }
                catch (Throwable observerError) {
                    this.handleListenerErrorPostTermination(observerError);
                }
                finally {
                    Operators.onNextDropped(t, this.currentContext());
                }
                return;
            }
            try {
                this.listener.doOnNext(t);
            }
            catch (Throwable observerError) {
                this.handleListenerErrorAndTerminate(observerError);
                return;
            }
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                this.actual.onNext(t);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                if (this.actualConditional != null) {
                    if (!this.actualConditional.tryOnNext(t)) {
                        boolean bl = false;
                        return bl;
                    }
                } else {
                    this.actual.onNext(t);
                }
            }
            try {
                this.listener.doOnNext(t);
            }
            catch (Throwable listenerError) {
                this.handleListenerErrorAndTerminate(listenerError);
            }
            return true;
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                try {
                    this.listener.doOnMalformedOnError(t);
                }
                catch (Throwable observerError) {
                    this.handleListenerErrorPostTermination(observerError);
                }
                finally {
                    Operators.onErrorDropped(t, this.currentContext());
                }
                return;
            }
            this.done = true;
            try {
                this.listener.doOnError(t);
            }
            catch (Throwable observerError) {
                this.handleListenerErrorMultipleAndTerminate(observerError, t);
                return;
            }
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                this.actual.onError(t);
            }
            try {
                this.listener.doAfterError(t);
                this.listener.doFinally(SignalType.ON_ERROR);
            }
            catch (Throwable observerError) {
                this.handleListenerErrorPostTermination(observerError);
            }
        }

        @Override
        public void onComplete() {
            if (this.done) {
                try {
                    this.listener.doOnMalformedOnComplete();
                }
                catch (Throwable observerError) {
                    this.handleListenerErrorPostTermination(observerError);
                }
                return;
            }
            this.done = true;
            try {
                this.listener.doOnComplete();
            }
            catch (Throwable observerError) {
                this.handleListenerErrorAndTerminate(observerError);
                return;
            }
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                this.actual.onComplete();
            }
            try {
                this.listener.doAfterComplete();
                this.listener.doFinally(SignalType.ON_COMPLETE);
            }
            catch (Throwable observerError) {
                this.handleListenerErrorPostTermination(observerError);
            }
        }

        @Override
        public void request(long n) {
            block10: {
                try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.context);){
                    if (!Operators.validate(n)) break block10;
                    try {
                        this.listener.doOnRequest(n);
                    }
                    catch (Throwable observerError) {
                        this.handleListenerErrorAndTerminate(observerError);
                        if (ignored != null) {
                            ignored.close();
                        }
                        return;
                    }
                    this.s.request(n);
                }
            }
        }

        @Override
        public void cancel() {
            ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.context);
            try {
                try {
                    this.listener.doOnCancel();
                }
                catch (Throwable observerError) {
                    this.handleListenerErrorAndTerminate(observerError);
                    if (ignored != null) {
                        ignored.close();
                    }
                    return;
                }
                try {
                    this.s.cancel();
                }
                finally {
                    try {
                        this.listener.doFinally(SignalType.CANCEL);
                    }
                    catch (Throwable observerError) {
                        this.handleListenerErrorAndTerminate(observerError);
                    }
                }
            }
            finally {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
    }
}

