/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.channel;

import com.dataiku.dss.shadelibazure.io.netty.buffer.ByteBuf;
import com.dataiku.dss.shadelibazure.io.netty.buffer.ByteBufAllocator;
import com.dataiku.dss.shadelibazure.io.netty.channel.AbstractChannel;
import com.dataiku.dss.shadelibazure.io.netty.channel.Channel;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelConfig;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelFuture;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelHandler;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelHandlerContext;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelMetadata;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelOutboundBuffer;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelPromise;
import com.dataiku.dss.shadelibazure.io.netty.channel.DefaultChannelConfig;
import com.dataiku.dss.shadelibazure.io.netty.channel.EventLoop;
import com.dataiku.dss.shadelibazure.io.netty.util.ReferenceCounted;
import com.dataiku.dss.shadelibazure.org.reactivestreams.Publisher;
import com.dataiku.dss.shadelibazure.org.reactivestreams.Subscription;
import com.dataiku.dss.shadelibazure.reactor.core.CoreSubscriber;
import com.dataiku.dss.shadelibazure.reactor.core.Disposable;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Operators;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Sinks;
import com.dataiku.dss.shadelibazure.reactor.netty.ByteBufFlux;
import com.dataiku.dss.shadelibazure.reactor.netty.ChannelOperationsId;
import com.dataiku.dss.shadelibazure.reactor.netty.Connection;
import com.dataiku.dss.shadelibazure.reactor.netty.ConnectionObserver;
import com.dataiku.dss.shadelibazure.reactor.netty.FutureMono;
import com.dataiku.dss.shadelibazure.reactor.netty.NettyInbound;
import com.dataiku.dss.shadelibazure.reactor.netty.NettyOutbound;
import com.dataiku.dss.shadelibazure.reactor.netty.ReactorNetty;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.AbortedException;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.AbstractChannelMetricsHandler;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ChannelMetricsHandler;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ChannelMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ChannelOperationsHandler;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ContextAwareChannelMetricsHandler;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ContextAwareChannelMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.FluxReceive;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.MicrometerChannelMetricsHandler;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.MicrometerChannelMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.MonoSendMany;
import com.dataiku.dss.shadelibazure.reactor.util.Logger;
import com.dataiku.dss.shadelibazure.reactor.util.Loggers;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import com.dataiku.dss.shadelibazure.reactor.util.context.Context;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class ChannelOperations<INBOUND extends NettyInbound, OUTBOUND extends NettyOutbound>
implements NettyInbound,
NettyOutbound,
Connection,
CoreSubscriber<Void>,
ChannelOperationsId {
    Connection connection;
    final FluxReceive inbound;
    ConnectionObserver listener;
    final Sinks.Empty<Void> onTerminate;
    volatile Subscription outboundSubscription;
    boolean localActive;
    String longId;
    String shortId;
    static final Logger log = Loggers.getLogger(ChannelOperations.class);
    static final Object TERMINATED_OPS = new Object();
    static final OnSetup EMPTY_SETUP = (c, l, msg) -> null;
    static final AtomicReferenceFieldUpdater<ChannelOperations, Subscription> OUTBOUND_CLOSE = AtomicReferenceFieldUpdater.newUpdater(ChannelOperations.class, Subscription.class, "outboundSubscription");

    public static void addReactiveBridge(Channel ch, OnSetup opsFactory, ConnectionObserver listener) {
        Objects.requireNonNull(ch, "channel");
        Objects.requireNonNull(opsFactory, "opsFactory");
        Objects.requireNonNull(listener, "listener");
        ch.pipeline().addLast("com.dataiku.dss.shadelibazure.reactor.right.reactiveBridge", (ChannelHandler)new ChannelOperationsHandler(opsFactory, listener));
    }

    public static void addMetricsHandler(Channel ch, ChannelMetricsRecorder recorder, @Nullable SocketAddress remoteAddress, boolean onServer) {
        Objects.requireNonNull(ch, "channel");
        Objects.requireNonNull(recorder, "recorder");
        SocketAddress remote = remoteAddress;
        if (remote == null) {
            remote = ch.remoteAddress();
        }
        AbstractChannelMetricsHandler handler = recorder instanceof MicrometerChannelMetricsRecorder ? new MicrometerChannelMetricsHandler((MicrometerChannelMetricsRecorder)recorder, remote, onServer) : (recorder instanceof ContextAwareChannelMetricsRecorder ? new ContextAwareChannelMetricsHandler((ContextAwareChannelMetricsRecorder)recorder, remote, onServer) : new ChannelMetricsHandler(recorder, remote, onServer));
        ch.pipeline().addFirst("com.dataiku.dss.shadelibazure.reactor.left.channelMetricsHandler", (ChannelHandler)handler);
    }

    @Nullable
    public static ChannelOperations<?, ?> get(Channel ch) {
        return Connection.from(ch).as(ChannelOperations.class);
    }

    protected ChannelOperations(ChannelOperations<INBOUND, OUTBOUND> replaced) {
        this.connection = replaced.connection;
        this.listener = replaced.listener;
        this.onTerminate = replaced.onTerminate;
        this.inbound = new FluxReceive(this);
        this.shortId = replaced.shortId;
        this.longId = replaced.longId;
        this.localActive = replaced.localActive;
    }

    public ChannelOperations(Connection connection, ConnectionObserver listener) {
        this.connection = Objects.requireNonNull(connection, "connection");
        this.listener = Objects.requireNonNull(listener, "listener");
        this.onTerminate = Sinks.unsafe().empty();
        this.inbound = new FluxReceive(this);
    }

    @Override
    @Nullable
    public <T extends Connection> T as(Class<T> clazz) {
        if (clazz == ChannelOperations.class) {
            ChannelOperations thiz = this;
            return (T)thiz;
        }
        return Connection.super.as(clazz);
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.connection.channel().alloc();
    }

    @Override
    public NettyInbound inbound() {
        return this;
    }

    @Override
    public NettyOutbound outbound() {
        return this;
    }

    @Override
    public final Channel channel() {
        return this.connection.channel();
    }

    @Override
    public ChannelOperations<INBOUND, OUTBOUND> withConnection(Consumer<? super Connection> withConnection) {
        Objects.requireNonNull(withConnection, "withConnection");
        withConnection.accept(this);
        return this;
    }

    @Override
    public void dispose() {
        if (log.isTraceEnabled()) {
            log.trace(ReactorNetty.format(this.channel(), "Disposing ChannelOperation from a channel"), new Exception("ChannelOperation dispose stack"));
        }
        OUTBOUND_CLOSE.set(this, Operators.cancelledSubscription());
        if (!this.inbound.isDisposed()) {
            this.discard();
        }
        if (!this.connection.isDisposed()) {
            this.connection.dispose();
        }
    }

    @Override
    public CoreSubscriber<Void> disposeSubscriber() {
        return this;
    }

    @Override
    public final boolean isDisposed() {
        return !this.channel().isActive() || this.isSubscriptionDisposed();
    }

    public final boolean isSubscriptionDisposed() {
        return OUTBOUND_CLOSE.get(this) == Operators.cancelledSubscription();
    }

    @Override
    public final Mono<Void> onDispose() {
        return this.connection.onDispose();
    }

    @Override
    public Connection onDispose(Disposable onDispose) {
        this.connection.onDispose(onDispose);
        return this;
    }

    @Override
    public final void onComplete() {
        if (this.isDisposed()) {
            return;
        }
        OUTBOUND_CLOSE.set(this, Operators.cancelledSubscription());
        this.onOutboundComplete();
    }

    @Override
    public final void onError(Throwable t) {
        if (this.isDisposed()) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "An outbound error could not be processed"), t);
            }
            this.onUnprocessedOutboundError(t);
            return;
        }
        OUTBOUND_CLOSE.set(this, Operators.cancelledSubscription());
        this.onOutboundError(t);
    }

    @Override
    public final void onNext(Void aVoid) {
    }

    @Override
    public final void onSubscribe(Subscription s2) {
        if (Operators.setOnce(OUTBOUND_CLOSE, this, s2)) {
            s2.request(Long.MAX_VALUE);
        }
    }

    @Override
    public Flux<?> receiveObject() {
        return this.inbound;
    }

    @Override
    public ByteBufFlux receive() {
        return ByteBufFlux.fromInbound(this.receiveObject(), this.connection.channel().alloc());
    }

    @Override
    public NettyOutbound send(Publisher<? extends ByteBuf> dataStream, Predicate<ByteBuf> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        if (!this.channel().isActive()) {
            return this.then(Mono.error(AbortedException.beforeSend()));
        }
        if (dataStream instanceof Mono) {
            return this.then(((Mono)dataStream).flatMap(m3 -> FutureMono.from(this.channel().writeAndFlush(m3))).doOnDiscard(ByteBuf.class, ReferenceCounted::release));
        }
        return this.then(MonoSendMany.byteBufSource(dataStream, this.channel(), predicate));
    }

    @Override
    public NettyOutbound sendObject(Publisher<?> dataStream, Predicate<Object> predicate) {
        Objects.requireNonNull(predicate, "predicate");
        if (!this.channel().isActive()) {
            return this.then(Mono.error(AbortedException.beforeSend()));
        }
        if (dataStream instanceof Mono) {
            return this.then(((Mono)dataStream).flatMap(m3 -> FutureMono.from(this.channel().writeAndFlush(m3))).doOnDiscard(ReferenceCounted.class, ReferenceCounted::release));
        }
        return this.then(MonoSendMany.objectSource(dataStream, this.channel(), predicate));
    }

    @Override
    public NettyOutbound sendObject(Object message) {
        if (!this.channel().isActive()) {
            ReactorNetty.safeRelease(message);
            return this.then(Mono.error(AbortedException.beforeSend()));
        }
        return this.then(FutureMono.deferFuture(() -> this.connection.channel().writeAndFlush(message)), () -> ReactorNetty.safeRelease(message));
    }

    @Override
    public <S> NettyOutbound sendUsing(Callable<? extends S> sourceInput, BiFunction<? super Connection, ? super S, ?> mappedInput, Consumer<? super S> sourceCleanup) {
        Objects.requireNonNull(sourceInput, "sourceInput");
        Objects.requireNonNull(mappedInput, "mappedInput");
        Objects.requireNonNull(sourceCleanup, "sourceCleanup");
        return this.then(Mono.using(sourceInput, s2 -> FutureMono.from(this.connection.channel().writeAndFlush(mappedInput.apply(this, (Object)s2))), sourceCleanup));
    }

    @Override
    public final Mono<Void> onTerminate() {
        if (!this.isPersistent()) {
            return this.connection.onDispose();
        }
        return this.onTerminate.asMono().or(this.connection.onDispose());
    }

    public final ConnectionObserver listener() {
        return this.listener;
    }

    public String toString() {
        return "ChannelOperations{" + this.connection.toString() + "}";
    }

    public final void discard() {
        this.inbound.dispose();
    }

    protected final void discardWhenNoReceiver() {
        if (this.inbound.receiver == null) {
            this.discard();
        }
    }

    public final boolean isInboundCancelled() {
        return this.inbound.isCancelled();
    }

    public final boolean isInboundDisposed() {
        return this.inbound.isDisposed();
    }

    protected final boolean isInboundComplete() {
        return this.inbound.inboundDone;
    }

    protected void onInboundNext(ChannelHandlerContext ctx, Object msg) {
        this.inbound.onInboundNext(msg);
    }

    protected void onInboundCancel() {
        if (log.isDebugEnabled()) {
            String info = this.isDisposed() ? (!this.channel().isActive() ? "channel disconnected" : "subscription disposed") : "operation cancelled";
            log.debug(ReactorNetty.format(this.channel(), "[{}] Channel inbound receiver cancelled ({})."), this.formatName(), info);
        }
    }

    protected void onInboundComplete() {
        this.inbound.onInboundComplete();
    }

    protected void afterInboundComplete() {
    }

    protected void onInboundClose() {
        this.discardWhenNoReceiver();
        this.terminate();
    }

    protected void onOutboundComplete() {
        if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format(this.channel(), "[{}] User Handler requesting close connection"), this.formatName());
        }
        this.markPersistent(false);
        this.terminate();
    }

    protected void onOutboundError(Throwable err) {
        this.markPersistent(false);
        this.terminate();
    }

    protected final void terminate() {
        if (this.rebind(this.connection)) {
            if (log.isTraceEnabled()) {
                log.trace(ReactorNetty.format(this.channel(), "Disposing ChannelOperation from a channel"), new Exception("ChannelOperation terminal stack"));
            }
            Operators.terminate(OUTBOUND_CLOSE, this);
            this.onInboundComplete();
            this.afterInboundComplete();
            this.onTerminate.tryEmitEmpty();
            this.listener.onStateChange(this, ConnectionObserver.State.DISCONNECTING);
            this.connection = new DisposedConnection(this.channel());
            this.listener = ConnectionObserver.emptyListener();
        }
    }

    protected final void onInboundError(Throwable err) {
        this.inbound.onInboundError(err);
    }

    protected final Connection connection() {
        return this.connection;
    }

    protected final String formatName() {
        return this.getClass().getSimpleName().replace("Operations", "");
    }

    protected String initShortId() {
        return this.channel().id().asShortText();
    }

    protected Throwable wrapInboundError(Throwable err) {
        if (err instanceof ClosedChannelException) {
            return new AbortedException(err);
        }
        if (err instanceof OutOfMemoryError) {
            return ReactorNetty.wrapException(err);
        }
        return err;
    }

    protected String asDebugLogMessage(Object o) {
        return o.toString();
    }

    protected void onWritabilityChanged() {
    }

    protected void onUnprocessedOutboundError(Throwable t) {
    }

    @Override
    public boolean isPersistent() {
        return this.connection.isPersistent();
    }

    @Override
    public Context currentContext() {
        return this.listener.currentContext();
    }

    @Override
    public String asShortText() {
        String shortId = this.shortId;
        if (shortId == null) {
            this.shortId = shortId = this.initShortId();
        }
        return shortId;
    }

    @Override
    public String asLongText() {
        boolean active = this.channel().isActive();
        if (this.localActive == active && this.longId != null) {
            return this.longId;
        }
        SocketAddress remoteAddress = this.channel().remoteAddress();
        SocketAddress localAddress = this.channel().localAddress();
        String shortText = this.asShortText();
        if (remoteAddress != null) {
            String localAddressStr = String.valueOf(localAddress);
            String remoteAddressStr = String.valueOf(remoteAddress);
            StringBuilder buf = new StringBuilder(shortText.length() + 4 + localAddressStr.length() + 3 + 2 + remoteAddressStr.length()).append(shortText).append(", L:").append(localAddressStr).append(active ? " - " : " ! ").append("R:").append(remoteAddressStr);
            this.longId = buf.toString();
        } else if (localAddress != null) {
            String localAddressStr = String.valueOf(localAddress);
            StringBuilder buf = new StringBuilder(shortText.length() + 4 + localAddressStr.length()).append(shortText).append(", L:").append(localAddressStr);
            this.longId = buf.toString();
        } else {
            this.longId = shortText;
        }
        this.localActive = active;
        return this.longId;
    }

    static final class DisposedConnection
    implements Connection {
        final Channel channel;

        DisposedConnection(Channel actual) {
            this.channel = new DisposedChannel(actual);
        }

        @Override
        public Channel channel() {
            return this.channel;
        }
    }

    static final class DisposedChannelConfig
    extends DefaultChannelConfig {
        DisposedChannelConfig(Channel channel) {
            super(channel);
        }

        @Override
        public ChannelConfig setAutoRead(boolean autoRead) {
            return this;
        }
    }

    static final class DisposedChannel
    extends AbstractChannel {
        final DefaultChannelConfig config;
        final SocketAddress localAddress;
        final ChannelMetadata metadata;
        final SocketAddress remoteAddress;

        DisposedChannel(Channel actual) {
            super(null);
            this.metadata = actual.metadata();
            this.config = new DisposedChannelConfig(this);
            this.localAddress = actual.localAddress();
            this.remoteAddress = actual.remoteAddress();
        }

        @Override
        public ChannelFuture close() {
            return this.newSucceededFuture();
        }

        @Override
        public ChannelFuture close(ChannelPromise promise) {
            promise.setSuccess();
            return promise;
        }

        @Override
        public ChannelFuture closeFuture() {
            return this.newSucceededFuture();
        }

        @Override
        public ChannelConfig config() {
            return this.config;
        }

        @Override
        protected void doBeginRead() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void doBind(SocketAddress socketAddress) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void doClose() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void doDisconnect() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isActive() {
            return false;
        }

        @Override
        protected boolean isCompatible(EventLoop eventLoop) {
            return false;
        }

        @Override
        public boolean isOpen() {
            return false;
        }

        @Override
        protected SocketAddress localAddress0() {
            return this.localAddress;
        }

        @Override
        public ChannelMetadata metadata() {
            return this.metadata;
        }

        @Override
        protected AbstractChannel.AbstractUnsafe newUnsafe() {
            return new DisposedChannelUnsafe();
        }

        @Override
        protected SocketAddress remoteAddress0() {
            return this.remoteAddress;
        }

        final class DisposedChannelUnsafe
        extends AbstractChannel.AbstractUnsafe {
            DisposedChannelUnsafe() {
            }

            @Override
            public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
                promise.setFailure(new UnsupportedOperationException());
            }
        }
    }

    @FunctionalInterface
    public static interface OnSetup {
        public static OnSetup empty() {
            return EMPTY_SETUP;
        }

        @Nullable
        public ChannelOperations<?, ?> create(Connection var1, ConnectionObserver var2, @Nullable Object var3);
    }
}

