/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.channel;

import com.dataiku.dss.shadelibazure.io.micrometer.core.instrument.Counter;
import com.dataiku.dss.shadelibazure.io.micrometer.core.instrument.DistributionSummary;
import com.dataiku.dss.shadelibazure.io.micrometer.core.instrument.Gauge;
import com.dataiku.dss.shadelibazure.io.micrometer.core.instrument.Meter;
import com.dataiku.dss.shadelibazure.io.micrometer.core.instrument.Timer;
import com.dataiku.dss.shadelibazure.io.micrometer.core.instrument.noop.NoopMeter;
import com.dataiku.dss.shadelibazure.reactor.netty.Metrics;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ChannelMeters;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ChannelMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.MeterKey;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.util.MapUtils;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;

public class MicrometerChannelMetricsRecorder
implements ChannelMetricsRecorder {
    final ConcurrentMap<MeterKey, DistributionSummary> dataReceivedCache = new ConcurrentHashMap<MeterKey, DistributionSummary>();
    final ConcurrentMap<MeterKey, DistributionSummary> dataSentCache = new ConcurrentHashMap<MeterKey, DistributionSummary>();
    final ConcurrentMap<MeterKey, Counter> errorsCache = new ConcurrentHashMap<MeterKey, Counter>();
    final ConcurrentMap<MeterKey, Timer> connectTimeCache = new ConcurrentHashMap<MeterKey, Timer>();
    final ConcurrentMap<MeterKey, Timer> tlsHandshakeTimeCache = new ConcurrentHashMap<MeterKey, Timer>();
    final ConcurrentMap<MeterKey, Timer> addressResolverTimeCache = new ConcurrentHashMap<MeterKey, Timer>();
    final ConcurrentMap<String, LongAdder> totalConnectionsCache = new ConcurrentHashMap<String, LongAdder>();
    final String name;
    final String protocol;
    final boolean onServer;

    public MicrometerChannelMetricsRecorder(String name, String protocol) {
        this(name, protocol, true);
    }

    public MicrometerChannelMetricsRecorder(String name, String protocol, boolean onServer) {
        this.name = name;
        this.protocol = protocol;
        this.onServer = onServer;
    }

    @Override
    public void recordDataReceived(SocketAddress remoteAddress, long bytes) {
        this.recordDataReceived(remoteAddress, "na", bytes);
    }

    @Override
    public void recordDataReceived(SocketAddress remoteAddress, SocketAddress proxyAddress, long bytes) {
        this.recordDataReceived(remoteAddress, Metrics.formatSocketAddress(proxyAddress), bytes);
    }

    void recordDataReceived(SocketAddress remoteAddress, @Nullable String proxyAddress, long bytes) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        MeterKey meterKey = new MeterKey(null, address, proxyAddress, null, null);
        DistributionSummary ds = MapUtils.computeIfAbsent(this.dataReceivedCache, meterKey, key -> {
            DistributionSummary.Builder builder = DistributionSummary.builder((String)(this.name + ".data.received")).baseUnit(ChannelMeters.DATA_RECEIVED.getBaseUnit()).tags(new String[]{ChannelMeters.ChannelMetersTags.URI.asString(), this.protocol, ChannelMeters.ChannelMetersTags.REMOTE_ADDRESS.asString(), address});
            if (!this.onServer) {
                builder.tag(ChannelMeters.ChannelMetersTags.PROXY_ADDRESS.asString(), proxyAddress);
            }
            return MicrometerChannelMetricsRecorder.filter(builder.register(Metrics.REGISTRY));
        });
        if (ds != null) {
            ds.record((double)bytes);
        }
    }

    @Override
    public void recordDataSent(SocketAddress remoteAddress, long bytes) {
        this.recordDataSent(remoteAddress, "na", bytes);
    }

    @Override
    public void recordDataSent(SocketAddress remoteAddress, SocketAddress proxyAddress, long bytes) {
        this.recordDataSent(remoteAddress, Metrics.formatSocketAddress(proxyAddress), bytes);
    }

    void recordDataSent(SocketAddress remoteAddress, @Nullable String proxyAddress, long bytes) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        MeterKey meterKey = new MeterKey(null, address, proxyAddress, null, null);
        DistributionSummary ds = MapUtils.computeIfAbsent(this.dataSentCache, meterKey, key -> {
            DistributionSummary.Builder builder = DistributionSummary.builder((String)(this.name + ".data.sent")).baseUnit(ChannelMeters.DATA_SENT.getBaseUnit()).tags(new String[]{ChannelMeters.ChannelMetersTags.URI.asString(), this.protocol, ChannelMeters.ChannelMetersTags.REMOTE_ADDRESS.asString(), address});
            if (!this.onServer) {
                builder.tag(ChannelMeters.ChannelMetersTags.PROXY_ADDRESS.asString(), proxyAddress);
            }
            return MicrometerChannelMetricsRecorder.filter(builder.register(Metrics.REGISTRY));
        });
        if (ds != null) {
            ds.record((double)bytes);
        }
    }

    @Override
    public void incrementErrorsCount(SocketAddress remoteAddress) {
        this.incrementErrorsCount(remoteAddress, "na");
    }

    @Override
    public void incrementErrorsCount(SocketAddress remoteAddress, SocketAddress proxyAddress) {
        this.incrementErrorsCount(remoteAddress, Metrics.formatSocketAddress(proxyAddress));
    }

    void incrementErrorsCount(SocketAddress remoteAddress, @Nullable String proxyAddress) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        MeterKey meterKey = new MeterKey(null, address, proxyAddress, null, null);
        Counter c = MapUtils.computeIfAbsent(this.errorsCache, meterKey, key -> {
            Counter.Builder builder = Counter.builder((String)(this.name + ".errors")).tags(new String[]{ChannelMeters.ChannelMetersTags.URI.asString(), this.protocol, ChannelMeters.ChannelMetersTags.REMOTE_ADDRESS.asString(), address});
            if (!this.onServer) {
                builder.tag(ChannelMeters.ChannelMetersTags.PROXY_ADDRESS.asString(), proxyAddress);
            }
            return MicrometerChannelMetricsRecorder.filter(builder.register(Metrics.REGISTRY));
        });
        if (c != null) {
            c.increment();
        }
    }

    @Override
    public void recordTlsHandshakeTime(SocketAddress remoteAddress, Duration time, String status) {
        Timer timer = this.getTlsHandshakeTimer(this.name + ".tls.handshake.time", Metrics.formatSocketAddress(remoteAddress), "na", status);
        if (timer != null) {
            timer.record(time);
        }
    }

    @Nullable
    @Deprecated
    public final Timer getTlsHandshakeTimer(String name, @Nullable String address, String status) {
        MeterKey meterKey = new MeterKey(null, address, null, null, status);
        return MapUtils.computeIfAbsent(this.tlsHandshakeTimeCache, meterKey, key -> MicrometerChannelMetricsRecorder.filter(Timer.builder((String)name).tags(new String[]{"remote.address", address, "status", status}).register(Metrics.REGISTRY)));
    }

    @Override
    public void recordTlsHandshakeTime(SocketAddress remoteAddress, SocketAddress proxyAddress, Duration time, String status) {
        Timer timer = this.getTlsHandshakeTimer(this.name + ".tls.handshake.time", Metrics.formatSocketAddress(remoteAddress), Metrics.formatSocketAddress(proxyAddress), status);
        if (timer != null) {
            timer.record(time);
        }
    }

    @Nullable
    public final Timer getTlsHandshakeTimer(String name, @Nullable String remoteAddress, @Nullable String proxyAddress, String status) {
        MeterKey meterKey = new MeterKey(null, remoteAddress, proxyAddress, null, status);
        return MapUtils.computeIfAbsent(this.tlsHandshakeTimeCache, meterKey, key -> {
            Timer.Builder builder = Timer.builder((String)name).tags(new String[]{"remote.address", remoteAddress, "status", status});
            if (!this.onServer) {
                builder.tag("proxy.address", proxyAddress);
            }
            return MicrometerChannelMetricsRecorder.filter(builder.register(Metrics.REGISTRY));
        });
    }

    @Override
    public void recordConnectTime(SocketAddress remoteAddress, Duration time, String status) {
        Timer timer = this.getConnectTimer(this.name + ".connect.time", Metrics.formatSocketAddress(remoteAddress), "na", status);
        if (timer != null) {
            timer.record(time);
        }
    }

    @Override
    public void recordConnectTime(SocketAddress remoteAddress, SocketAddress proxyAddress, Duration time, String status) {
        Timer timer = this.getConnectTimer(this.name + ".connect.time", Metrics.formatSocketAddress(remoteAddress), Metrics.formatSocketAddress(proxyAddress), status);
        if (timer != null) {
            timer.record(time);
        }
    }

    @Nullable
    final Timer getConnectTimer(String name, @Nullable String remoteAddress, @Nullable String proxyAddress, String status) {
        MeterKey meterKey = new MeterKey(null, remoteAddress, proxyAddress, null, status);
        return MapUtils.computeIfAbsent(this.connectTimeCache, meterKey, key -> MicrometerChannelMetricsRecorder.filter(Timer.builder((String)name).tags(new String[]{"remote.address", remoteAddress, "proxy.address", proxyAddress, "status", status}).register(Metrics.REGISTRY)));
    }

    @Override
    public void recordResolveAddressTime(SocketAddress remoteAddress, Duration time, String status) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        Timer timer = this.getResolveAddressTimer(this.name + ".address.resolver", address, status);
        if (timer != null) {
            timer.record(time);
        }
    }

    @Nullable
    public final Timer getResolveAddressTimer(String name, @Nullable String address, String status) {
        MeterKey meterKey = new MeterKey(null, address, null, null, status);
        return MapUtils.computeIfAbsent(this.addressResolverTimeCache, meterKey, key -> MicrometerChannelMetricsRecorder.filter(Timer.builder((String)name).tags(new String[]{"remote.address", address, "status", status}).register(Metrics.REGISTRY)));
    }

    @Override
    public void recordServerConnectionOpened(SocketAddress serverAddress) {
        LongAdder totalConnectionAdder = this.getTotalConnectionsAdder(serverAddress);
        if (totalConnectionAdder != null) {
            totalConnectionAdder.increment();
        }
    }

    @Override
    public void recordServerConnectionClosed(SocketAddress serverAddress) {
        LongAdder totalConnectionAdder = this.getTotalConnectionsAdder(serverAddress);
        if (totalConnectionAdder != null) {
            totalConnectionAdder.decrement();
        }
    }

    @Nullable
    protected static <M extends Meter> M filter(M meter) {
        if (meter instanceof NoopMeter) {
            return null;
        }
        return meter;
    }

    public String name() {
        return this.name;
    }

    public String protocol() {
        return this.protocol;
    }

    @Nullable
    LongAdder getTotalConnectionsAdder(SocketAddress serverAddress) {
        String address = Metrics.formatSocketAddress(serverAddress);
        return MapUtils.computeIfAbsent(this.totalConnectionsCache, address, key -> {
            LongAdder totalConnectionsAdder = new LongAdder();
            Gauge gauge = MicrometerChannelMetricsRecorder.filter(Gauge.builder((String)(this.name + ".connections.total"), (Object)totalConnectionsAdder, LongAdder::longValue).tags(new String[]{ChannelMeters.ConnectionsTotalMeterTags.URI.asString(), this.protocol, ChannelMeters.ConnectionsTotalMeterTags.LOCAL_ADDRESS.asString(), address}).register(Metrics.REGISTRY));
            return gauge != null ? totalConnectionsAdder : null;
        });
    }
}

