/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http;

import com.dataiku.dss.shadelibazure.io.netty.incubator.codec.quic.QuicTokenHandler;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Incubating;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.time.Duration;
import java.util.Objects;

@Incubating
public final class Http3SettingsSpec {
    final Duration idleTimeout;
    final long maxData;
    final long maxStreamDataBidirectionalLocal;
    final long maxStreamDataBidirectionalRemote;
    final long maxStreamsBidirectional;
    final QuicTokenHandler tokenHandler;

    public static Builder builder() {
        return new Build();
    }

    @Nullable
    public Duration idleTimeout() {
        return this.idleTimeout;
    }

    public long maxData() {
        return this.maxData;
    }

    public long maxStreamDataBidirectionalLocal() {
        return this.maxStreamDataBidirectionalLocal;
    }

    public long maxStreamDataBidirectionalRemote() {
        return this.maxStreamDataBidirectionalRemote;
    }

    public long maxStreamsBidirectional() {
        return this.maxStreamsBidirectional;
    }

    @Nullable
    public QuicTokenHandler tokenHandler() {
        return this.tokenHandler;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Http3SettingsSpec)) {
            return false;
        }
        Http3SettingsSpec that = (Http3SettingsSpec)o;
        return Objects.equals(this.idleTimeout, that.idleTimeout) && this.maxData == that.maxData && this.maxStreamDataBidirectionalLocal == that.maxStreamDataBidirectionalLocal && this.maxStreamDataBidirectionalRemote == that.maxStreamDataBidirectionalRemote && this.maxStreamsBidirectional == that.maxStreamsBidirectional && Objects.equals(this.tokenHandler, that.tokenHandler);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.idleTimeout);
        result = 31 * result + Long.hashCode(this.maxData);
        result = 31 * result + Long.hashCode(this.maxStreamDataBidirectionalLocal);
        result = 31 * result + Long.hashCode(this.maxStreamDataBidirectionalRemote);
        result = 31 * result + Long.hashCode(this.maxStreamsBidirectional);
        result = 31 * result + Objects.hashCode(this.tokenHandler);
        return result;
    }

    Http3SettingsSpec(Build build) {
        this.idleTimeout = build.idleTimeout;
        this.maxData = build.maxData;
        this.maxStreamDataBidirectionalLocal = build.maxStreamDataBidirectionalLocal;
        this.maxStreamDataBidirectionalRemote = build.maxStreamDataBidirectionalRemote;
        this.maxStreamsBidirectional = build.maxStreamsBidirectional;
        this.tokenHandler = build.tokenHandler;
    }

    static final class Build
    implements Builder {
        static final long DEFAULT_MAX_DATA = 0L;
        static final long DEFAULT_MAX_STREAM_DATA_BIDIRECTIONAL_LOCAL = 0L;
        static final long DEFAULT_MAX_STREAM_DATA_BIDIRECTIONAL_REMOTE = 0L;
        static final long DEFAULT_MAX_STREAMS_BIDIRECTIONAL = 0L;
        Duration idleTimeout;
        long maxData = 0L;
        long maxStreamDataBidirectionalLocal = 0L;
        long maxStreamDataBidirectionalRemote = 0L;
        long maxStreamsBidirectional = 0L;
        QuicTokenHandler tokenHandler;

        Build() {
        }

        @Override
        public Http3SettingsSpec build() {
            return new Http3SettingsSpec(this);
        }

        @Override
        public Builder idleTimeout(Duration idleTimeout) {
            this.idleTimeout = idleTimeout;
            return this;
        }

        @Override
        public Builder maxData(long maxData) {
            if (maxData < 0L) {
                throw new IllegalArgumentException("maxData must be positive or zero");
            }
            this.maxData = maxData;
            return this;
        }

        @Override
        public Builder maxStreamDataBidirectionalLocal(long maxStreamDataBidirectionalLocal) {
            if (maxStreamDataBidirectionalLocal < 0L) {
                throw new IllegalArgumentException("maxStreamDataBidirectionalLocal must be positive or zero");
            }
            this.maxStreamDataBidirectionalLocal = maxStreamDataBidirectionalLocal;
            return this;
        }

        @Override
        public Builder maxStreamDataBidirectionalRemote(long maxStreamDataBidirectionalRemote) {
            if (maxStreamDataBidirectionalRemote < 0L) {
                throw new IllegalArgumentException("maxStreamDataBidirectionalRemote must be positive or zero");
            }
            this.maxStreamDataBidirectionalRemote = maxStreamDataBidirectionalRemote;
            return this;
        }

        @Override
        public Builder maxStreamsBidirectional(long maxStreamsBidirectional) {
            if (maxStreamsBidirectional < 0L) {
                throw new IllegalArgumentException("maxStreamsBidirectional must be positive or zero");
            }
            this.maxStreamsBidirectional = maxStreamsBidirectional;
            return this;
        }

        @Override
        public Builder tokenHandler(QuicTokenHandler tokenHandler) {
            this.tokenHandler = tokenHandler;
            return this;
        }
    }

    public static interface Builder {
        public Http3SettingsSpec build();

        public Builder idleTimeout(Duration var1);

        public Builder maxData(long var1);

        public Builder maxStreamDataBidirectionalLocal(long var1);

        public Builder maxStreamDataBidirectionalRemote(long var1);

        public Builder maxStreamsBidirectional(long var1);

        public Builder tokenHandler(QuicTokenHandler var1);
    }
}

