/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.client;

import com.dataiku.dss.shadelibazure.io.netty.channel.Channel;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelHandler;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelHandlerAdapter;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelHandlerContext;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelInboundHandlerAdapter;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelInitializer;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelOption;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelPipeline;
import com.dataiku.dss.shadelibazure.io.netty.channel.socket.DatagramChannel;
import com.dataiku.dss.shadelibazure.io.netty.channel.socket.SocketChannel;
import com.dataiku.dss.shadelibazure.io.netty.channel.unix.DomainSocketChannel;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.DefaultHttpHeaders;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpClientCodec;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpClientUpgradeHandler;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpContentDecompressor;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpDecoderConfig;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpHeaders;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpMethod;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpResponse;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpResponseStatus;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.LastHttpContent;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http2.Http2FrameCodec;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http2.Http2FrameLogger;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http2.Http2MultiplexHandler;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http2.Http2Settings;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http2.Http2StreamFrameToHttpObjectCodec;
import com.dataiku.dss.shadelibazure.io.netty.handler.flush.FlushConsolidationHandler;
import com.dataiku.dss.shadelibazure.io.netty.handler.logging.LogLevel;
import com.dataiku.dss.shadelibazure.io.netty.handler.logging.LoggingHandler;
import com.dataiku.dss.shadelibazure.io.netty.handler.ssl.SslHandler;
import com.dataiku.dss.shadelibazure.io.netty.handler.timeout.ReadTimeoutHandler;
import com.dataiku.dss.shadelibazure.io.netty.resolver.AddressResolverGroup;
import com.dataiku.dss.shadelibazure.io.netty.util.ReferenceCountUtil;
import com.dataiku.dss.shadelibazure.org.reactivestreams.Publisher;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.netty.ChannelPipelineConfigurer;
import com.dataiku.dss.shadelibazure.reactor.netty.Connection;
import com.dataiku.dss.shadelibazure.reactor.netty.ConnectionObserver;
import com.dataiku.dss.shadelibazure.reactor.netty.NettyOutbound;
import com.dataiku.dss.shadelibazure.reactor.netty.ReactorNetty;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ChannelMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ChannelOperations;
import com.dataiku.dss.shadelibazure.reactor.netty.http.Http2SettingsSpec;
import com.dataiku.dss.shadelibazure.reactor.netty.http.Http3SettingsSpec;
import com.dataiku.dss.shadelibazure.reactor.netty.http.HttpProtocol;
import com.dataiku.dss.shadelibazure.reactor.netty.http.HttpResources;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.AbstractHttpClientMetricsHandler;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.ContextAwareHttpClientMetricsHandler;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.ContextAwareHttpClientMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.Http2ConnectionProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.Http2Pool;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.Http2StreamBridgeClientHandler;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.Http3ChannelInitializer;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.Http3Codec;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.HttpClient;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.HttpClientMetricsHandler;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.HttpClientMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.HttpClientOperations;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.HttpClientRequest;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.HttpClientResponse;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.HttpClientState;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.HttpConnectionProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.HttpResponseDecoderSpec;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.HttpTrafficHandler;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.MicrometerHttpClientMetricsHandler;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.MicrometerHttpClientMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.PrematureCloseException;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.RedirectClientException;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.WebsocketClientSpec;
import com.dataiku.dss.shadelibazure.reactor.netty.http.logging.HttpMessageLogFactory;
import com.dataiku.dss.shadelibazure.reactor.netty.http.logging.ReactorNettyHttpMessageLogFactory;
import com.dataiku.dss.shadelibazure.reactor.netty.resources.ConnectionProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.resources.LoopResources;
import com.dataiku.dss.shadelibazure.reactor.netty.tcp.SslProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.ClientTransportConfig;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.ProxyProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.logging.AdvancedByteBufFormat;
import com.dataiku.dss.shadelibazure.reactor.util.Logger;
import com.dataiku.dss.shadelibazure.reactor.util.Loggers;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Incubating;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import com.dataiku.dss.shadelibazure.reactor.util.context.Context;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public final class HttpClientConfig
extends ClientTransportConfig<HttpClientConfig> {
    boolean acceptBrotli;
    boolean acceptGzip;
    String baseUrl;
    BiFunction<? super HttpClientRequest, ? super NettyOutbound, ? extends Publisher<Void>> body;
    Function<? super Mono<? extends Connection>, ? extends Mono<? extends Connection>> connector;
    ClientCookieDecoder cookieDecoder;
    ClientCookieEncoder cookieEncoder;
    HttpResponseDecoderSpec decoder;
    Function<Mono<HttpClientConfig>, Mono<HttpClientConfig>> deferredConf;
    BiConsumer<? super HttpClientRequest, ? super Connection> doAfterRequest;
    BiConsumer<? super HttpClientResponse, ? super Connection> doAfterResponseSuccess;
    BiConsumer<? super HttpClientResponse, ? super Connection> doOnRedirect;
    BiConsumer<? super HttpClientRequest, ? super Connection> doOnRequest;
    BiConsumer<? super HttpClientRequest, ? super Throwable> doOnRequestError;
    BiConsumer<? super HttpClientResponse, ? super Connection> doOnResponse;
    BiConsumer<? super HttpClientResponse, ? super Throwable> doOnResponseError;
    BiPredicate<HttpClientRequest, HttpClientResponse> followRedirectPredicate;
    HttpHeaders headers;
    Http2SettingsSpec http2Settings;
    Http3SettingsSpec http3Settings;
    HttpMessageLogFactory httpMessageLogFactory;
    HttpMethod method;
    HttpProtocol[] protocols;
    int _protocols;
    BiConsumer<HttpHeaders, HttpClientRequest> redirectRequestBiConsumer;
    Consumer<HttpClientRequest> redirectRequestConsumer;
    Duration responseTimeout;
    boolean retryDisabled;
    SslProvider sslProvider;
    URI uri;
    String uriStr;
    Function<String, String> uriTagValue;
    WebsocketClientSpec websocketClientSpec;
    static final Pattern FOLLOW_REDIRECT_CODES = Pattern.compile("30[12378]");
    static final BiPredicate<HttpClientRequest, HttpClientResponse> FOLLOW_REDIRECT_PREDICATE = (req, res) -> FOLLOW_REDIRECT_CODES.matcher(res.status().codeAsText()).matches();
    static final int h3 = 8;
    static final int h2 = 2;
    static final int h2c = 1;
    static final int h11 = 4;
    static final int h11orH2 = 6;
    static final int h11orH2C = 5;
    static final Http2StreamFrameToHttpObjectCodec HTTP2_STREAM_FRAME_TO_HTTP_OBJECT = new Http2StreamFrameToHttpObjectCodec(false);
    static final Http2StreamBridgeClientHandler HTTP_2_STREAM_BRIDGE_CLIENT_HANDLER = new Http2StreamBridgeClientHandler();
    static final Logger log = Loggers.getLogger(HttpClientConfig.class);
    static final LoggingHandler LOGGING_HANDLER = AdvancedByteBufFormat.HEX_DUMP.toLoggingHandler(HttpClient.class.getName(), LogLevel.DEBUG, Charset.defaultCharset());
    static final boolean SSL_DEBUG = Boolean.parseBoolean(System.getProperty("com.dataiku.dss.shadelibazure.reactor.netty.tcp.ssl.client.debug", "false"));

    @Nullable
    public String baseUrl() {
        return this.baseUrl;
    }

    @Override
    public int channelHash() {
        int result = super.channelHash();
        result = 31 * result + Boolean.hashCode(this.acceptBrotli);
        result = 31 * result + Boolean.hashCode(this.acceptGzip);
        result = 31 * result + Objects.hashCode(this.decoder);
        result = 31 * result + this._protocols;
        result = 31 * result + Objects.hashCode(this.sslProvider);
        result = 31 * result + Objects.hashCode(this.uriTagValue);
        return result;
    }

    @Override
    public ChannelOperations.OnSetup channelOperationsProvider() {
        return (ch, c, msg) -> new HttpClientOperations(ch, c, this.cookieEncoder, this.cookieDecoder, this.httpMessageLogFactory);
    }

    @Override
    public ConnectionProvider connectionProvider() {
        return this.httpConnectionProvider().http1ConnectionProvider();
    }

    @Deprecated
    public ClientCookieDecoder cookieDecoder() {
        return this.cookieDecoder;
    }

    @Deprecated
    public ClientCookieEncoder cookieEncoder() {
        return this.cookieEncoder;
    }

    public HttpResponseDecoderSpec decoder() {
        return this.decoder;
    }

    @Nullable
    public BiPredicate<HttpClientRequest, HttpClientResponse> followRedirectPredicate() {
        return this.followRedirectPredicate;
    }

    public HttpHeaders headers() {
        return this.headers.copy();
    }

    @Nullable
    public Http2SettingsSpec http2SettingsSpec() {
        return this.http2Settings;
    }

    @Incubating
    @Nullable
    public Http3SettingsSpec http3SettingsSpec() {
        return this.http3Settings;
    }

    public boolean isAcceptBrotli() {
        return this.acceptBrotli;
    }

    public boolean isAcceptGzip() {
        return this.acceptGzip;
    }

    public boolean isRetryDisabled() {
        return this.retryDisabled;
    }

    public boolean isSecure() {
        return this.sslProvider != null;
    }

    public HttpMethod method() {
        return this.method;
    }

    public HttpProtocol[] protocols() {
        return this.protocols;
    }

    @Nullable
    public BiConsumer<HttpHeaders, HttpClientRequest> redirectRequestBiConsumer() {
        return this.redirectRequestBiConsumer;
    }

    @Nullable
    public Consumer<HttpClientRequest> redirectRequestConsumer() {
        return this.redirectRequestConsumer;
    }

    @Nullable
    public Duration responseTimeout() {
        return this.responseTimeout;
    }

    @Nullable
    public SslProvider sslProvider() {
        return this.sslProvider;
    }

    public String uri() {
        return this.uri == null ? this.uriStr : this.uri.toString();
    }

    @Nullable
    public Function<String, String> uriTagValue() {
        return this.uriTagValue;
    }

    @Nullable
    public WebsocketClientSpec websocketClientSpec() {
        return this.websocketClientSpec;
    }

    HttpClientConfig(HttpConnectionProvider connectionProvider, Map<ChannelOption<?>, ?> options, Supplier<? extends SocketAddress> remoteAddress) {
        super(connectionProvider, options, remoteAddress);
        this.acceptBrotli = false;
        this.acceptGzip = false;
        this.cookieDecoder = ClientCookieDecoder.STRICT;
        this.cookieEncoder = ClientCookieEncoder.STRICT;
        this.decoder = new HttpResponseDecoderSpec();
        this.headers = new DefaultHttpHeaders();
        this.httpMessageLogFactory = ReactorNettyHttpMessageLogFactory.INSTANCE;
        this.method = HttpMethod.GET;
        this.protocols = new HttpProtocol[]{HttpProtocol.HTTP11};
        this._protocols = 4;
        this.retryDisabled = false;
    }

    HttpClientConfig(HttpClientConfig parent) {
        super(parent);
        this.acceptBrotli = parent.acceptBrotli;
        this.acceptGzip = parent.acceptGzip;
        this.baseUrl = parent.baseUrl;
        this.body = parent.body;
        this.connector = parent.connector;
        this.cookieDecoder = parent.cookieDecoder;
        this.cookieEncoder = parent.cookieEncoder;
        this.decoder = parent.decoder;
        this.deferredConf = parent.deferredConf;
        this.doAfterRequest = parent.doAfterRequest;
        this.doAfterResponseSuccess = parent.doAfterResponseSuccess;
        this.doOnRedirect = parent.doOnRedirect;
        this.doOnRequest = parent.doOnRequest;
        this.doOnRequestError = parent.doOnRequestError;
        this.doOnResponse = parent.doOnResponse;
        this.doOnResponseError = parent.doOnResponseError;
        this.followRedirectPredicate = parent.followRedirectPredicate;
        this.headers = parent.headers;
        this.http2Settings = parent.http2Settings;
        this.http3Settings = parent.http3Settings;
        this.httpMessageLogFactory = parent.httpMessageLogFactory;
        this.method = parent.method;
        this.protocols = parent.protocols;
        this._protocols = parent._protocols;
        this.redirectRequestBiConsumer = parent.redirectRequestBiConsumer;
        this.redirectRequestConsumer = parent.redirectRequestConsumer;
        this.responseTimeout = parent.responseTimeout;
        this.retryDisabled = parent.retryDisabled;
        this.sslProvider = parent.sslProvider;
        this.uri = parent.uri;
        this.uriStr = parent.uriStr;
        this.uriTagValue = parent.uriTagValue;
        this.websocketClientSpec = parent.websocketClientSpec;
    }

    @Override
    public ChannelInitializer<Channel> channelInitializer(ConnectionObserver connectionObserver, @Nullable SocketAddress remoteAddress, boolean onServer) {
        Http3ChannelInitializer channelInitializer = super.channelInitializer(connectionObserver, remoteAddress, onServer);
        return (this._protocols & 8) == 8 ? new Http3ChannelInitializer(this, channelInitializer, connectionObserver, remoteAddress) : channelInitializer;
    }

    @Override
    public AddressResolverGroup<?> defaultAddressResolverGroup() {
        return HttpResources.get().getOrCreateDefaultResolver();
    }

    @Override
    protected void bindAddress(Supplier<? extends SocketAddress> bindAddressSupplier) {
        super.bindAddress(bindAddressSupplier);
    }

    @Override
    protected Class<? extends Channel> channelType(boolean isDomainSocket) {
        return isDomainSocket ? DomainSocketChannel.class : ((this._protocols & 8) == 8 ? DatagramChannel.class : SocketChannel.class);
    }

    @Override
    protected ConnectionObserver defaultConnectionObserver() {
        if (this.doAfterRequest == null && this.doAfterResponseSuccess == null && this.doOnRedirect == null && this.doOnRequest == null && this.doOnRequestError == null && this.doOnResponse == null && this.doOnResponseError == null) {
            return super.defaultConnectionObserver();
        }
        return super.defaultConnectionObserver().then(new HttpClientDoOn(this.doAfterRequest, this.doAfterResponseSuccess, this.doOnRedirect, this.doOnRequest, this.doOnRequestError, this.doOnResponse, this.doOnResponseError));
    }

    @Override
    protected LoggingHandler defaultLoggingHandler() {
        return LOGGING_HANDLER;
    }

    @Override
    protected LoopResources defaultLoopResources() {
        return HttpResources.get();
    }

    @Override
    protected ChannelMetricsRecorder defaultMetricsRecorder() {
        return MicrometerHttpClientMetricsRecorder.INSTANCE;
    }

    @Override
    protected ChannelPipelineConfigurer defaultOnChannelInit() {
        return super.defaultOnChannelInit().then(new HttpClientChannelInitializer(this));
    }

    @Override
    protected void loggingHandler(LoggingHandler loggingHandler) {
        super.loggingHandler(loggingHandler);
    }

    @Override
    protected void metricsRecorder(@Nullable Supplier<? extends ChannelMetricsRecorder> metricsRecorder) {
        super.metricsRecorder(metricsRecorder);
    }

    @Override
    protected void proxyProvider(ProxyProvider proxyProvider) {
        super.proxyProvider(proxyProvider);
    }

    @Override
    protected void proxyProviderSupplier(Supplier<ProxyProvider> proxyProviderSupplier) {
        super.proxyProviderSupplier(proxyProviderSupplier);
    }

    @Override
    protected AddressResolverGroup<?> resolverInternal() {
        return super.resolverInternal();
    }

    void deferredConf(Function<HttpClientConfig, Mono<HttpClientConfig>> deferrer) {
        this.deferredConf = this.deferredConf != null ? this.deferredConf.andThen(deferredConf -> deferredConf.flatMap(deferrer)) : deferredConf -> deferredConf.flatMap(deferrer);
    }

    HttpConnectionProvider httpConnectionProvider() {
        return (HttpConnectionProvider)super.connectionProvider();
    }

    void protocols(HttpProtocol ... protocols) {
        this.protocols = protocols;
        int _protocols = 0;
        for (HttpProtocol p : protocols) {
            if (p == HttpProtocol.HTTP11) {
                _protocols |= 4;
                continue;
            }
            if (p == HttpProtocol.H2) {
                _protocols |= 2;
                continue;
            }
            if (p == HttpProtocol.H2C) {
                _protocols |= 1;
                continue;
            }
            if (p != HttpProtocol.HTTP3) continue;
            _protocols |= 8;
        }
        this._protocols = _protocols;
    }

    boolean checkProtocol(int protocol) {
        return (this._protocols & protocol) == protocol;
    }

    Http2Settings http2Settings() {
        Http2Settings settings = Http2Settings.defaultSettings();
        if (this.http2Settings != null) {
            Integer maxFrameSize;
            Long maxConcurrentStreams;
            Integer initialWindowSize;
            Long headerTableSize = this.http2Settings.headerTableSize();
            if (headerTableSize != null) {
                settings.headerTableSize(headerTableSize);
            }
            if ((initialWindowSize = this.http2Settings.initialWindowSize()) != null) {
                settings.initialWindowSize(initialWindowSize);
            }
            if ((maxConcurrentStreams = this.http2Settings.maxConcurrentStreams()) != null) {
                settings.maxConcurrentStreams(maxConcurrentStreams);
            }
            if ((maxFrameSize = this.http2Settings.maxFrameSize()) != null) {
                settings.maxFrameSize(maxFrameSize);
            }
            settings.maxHeaderListSize(this.http2Settings.maxHeaderListSize());
            Boolean pushEnabled = this.http2Settings.pushEnabled();
            if (pushEnabled != null) {
                settings.pushEnabled(pushEnabled);
            }
        }
        return settings;
    }

    static void addStreamHandlers(Channel ch, ConnectionObserver obs, ChannelOperations.OnSetup opsFactory, boolean acceptGzip, boolean copyState, @Nullable ChannelMetricsRecorder metricsRecorder, @Nullable SocketAddress proxyAddress, SocketAddress remoteAddress, long responseTimeoutMillis, @Nullable Function<String, String> uriTagValue) {
        ChannelOperations<?, ?> ops;
        if (HttpClientOperations.log.isDebugEnabled()) {
            HttpClientOperations.log.debug(ReactorNetty.format(ch, "New HTTP/2 stream"));
        }
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("com.dataiku.dss.shadelibazure.reactor.left.h2ToHttp11Codec", (ChannelHandler)HTTP2_STREAM_FRAME_TO_HTTP_OBJECT).addLast("com.dataiku.dss.shadelibazure.reactor.left.httpTrafficHandler", (ChannelHandler)HTTP_2_STREAM_BRIDGE_CLIENT_HANDLER);
        if (acceptGzip) {
            pipeline.addLast("com.dataiku.dss.shadelibazure.reactor.left.httpDecompressor", (ChannelHandler)new HttpContentDecompressor(false, 0));
        }
        ChannelOperations.addReactiveBridge(ch, opsFactory, obs);
        if (metricsRecorder != null && metricsRecorder instanceof HttpClientMetricsRecorder) {
            AbstractHttpClientMetricsHandler handler;
            Channel parent = ch.parent();
            ChannelHandler existingHandler = parent.pipeline().get("com.dataiku.dss.shadelibazure.reactor.left.httpMetricsHandler");
            if (existingHandler != null) {
                parent.pipeline().remove("com.dataiku.dss.shadelibazure.reactor.left.httpMetricsHandler");
                handler = metricsRecorder instanceof MicrometerHttpClientMetricsRecorder ? new MicrometerHttpClientMetricsHandler((MicrometerHttpClientMetricsHandler)existingHandler) : (metricsRecorder instanceof ContextAwareHttpClientMetricsRecorder ? new ContextAwareHttpClientMetricsHandler((ContextAwareHttpClientMetricsHandler)existingHandler) : new HttpClientMetricsHandler((HttpClientMetricsHandler)existingHandler));
            } else {
                handler = metricsRecorder instanceof MicrometerHttpClientMetricsRecorder ? new MicrometerHttpClientMetricsHandler((MicrometerHttpClientMetricsRecorder)metricsRecorder, remoteAddress, proxyAddress, uriTagValue) : (metricsRecorder instanceof ContextAwareHttpClientMetricsRecorder ? new ContextAwareHttpClientMetricsHandler((ContextAwareHttpClientMetricsRecorder)metricsRecorder, remoteAddress, proxyAddress, uriTagValue) : new HttpClientMetricsHandler((HttpClientMetricsRecorder)metricsRecorder, remoteAddress, proxyAddress, uriTagValue));
            }
            pipeline.addBefore("com.dataiku.dss.shadelibazure.reactor.right.reactiveBridge", "com.dataiku.dss.shadelibazure.reactor.left.httpMetricsHandler", handler);
        }
        if (responseTimeoutMillis > -1L) {
            Connection conn = Connection.from(ch);
            if (ch.pipeline().get("com.dataiku.dss.shadelibazure.reactor.left.httpMetricsHandler") != null) {
                if (ch.pipeline().get("com.dataiku.dss.shadelibazure.reactor.left.responseTimeoutHandler") == null) {
                    ch.pipeline().addBefore("com.dataiku.dss.shadelibazure.reactor.left.httpMetricsHandler", "com.dataiku.dss.shadelibazure.reactor.left.responseTimeoutHandler", new ReadTimeoutHandler(responseTimeoutMillis, TimeUnit.MILLISECONDS));
                    if (conn.isPersistent()) {
                        conn.onTerminate().subscribe(null, null, () -> conn.removeHandler("com.dataiku.dss.shadelibazure.reactor.left.responseTimeoutHandler"));
                    }
                }
            } else {
                conn.addHandlerFirst("com.dataiku.dss.shadelibazure.reactor.left.responseTimeoutHandler", new ReadTimeoutHandler(responseTimeoutMillis, TimeUnit.MILLISECONDS));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format(ch, "Initialized HTTP/2 stream pipeline {}"), ch.pipeline());
        }
        if ((ops = opsFactory.create(Connection.from(ch), obs, null)) != null) {
            ops.bind();
            if (copyState && ops instanceof HttpClientOperations) {
                HttpClientOperations.copyState((HttpClientOperations)ops);
            }
        }
    }

    static void configureHttp2Pipeline(ChannelPipeline p, HttpResponseDecoderSpec decoder, Http2Settings http2Settings, ConnectionObserver observer) {
        Http2FrameCodecBuilder http2FrameCodecBuilder = Http2FrameCodecBuilder.forClient().validateHeaders(decoder.validateHeaders()).initialSettings(http2Settings);
        if (p.get("com.dataiku.dss.shadelibazure.reactor.left.loggingHandler") != null) {
            http2FrameCodecBuilder.frameLogger(new Http2FrameLogger(LogLevel.DEBUG, "com.dataiku.dss.shadelibazure.reactor.netty.http.client.h2"));
        }
        p.addBefore("com.dataiku.dss.shadelibazure.reactor.right.reactiveBridge", "com.dataiku.dss.shadelibazure.reactor.left.h2Flush", new FlushConsolidationHandler(1024, true)).addBefore("com.dataiku.dss.shadelibazure.reactor.right.reactiveBridge", "com.dataiku.dss.shadelibazure.reactor.left.httpCodec", http2FrameCodecBuilder.build()).addBefore("com.dataiku.dss.shadelibazure.reactor.right.reactiveBridge", "com.dataiku.dss.shadelibazure.reactor.left.h2MultiplexHandler", new Http2MultiplexHandler(H2InboundStreamHandler.INSTANCE)).addBefore("com.dataiku.dss.shadelibazure.reactor.right.reactiveBridge", "com.dataiku.dss.shadelibazure.reactor.left.httpTrafficHandler", new HttpTrafficHandler(observer));
    }

    static void configureHttp3Pipeline(ChannelPipeline p, boolean removeMetricsRecorder, boolean removeProxyProvider) {
        p.remove("com.dataiku.dss.shadelibazure.reactor.right.reactiveBridge");
        p.addLast("com.dataiku.dss.shadelibazure.reactor.left.httpCodec", Http3Codec.newHttp3ClientConnectionHandler());
        if (removeMetricsRecorder) {
            p.remove("com.dataiku.dss.shadelibazure.reactor.left.channelMetricsHandler");
        }
        if (removeProxyProvider) {
            p.remove("com.dataiku.dss.shadelibazure.reactor.left.proxyHandler");
        }
    }

    static void configureHttp11OrH2CleartextPipeline(ChannelPipeline p, boolean acceptGzip, HttpResponseDecoderSpec decoder, Http2Settings http2Settings, @Nullable ChannelMetricsRecorder metricsRecorder, ConnectionObserver observer, ChannelOperations.OnSetup opsFactory, @Nullable SocketAddress proxyAddress, SocketAddress remoteAddress, @Nullable Function<String, String> uriTagValue) {
        HttpDecoderConfig decoderConfig = new HttpDecoderConfig();
        decoderConfig.setMaxInitialLineLength(decoder.maxInitialLineLength()).setMaxHeaderSize(decoder.maxHeaderSize()).setMaxChunkSize(decoder.maxChunkSize()).setValidateHeaders(decoder.validateHeaders()).setInitialBufferSize(decoder.initialBufferSize()).setAllowDuplicateContentLengths(decoder.allowDuplicateContentLengths()).setAllowPartialChunks(decoder.allowPartialChunks());
        HttpClientCodec httpClientCodec = new HttpClientCodec(decoderConfig, decoder.failOnMissingResponse, decoder.parseHttpAfterConnectRequest);
        Http2FrameCodecBuilder http2FrameCodecBuilder = Http2FrameCodecBuilder.forClient().validateHeaders(decoder.validateHeaders()).initialSettings(http2Settings);
        if (p.get("com.dataiku.dss.shadelibazure.reactor.left.loggingHandler") != null) {
            http2FrameCodecBuilder.frameLogger(new Http2FrameLogger(LogLevel.DEBUG, "com.dataiku.dss.shadelibazure.reactor.netty.http.client.h2"));
        }
        Http2FrameCodec http2FrameCodec = http2FrameCodecBuilder.build();
        Http2ClientUpgradeCodec upgradeCodec = new Http2ClientUpgradeCodec(http2FrameCodec, new H2CleartextCodec(http2FrameCodec, opsFactory, acceptGzip, metricsRecorder, proxyAddress, remoteAddress, uriTagValue));
        ReactorNettyHttpClientUpgradeHandler upgradeHandler = new ReactorNettyHttpClientUpgradeHandler(httpClientCodec, upgradeCodec, decoder.h2cMaxContentLength());
        p.addBefore("com.dataiku.dss.shadelibazure.reactor.right.reactiveBridge", null, httpClientCodec).addBefore("com.dataiku.dss.shadelibazure.reactor.right.reactiveBridge", "com.dataiku.dss.shadelibazure.reactor.left.h2cUpgradeHandler", upgradeHandler).addBefore("com.dataiku.dss.shadelibazure.reactor.right.reactiveBridge", "com.dataiku.dss.shadelibazure.reactor.left.httpTrafficHandler", new HttpTrafficHandler(observer));
        if (acceptGzip) {
            p.addBefore("com.dataiku.dss.shadelibazure.reactor.right.reactiveBridge", "com.dataiku.dss.shadelibazure.reactor.left.httpDecompressor", new HttpContentDecompressor(false, 0));
        }
        if (metricsRecorder != null && metricsRecorder instanceof HttpClientMetricsRecorder) {
            AbstractHttpClientMetricsHandler handler = metricsRecorder instanceof MicrometerHttpClientMetricsRecorder ? new MicrometerHttpClientMetricsHandler((MicrometerHttpClientMetricsRecorder)metricsRecorder, remoteAddress, proxyAddress, uriTagValue) : (metricsRecorder instanceof ContextAwareHttpClientMetricsRecorder ? new ContextAwareHttpClientMetricsHandler((ContextAwareHttpClientMetricsRecorder)metricsRecorder, remoteAddress, proxyAddress, uriTagValue) : new HttpClientMetricsHandler((HttpClientMetricsRecorder)metricsRecorder, remoteAddress, proxyAddress, uriTagValue));
            p.addBefore("com.dataiku.dss.shadelibazure.reactor.right.reactiveBridge", "com.dataiku.dss.shadelibazure.reactor.left.httpMetricsHandler", handler);
        }
    }

    static void configureHttp11Pipeline(ChannelPipeline p, boolean acceptGzip, HttpResponseDecoderSpec decoder, @Nullable ChannelMetricsRecorder metricsRecorder, @Nullable SocketAddress proxyAddress, SocketAddress remoteAddress, @Nullable Function<String, String> uriTagValue) {
        HttpDecoderConfig decoderConfig = new HttpDecoderConfig();
        decoderConfig.setMaxInitialLineLength(decoder.maxInitialLineLength()).setMaxHeaderSize(decoder.maxHeaderSize()).setMaxChunkSize(decoder.maxChunkSize()).setValidateHeaders(decoder.validateHeaders()).setInitialBufferSize(decoder.initialBufferSize()).setAllowDuplicateContentLengths(decoder.allowDuplicateContentLengths()).setAllowPartialChunks(decoder.allowPartialChunks());
        p.addBefore("com.dataiku.dss.shadelibazure.reactor.right.reactiveBridge", "com.dataiku.dss.shadelibazure.reactor.left.httpCodec", new HttpClientCodec(decoderConfig, decoder.failOnMissingResponse, decoder.parseHttpAfterConnectRequest));
        if (acceptGzip) {
            p.addAfter("com.dataiku.dss.shadelibazure.reactor.left.httpCodec", "com.dataiku.dss.shadelibazure.reactor.left.httpDecompressor", new HttpContentDecompressor(false, 0));
        }
        if (metricsRecorder != null && metricsRecorder instanceof HttpClientMetricsRecorder) {
            AbstractHttpClientMetricsHandler handler = metricsRecorder instanceof MicrometerHttpClientMetricsRecorder ? new MicrometerHttpClientMetricsHandler((MicrometerHttpClientMetricsRecorder)metricsRecorder, remoteAddress, proxyAddress, uriTagValue) : (metricsRecorder instanceof ContextAwareHttpClientMetricsRecorder ? new ContextAwareHttpClientMetricsHandler((ContextAwareHttpClientMetricsRecorder)metricsRecorder, remoteAddress, proxyAddress, uriTagValue) : new HttpClientMetricsHandler((HttpClientMetricsRecorder)metricsRecorder, remoteAddress, proxyAddress, uriTagValue));
            p.addBefore("com.dataiku.dss.shadelibazure.reactor.right.reactiveBridge", "com.dataiku.dss.shadelibazure.reactor.left.httpMetricsHandler", handler);
        }
    }

    static final class StreamConnectionObserver
    implements ConnectionObserver {
        final Context context;

        StreamConnectionObserver(Context context) {
            this.context = context;
        }

        @Override
        public Context currentContext() {
            return this.context;
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State state) {
            if (state == ConnectionObserver.State.DISCONNECTING && connection.channel().isActive()) {
                connection.channel().close();
            }
        }
    }

    static final class ReactorNettyHttpClientUpgradeHandler
    extends HttpClientUpgradeHandler {
        boolean is100Continue;

        ReactorNettyHttpClientUpgradeHandler(HttpClientUpgradeHandler.SourceCodec sourceCodec, HttpClientUpgradeHandler.UpgradeCodec upgradeCodec, int maxContentLength) {
            super(sourceCodec, upgradeCodec, maxContentLength);
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg instanceof HttpResponse) {
                if (HttpResponseStatus.CONTINUE.equals(((HttpResponse)msg).status())) {
                    this.is100Continue = true;
                    ReferenceCountUtil.release(msg);
                    ctx.read();
                    return;
                }
                this.is100Continue = false;
            }
            if (this.is100Continue && msg instanceof LastHttpContent) {
                this.is100Continue = false;
                ((LastHttpContent)msg).release();
                return;
            }
            super.channelRead(ctx, msg);
        }
    }

    static final class HttpClientDoOn
    implements ConnectionObserver {
        final BiConsumer<? super HttpClientRequest, ? super Connection> doAfterRequest;
        final BiConsumer<? super HttpClientResponse, ? super Connection> doAfterResponseSuccess;
        final BiConsumer<? super HttpClientResponse, ? super Connection> doOnRedirect;
        final BiConsumer<? super HttpClientRequest, ? super Connection> doOnRequest;
        final BiConsumer<? super HttpClientRequest, ? super Throwable> doOnRequestError;
        final BiConsumer<? super HttpClientResponse, ? super Connection> doOnResponse;
        final BiConsumer<? super HttpClientResponse, ? super Throwable> doOnResponseError;

        HttpClientDoOn(@Nullable BiConsumer<? super HttpClientRequest, ? super Connection> doAfterRequest, @Nullable BiConsumer<? super HttpClientResponse, ? super Connection> doAfterResponseSuccess, @Nullable BiConsumer<? super HttpClientResponse, ? super Connection> doOnRedirect, @Nullable BiConsumer<? super HttpClientRequest, ? super Connection> doOnRequest, @Nullable BiConsumer<? super HttpClientRequest, ? super Throwable> doOnRequestError, @Nullable BiConsumer<? super HttpClientResponse, ? super Connection> doOnResponse, @Nullable BiConsumer<? super HttpClientResponse, ? super Throwable> doOnResponseError) {
            this.doAfterRequest = doAfterRequest;
            this.doAfterResponseSuccess = doAfterResponseSuccess;
            this.doOnRedirect = doOnRedirect;
            this.doOnRequest = doOnRequest;
            this.doOnRequestError = doOnRequestError;
            this.doOnResponse = doOnResponse;
            this.doOnResponseError = doOnResponseError;
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if (this.doOnRequest != null && newState == HttpClientState.REQUEST_PREPARED) {
                this.doOnRequest.accept(connection.as(HttpClientOperations.class), connection);
                return;
            }
            if (this.doAfterResponseSuccess != null && newState == HttpClientState.RESPONSE_COMPLETED) {
                this.doAfterResponseSuccess.accept(connection.as(HttpClientOperations.class), connection);
                return;
            }
            if (this.doAfterRequest != null && newState == HttpClientState.REQUEST_SENT) {
                this.doAfterRequest.accept(connection.as(HttpClientOperations.class), connection);
                return;
            }
            if (this.doOnResponse != null && newState == HttpClientState.RESPONSE_RECEIVED) {
                this.doOnResponse.accept(connection.as(HttpClientOperations.class), connection);
                return;
            }
            if (this.doOnResponseError != null && newState == HttpClientState.RESPONSE_INCOMPLETE) {
                HttpClientOperations ops = connection.as(HttpClientOperations.class);
                if (ops == null) {
                    return;
                }
                if (ops.responseState != null) {
                    this.doOnResponseError.accept(ops, new PrematureCloseException("Connection prematurely closed DURING response"));
                }
            }
        }

        @Override
        public void onUncaughtException(Connection connection, Throwable error) {
            if (this.doOnRedirect != null && error instanceof RedirectClientException) {
                this.doOnRedirect.accept(connection.as(HttpClientOperations.class), connection);
                return;
            }
            HttpClientOperations ops = connection.as(HttpClientOperations.class);
            if (ops == null) {
                return;
            }
            if (this.doOnRequestError != null && ops.retrying && ops.responseState == null) {
                this.doOnRequestError.accept(connection.as(HttpClientOperations.class), error);
                return;
            }
            if (this.doOnResponseError != null && ops.responseState != null && !(error instanceof RedirectClientException)) {
                this.doOnResponseError.accept(connection.as(HttpClientOperations.class), error);
            }
        }
    }

    static final class HttpClientChannelInitializer
    implements ChannelPipelineConfigurer {
        final boolean acceptGzip;
        final HttpResponseDecoderSpec decoder;
        final Http2Settings http2Settings;
        final ChannelMetricsRecorder metricsRecorder;
        final ChannelOperations.OnSetup opsFactory;
        final int protocols;
        final SocketAddress proxyAddress;
        final SslProvider sslProvider;
        final Function<String, String> uriTagValue;

        HttpClientChannelInitializer(HttpClientConfig config) {
            this.acceptGzip = config.acceptGzip;
            this.decoder = config.decoder;
            this.http2Settings = config.http2Settings();
            this.metricsRecorder = config.metricsRecorderInternal();
            this.opsFactory = config.channelOperationsProvider();
            this.protocols = config._protocols;
            this.proxyAddress = config.proxyProvider() != null ? config.proxyProvider().getProxyAddress() : null;
            this.sslProvider = config.sslProvider;
            this.uriTagValue = config.uriTagValue;
        }

        @Override
        public void onChannelInit(ConnectionObserver observer, Channel channel, @Nullable SocketAddress remoteAddress) {
            if (this.sslProvider != null) {
                if ((this.protocols & 8) != 8) {
                    this.sslProvider.addSslHandler(channel, remoteAddress, SSL_DEBUG);
                }
                if ((this.protocols & 6) == 6) {
                    channel.pipeline().addBefore("com.dataiku.dss.shadelibazure.reactor.right.reactiveBridge", "com.dataiku.dss.shadelibazure.reactor.left.h2OrHttp11Codec", new H2OrHttp11Codec(this, observer, remoteAddress));
                } else if ((this.protocols & 4) == 4) {
                    HttpClientConfig.configureHttp11Pipeline(channel.pipeline(), this.acceptGzip, this.decoder, this.metricsRecorder, this.proxyAddress, remoteAddress, this.uriTagValue);
                } else if ((this.protocols & 2) == 2) {
                    HttpClientConfig.configureHttp2Pipeline(channel.pipeline(), this.decoder, this.http2Settings, observer);
                } else if ((this.protocols & 8) == 8) {
                    HttpClientConfig.configureHttp3Pipeline(channel.pipeline(), this.metricsRecorder != null, this.proxyAddress != null);
                }
            } else if ((this.protocols & 5) == 5) {
                HttpClientConfig.configureHttp11OrH2CleartextPipeline(channel.pipeline(), this.acceptGzip, this.decoder, this.http2Settings, this.metricsRecorder, observer, this.opsFactory, this.proxyAddress, remoteAddress, this.uriTagValue);
            } else if ((this.protocols & 4) == 4) {
                HttpClientConfig.configureHttp11Pipeline(channel.pipeline(), this.acceptGzip, this.decoder, this.metricsRecorder, this.proxyAddress, remoteAddress, this.uriTagValue);
            } else if ((this.protocols & 1) == 1) {
                HttpClientConfig.configureHttp2Pipeline(channel.pipeline(), this.decoder, this.http2Settings, observer);
            }
        }
    }

    static final class H2OrHttp11Codec
    extends ChannelInboundHandlerAdapter {
        final boolean acceptGzip;
        final HttpResponseDecoderSpec decoder;
        final Http2Settings http2Settings;
        final ChannelMetricsRecorder metricsRecorder;
        final ConnectionObserver observer;
        final SocketAddress proxyAddress;
        final SocketAddress remoteAddress;
        final Function<String, String> uriTagValue;

        H2OrHttp11Codec(HttpClientChannelInitializer initializer, ConnectionObserver observer, SocketAddress remoteAddress) {
            this.acceptGzip = initializer.acceptGzip;
            this.decoder = initializer.decoder;
            this.http2Settings = initializer.http2Settings;
            this.metricsRecorder = initializer.metricsRecorder;
            this.observer = observer;
            this.proxyAddress = initializer.proxyAddress;
            this.remoteAddress = remoteAddress;
            this.uriTagValue = initializer.uriTagValue;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void channelActive(ChannelHandlerContext ctx) {
            String protocol;
            ChannelHandler handler = ctx.pipeline().get("com.dataiku.dss.shadelibazure.reactor.left.sslHandler");
            if (!(handler instanceof SslHandler)) throw new IllegalStateException("Cannot determine negotiated application-level protocol.");
            SslHandler sslHandler = (SslHandler)handler;
            String string = protocol = sslHandler.applicationProtocol() != null ? sslHandler.applicationProtocol() : "http/1.1";
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(ctx.channel(), "Negotiated application-level protocol [" + protocol + "]"));
            }
            if ("h2".equals(protocol)) {
                HttpClientConfig.configureHttp2Pipeline(ctx.channel().pipeline(), this.decoder, this.http2Settings, this.observer);
            } else {
                if (!"http/1.1".equals(protocol)) throw new IllegalStateException("unknown protocol: " + protocol);
                HttpClientConfig.configureHttp11Pipeline(ctx.channel().pipeline(), this.acceptGzip, this.decoder, this.metricsRecorder, this.proxyAddress, this.remoteAddress, this.uriTagValue);
            }
            ctx.fireChannelActive();
            ctx.channel().pipeline().remove(this);
        }
    }

    static final class H2InboundStreamHandler
    extends ChannelHandlerAdapter {
        static final ChannelHandler INSTANCE = new H2InboundStreamHandler();

        H2InboundStreamHandler() {
        }

        @Override
        public boolean isSharable() {
            return true;
        }
    }

    static final class H2Codec
    extends ChannelInitializer<Channel> {
        final boolean acceptGzip;
        final ChannelMetricsRecorder metricsRecorder;
        final ConnectionObserver observer;
        final ChannelOperations.OnSetup opsFactory;
        final Http2ConnectionProvider.DisposableAcquire owner;
        final long responseTimeoutMillis;
        final SocketAddress proxyAddress;
        final SocketAddress remoteAddress;
        final Function<String, String> uriTagValue;

        H2Codec(@Nullable Http2ConnectionProvider.DisposableAcquire owner, @Nullable ConnectionObserver observer, ChannelOperations.OnSetup opsFactory, boolean acceptGzip, @Nullable ChannelMetricsRecorder metricsRecorder, @Nullable SocketAddress proxyAddress, SocketAddress remoteAddress, @Nullable Function<String, String> uriTagValue) {
            this(owner, observer, opsFactory, acceptGzip, metricsRecorder, proxyAddress, remoteAddress, -1L, uriTagValue);
        }

        H2Codec(@Nullable Http2ConnectionProvider.DisposableAcquire owner, @Nullable ConnectionObserver observer, ChannelOperations.OnSetup opsFactory, boolean acceptGzip, @Nullable ChannelMetricsRecorder metricsRecorder, @Nullable SocketAddress proxyAddress, SocketAddress remoteAddress, long responseTimeoutMillis, @Nullable Function<String, String> uriTagValue) {
            this.acceptGzip = acceptGzip;
            this.metricsRecorder = metricsRecorder;
            this.observer = observer;
            this.opsFactory = opsFactory;
            this.owner = owner;
            this.responseTimeoutMillis = responseTimeoutMillis;
            this.proxyAddress = proxyAddress;
            this.remoteAddress = remoteAddress;
            this.uriTagValue = uriTagValue;
        }

        @Override
        protected void initChannel(Channel ch) {
            if (this.observer != null && this.opsFactory != null && this.owner != null) {
                Http2ConnectionProvider.registerClose(ch, this.owner);
                if (!this.owner.currentContext().isEmpty()) {
                    ReactorNetty.setChannelContext(ch, this.owner.currentContext());
                }
                HttpClientConfig.addStreamHandlers(ch, this.observer.then(new StreamConnectionObserver(this.owner.currentContext())), this.opsFactory, this.acceptGzip, true, this.metricsRecorder, this.proxyAddress, this.remoteAddress, this.responseTimeoutMillis, this.uriTagValue);
                if (log.isDebugEnabled()) {
                    Http2ConnectionProvider.logStreamsState(ch, Http2ConnectionProvider.http2PooledRef(this.owner.pooledRef).slot, "Stream opened");
                }
            }
        }
    }

    static final class H2CleartextCodec
    extends ChannelHandlerAdapter {
        final boolean acceptGzip;
        final Http2FrameCodec http2FrameCodec;
        final ChannelMetricsRecorder metricsRecorder;
        final ChannelOperations.OnSetup opsFactory;
        final SocketAddress proxyAddress;
        final SocketAddress remoteAddress;
        final Function<String, String> uriTagValue;

        H2CleartextCodec(Http2FrameCodec http2FrameCodec, ChannelOperations.OnSetup opsFactory, boolean acceptGzip, @Nullable ChannelMetricsRecorder metricsRecorder, @Nullable SocketAddress proxyAddress, SocketAddress remoteAddress, @Nullable Function<String, String> uriTagValue) {
            this.acceptGzip = acceptGzip;
            this.http2FrameCodec = http2FrameCodec;
            this.metricsRecorder = metricsRecorder;
            this.opsFactory = opsFactory;
            this.proxyAddress = proxyAddress;
            this.remoteAddress = remoteAddress;
            this.uriTagValue = uriTagValue;
        }

        @Override
        public void handlerAdded(ChannelHandlerContext ctx) {
            Http2MultiplexHandler http2MultiplexHandler;
            ChannelPipeline pipeline = ctx.pipeline();
            ReadTimeoutHandler responseTimeoutHandler = (ReadTimeoutHandler)pipeline.get("com.dataiku.dss.shadelibazure.reactor.left.responseTimeoutHandler");
            ConnectionObserver channelOwner = ctx.channel().attr(Http2ConnectionProvider.OWNER).get();
            Http2ConnectionProvider.DisposableAcquire owner = null;
            ConnectionObserver obs = null;
            Http2Pool.Http2PooledRef http2PooledRef = null;
            if (channelOwner instanceof Http2ConnectionProvider.DisposableAcquire) {
                owner = (Http2ConnectionProvider.DisposableAcquire)channelOwner;
                obs = owner.obs;
                http2PooledRef = Http2ConnectionProvider.http2PooledRef(owner.pooledRef);
            }
            if (responseTimeoutHandler != null) {
                pipeline.remove("com.dataiku.dss.shadelibazure.reactor.left.responseTimeoutHandler");
                http2MultiplexHandler = new Http2MultiplexHandler(H2InboundStreamHandler.INSTANCE, new H2Codec(owner, obs, this.opsFactory, this.acceptGzip, this.metricsRecorder, this.proxyAddress, this.remoteAddress, responseTimeoutHandler.getReaderIdleTimeInMillis(), this.uriTagValue));
            } else {
                http2MultiplexHandler = new Http2MultiplexHandler(H2InboundStreamHandler.INSTANCE, new H2Codec(owner, obs, this.opsFactory, this.acceptGzip, this.metricsRecorder, this.proxyAddress, this.remoteAddress, this.uriTagValue));
            }
            pipeline.addAfter(ctx.name(), "com.dataiku.dss.shadelibazure.reactor.left.httpCodec", this.http2FrameCodec).addAfter("com.dataiku.dss.shadelibazure.reactor.left.httpCodec", "com.dataiku.dss.shadelibazure.reactor.left.h2MultiplexHandler", http2MultiplexHandler);
            if (pipeline.get("com.dataiku.dss.shadelibazure.reactor.left.httpDecompressor") != null) {
                pipeline.remove("com.dataiku.dss.shadelibazure.reactor.left.httpDecompressor");
            }
            pipeline.remove("com.dataiku.dss.shadelibazure.reactor.right.reactiveBridge");
            pipeline.remove(this);
            if (http2PooledRef != null) {
                http2PooledRef.slot.initMaxConcurrentStreams();
            }
        }
    }
}

