/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.client;

import com.dataiku.dss.shadelibazure.io.netty.channel.Channel;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelHandlerContext;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelInboundHandlerAdapter;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpClientUpgradeHandler;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http2.Http2SettingsFrame;
import com.dataiku.dss.shadelibazure.reactor.netty.Connection;
import com.dataiku.dss.shadelibazure.reactor.netty.ConnectionObserver;
import com.dataiku.dss.shadelibazure.reactor.netty.ReactorNetty;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ChannelOperations;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.Http2ConnectionProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.Http2Pool;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.HttpClientConnect;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.HttpClientState;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.PrematureCloseException;
import com.dataiku.dss.shadelibazure.reactor.util.Logger;
import com.dataiku.dss.shadelibazure.reactor.util.Loggers;

final class HttpTrafficHandler
extends ChannelInboundHandlerAdapter {
    final ConnectionObserver listener;
    static final Logger log = Loggers.getLogger(HttpTrafficHandler.class);

    HttpTrafficHandler(ConnectionObserver listener) {
        this.listener = listener;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        Channel channel = ctx.channel();
        if (channel.isActive()) {
            if (ctx.pipeline().get("com.dataiku.dss.shadelibazure.reactor.left.h2MultiplexHandler") == null) {
                ctx.fireChannelActive();
            } else if (ctx.pipeline().get("com.dataiku.dss.shadelibazure.reactor.left.sslHandler") == null) {
                this.sendNewState(Connection.from(channel), ConnectionObserver.State.CONNECTED);
                ctx.flush();
                ctx.read();
            } else {
                this.sendNewState(Connection.from(channel), ConnectionObserver.State.CONNECTED);
            }
        }
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof Http2SettingsFrame) {
            ctx.channel().attr(HttpClientConnect.ENABLE_CONNECT_PROTOCOL).set((Long)((Http2SettingsFrame)msg).settings().get('\b'));
            this.sendNewState(Connection.from(ctx.channel()), ConnectionObserver.State.CONFIGURED);
            ctx.pipeline().remove("com.dataiku.dss.shadelibazure.reactor.right.reactiveBridge");
            ctx.pipeline().remove(this);
            return;
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        ConnectionObserver owner = ctx.channel().attr(Http2ConnectionProvider.OWNER).get();
        if (owner instanceof Http2ConnectionProvider.DisposableAcquire) {
            Http2Pool.Http2PooledRef http2PooledRef = Http2ConnectionProvider.http2PooledRef(((Http2ConnectionProvider.DisposableAcquire)owner).pooledRef);
            if (http2PooledRef.slot.h2cUpgradeHandlerCtx() != null && http2PooledRef.slot.http2MultiplexHandlerCtx() == null) {
                Http2ConnectionProvider.invalidate(owner);
            }
        }
        ctx.fireExceptionCaught(new PrematureCloseException("Connection prematurely closed BEFORE response"));
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        Channel channel = ctx.channel();
        if (evt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_ISSUED) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(channel, "An upgrade request was sent to the server."));
            }
        } else if (evt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_SUCCESSFUL) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(channel, "The upgrade to H2C protocol was successful."));
            }
            this.sendNewState(Connection.from(channel), HttpClientState.UPGRADE_SUCCESSFUL);
            ctx.pipeline().remove(this);
        } else if (evt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_REJECTED) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(channel, "The upgrade to H2C protocol was rejected, continue using HTTP/1.x protocol."));
            }
            this.sendNewState(Connection.from(channel), HttpClientState.UPGRADE_REJECTED);
            ctx.pipeline().remove(this);
        }
        ctx.fireUserEventTriggered(evt);
    }

    void sendNewState(Connection connection, ConnectionObserver.State state) {
        ChannelOperations ops = connection.as(ChannelOperations.class);
        if (ops != null) {
            this.listener.onStateChange(ops, state);
        } else {
            this.listener.onStateChange(connection, state);
        }
    }
}

