/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.client;

import com.dataiku.dss.shadelibazure.io.micrometer.core.instrument.Gauge;
import com.dataiku.dss.shadelibazure.io.micrometer.core.instrument.Meter;
import com.dataiku.dss.shadelibazure.io.micrometer.core.instrument.Tags;
import com.dataiku.dss.shadelibazure.reactor.netty.Metrics;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.Http2ConnectionProviderMeters;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.Http2Pool;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.shaded.reactor.pool.InstrumentedPool;
import java.net.SocketAddress;

final class MicrometerHttp2ConnectionProviderMeterRegistrar {
    private MicrometerHttp2ConnectionProviderMeterRegistrar() {
    }

    static void registerMetrics(String poolName, String id, SocketAddress remoteAddress, InstrumentedPool.PoolMetrics metrics) {
        String addressAsString = Metrics.formatSocketAddress(remoteAddress);
        Tags tags = Tags.of((String[])new String[]{Http2ConnectionProviderMeters.Http2ConnectionProviderMetersTags.ID.asString(), id, Http2ConnectionProviderMeters.Http2ConnectionProviderMetersTags.REMOTE_ADDRESS.asString(), addressAsString, Http2ConnectionProviderMeters.Http2ConnectionProviderMetersTags.NAME.asString(), poolName});
        Gauge.builder((String)Http2ConnectionProviderMeters.ACTIVE_CONNECTIONS.getName(), (Object)metrics, InstrumentedPool.PoolMetrics::acquiredSize).tags((Iterable)tags).register(Metrics.REGISTRY);
        Gauge.builder((String)Http2ConnectionProviderMeters.ACTIVE_STREAMS.getName(), (Object)metrics, poolMetrics -> ((Http2Pool)poolMetrics).activeStreams()).tags((Iterable)tags).register(Metrics.REGISTRY);
        Gauge.builder((String)Http2ConnectionProviderMeters.IDLE_CONNECTIONS.getName(), (Object)metrics, InstrumentedPool.PoolMetrics::idleSize).tags((Iterable)tags).register(Metrics.REGISTRY);
        Gauge.builder((String)Http2ConnectionProviderMeters.PENDING_STREAMS.getName(), (Object)metrics, InstrumentedPool.PoolMetrics::pendingAcquireSize).tags((Iterable)tags).register(Metrics.REGISTRY);
    }

    static void deRegisterMetrics(String poolName, String id, SocketAddress remoteAddress) {
        String addressAsString = Metrics.formatSocketAddress(remoteAddress);
        Tags tags = Tags.of((String[])new String[]{Http2ConnectionProviderMeters.Http2ConnectionProviderMetersTags.ID.asString(), id, Http2ConnectionProviderMeters.Http2ConnectionProviderMetersTags.REMOTE_ADDRESS.asString(), addressAsString, Http2ConnectionProviderMeters.Http2ConnectionProviderMetersTags.NAME.asString(), poolName});
        Metrics.REGISTRY.remove(new Meter.Id(Http2ConnectionProviderMeters.ACTIVE_CONNECTIONS.getName(), tags, null, null, Meter.Type.GAUGE));
        Metrics.REGISTRY.remove(new Meter.Id(Http2ConnectionProviderMeters.ACTIVE_STREAMS.getName(), tags, null, null, Meter.Type.GAUGE));
        Metrics.REGISTRY.remove(new Meter.Id(Http2ConnectionProviderMeters.IDLE_CONNECTIONS.getName(), tags, null, null, Meter.Type.GAUGE));
        Metrics.REGISTRY.remove(new Meter.Id(Http2ConnectionProviderMeters.PENDING_STREAMS.getName(), tags, null, null, Meter.Type.GAUGE));
    }
}

