/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.client;

import com.dataiku.dss.shadelibazure.io.micrometer.common.KeyValues;
import com.dataiku.dss.shadelibazure.io.micrometer.core.instrument.Timer;
import com.dataiku.dss.shadelibazure.io.micrometer.observation.Observation;
import com.dataiku.dss.shadelibazure.io.micrometer.observation.ObservationRegistry;
import com.dataiku.dss.shadelibazure.io.micrometer.observation.transport.RequestReplySenderContext;
import com.dataiku.dss.shadelibazure.io.netty.channel.Channel;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpRequest;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpResponse;
import com.dataiku.dss.shadelibazure.reactor.netty.Metrics;
import com.dataiku.dss.shadelibazure.reactor.netty.ReactorNetty;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.AbstractHttpClientMetricsHandler;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.HttpClientMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.HttpClientObservations;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.MicrometerHttpClientMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.observability.ReactorNettyHandlerContext;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import com.dataiku.dss.shadelibazure.reactor.util.context.ContextView;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

final class MicrometerHttpClientMetricsHandler
extends AbstractHttpClientMetricsHandler {
    final MicrometerHttpClientMetricsRecorder recorder;
    ResponseTimeHandlerContext responseTimeHandlerContext;
    Observation responseTimeObservation;
    ContextView parentContextView;

    MicrometerHttpClientMetricsHandler(MicrometerHttpClientMetricsRecorder recorder, SocketAddress remoteAddress, @Nullable SocketAddress proxyAddress, @Nullable Function<String, String> uriTagValue) {
        super(remoteAddress, proxyAddress, uriTagValue);
        this.recorder = recorder;
    }

    MicrometerHttpClientMetricsHandler(MicrometerHttpClientMetricsHandler copy) {
        super(copy);
        this.recorder = copy.recorder;
        this.responseTimeHandlerContext = copy.responseTimeHandlerContext;
        this.responseTimeObservation = copy.responseTimeObservation;
        this.parentContextView = copy.parentContextView;
    }

    @Override
    protected HttpClientMetricsRecorder recorder() {
        return this.recorder;
    }

    @Override
    protected void recordRead(Channel channel, SocketAddress address) {
        if (this.proxyAddress == null) {
            this.recorder().recordDataReceivedTime(address, this.path, this.method, this.status, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
            this.recorder().recordDataReceived(address, this.path, this.dataReceived);
        } else {
            this.recorder().recordDataReceivedTime(address, this.proxyAddress, this.path, this.method, this.status, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
            this.recorder().recordDataReceived(address, this.proxyAddress, this.path, this.dataReceived);
        }
        this.responseTimeObservation.stop();
        ReactorNetty.setChannelContext(channel, this.parentContextView);
    }

    @Override
    protected void reset() {
        super.reset();
        this.responseTimeHandlerContext = null;
        this.responseTimeObservation = null;
        this.parentContextView = null;
    }

    @Override
    protected void startRead(HttpResponse msg) {
        super.startRead(msg);
        this.responseTimeHandlerContext.setResponse(msg);
        this.responseTimeHandlerContext.status = this.status;
    }

    @Override
    protected void startWrite(HttpRequest msg, Channel channel, SocketAddress address) {
        super.startWrite(msg, channel, address);
        this.responseTimeHandlerContext = new ResponseTimeHandlerContext(this.recorder, msg, this.path, address, this.proxyAddress);
        this.responseTimeObservation = Observation.createNotStarted((String)(this.recorder.name() + ".response.time"), (Supplier)this.responseTimeHandlerContext, (ObservationRegistry)Metrics.OBSERVATION_REGISTRY);
        this.parentContextView = Metrics.updateChannelContext(channel, this.responseTimeObservation);
        this.responseTimeObservation.start();
    }

    static final class ResponseTimeHandlerContext
    extends RequestReplySenderContext<HttpRequest, HttpResponse>
    implements ReactorNettyHandlerContext,
    Supplier<Observation.Context> {
        static final String HTTP_PREFIX = "http ";
        static final String TYPE = "client";
        final String method;
        final String netPeerName;
        final String netPeerPort;
        final String path;
        final String proxyAddress;
        final MicrometerHttpClientMetricsRecorder recorder;
        String status = "UNKNOWN";

        ResponseTimeHandlerContext(MicrometerHttpClientMetricsRecorder recorder, HttpRequest request, String path, SocketAddress remoteAddress, @Nullable SocketAddress proxyAddress) {
            super((carrier, key, value) -> Objects.requireNonNull(carrier).headers().set(key, (Object)value));
            this.recorder = recorder;
            this.method = request.method().name();
            if (remoteAddress instanceof InetSocketAddress) {
                InetSocketAddress address = (InetSocketAddress)remoteAddress;
                this.netPeerName = address.getHostString();
                this.netPeerPort = address.getPort() + "";
            } else {
                this.netPeerName = remoteAddress.toString();
                this.netPeerPort = "";
            }
            this.path = path;
            this.proxyAddress = Metrics.formatSocketAddress(proxyAddress);
            this.setCarrier(request);
            this.setContextualName(HTTP_PREFIX + this.method);
        }

        @Override
        public Observation.Context get() {
            return this;
        }

        @Override
        @Nullable
        public Timer getTimer() {
            return this.recorder.getResponseTimeTimer(this.getName(), this.netPeerName + ":" + this.netPeerPort, this.proxyAddress == null ? "na" : this.proxyAddress, this.path, this.method, this.status);
        }

        public KeyValues getHighCardinalityKeyValues() {
            return KeyValues.of((String[])new String[]{HttpClientObservations.ResponseTimeHighCardinalityTags.REACTOR_NETTY_TYPE.asString(), TYPE, HttpClientObservations.ResponseTimeHighCardinalityTags.HTTP_URL.asString(), this.path, HttpClientObservations.ResponseTimeHighCardinalityTags.HTTP_STATUS_CODE.asString(), this.status, HttpClientObservations.ResponseTimeHighCardinalityTags.NET_PEER_NAME.asString(), this.netPeerName, HttpClientObservations.ResponseTimeHighCardinalityTags.NET_PEER_PORT.asString(), this.netPeerPort});
        }

        public KeyValues getLowCardinalityKeyValues() {
            return KeyValues.of((String[])new String[]{HttpClientObservations.ResponseTimeLowCardinalityTags.METHOD.asString(), this.method, HttpClientObservations.ResponseTimeLowCardinalityTags.REMOTE_ADDRESS.asString(), this.netPeerName + ":" + this.netPeerPort, HttpClientObservations.ResponseTimeLowCardinalityTags.PROXY_ADDRESS.asString(), this.proxyAddress == null ? "na" : this.proxyAddress, HttpClientObservations.ResponseTimeLowCardinalityTags.STATUS.asString(), this.status, HttpClientObservations.ResponseTimeLowCardinalityTags.URI.asString(), this.path});
        }
    }
}

