/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.client;

import com.dataiku.dss.shadelibazure.io.netty.buffer.ByteBuf;
import com.dataiku.dss.shadelibazure.io.netty.channel.Channel;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelFutureListener;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelHandlerContext;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.compression.ZlibCodecFactory;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.FullHttpResponse;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpHeaderNames;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpHeaders;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpObjectAggregator;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.LastHttpContent;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.websocketx.WebSocketClientHandshakeException;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandler;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.websocketx.extensions.compression.DeflateFrameClientExtensionHandshaker;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateClientExtensionHandshaker;
import com.dataiku.dss.shadelibazure.io.netty.util.concurrent.Future;
import com.dataiku.dss.shadelibazure.io.netty.util.concurrent.GenericFutureListener;
import com.dataiku.dss.shadelibazure.org.reactivestreams.Publisher;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Sinks;
import com.dataiku.dss.shadelibazure.reactor.netty.FutureMono;
import com.dataiku.dss.shadelibazure.reactor.netty.NettyOutbound;
import com.dataiku.dss.shadelibazure.reactor.netty.ReactorNetty;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.HttpClientOperations;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.HttpClientState;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.WebsocketClientSpec;
import com.dataiku.dss.shadelibazure.reactor.netty.http.websocket.WebsocketInbound;
import com.dataiku.dss.shadelibazure.reactor.netty.http.websocket.WebsocketOutbound;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.net.URI;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

class WebsocketClientOperations
extends HttpClientOperations
implements WebsocketInbound,
WebsocketOutbound {
    WebSocketClientHandshaker handshakerHttp11;
    final Sinks.One<WebSocketCloseStatus> onCloseState;
    final boolean proxyPing;
    volatile int closeSent;
    static final String INBOUND_CANCEL_LOG = "WebSocket client inbound receiver cancelled, closing Websocket.";
    static final AtomicIntegerFieldUpdater<WebsocketClientOperations> CLOSE_SENT = AtomicIntegerFieldUpdater.newUpdater(WebsocketClientOperations.class, "closeSent");

    WebsocketClientOperations(URI currentURI, WebsocketClientSpec websocketClientSpec, HttpClientOperations replaced) {
        super(replaced);
        this.proxyPing = websocketClientSpec.handlePing();
        this.onCloseState = Sinks.unsafe().one();
        this.initHandshaker(currentURI, websocketClientSpec);
    }

    void initHandshaker(URI currentURI, WebsocketClientSpec websocketClientSpec) {
        this.addHandlerFirst("com.dataiku.dss.shadelibazure.reactor.left.httpAggregator", new HttpObjectAggregator(8192));
        this.removeHandler("com.dataiku.dss.shadelibazure.reactor.left.httpMetricsHandler");
        if (websocketClientSpec.compress()) {
            this.requestHeaders().remove(HttpHeaderNames.ACCEPT_ENCODING);
            this.removeHandler("com.dataiku.dss.shadelibazure.reactor.left.httpDecompressor");
            PerMessageDeflateClientExtensionHandshaker perMessageDeflateClientExtensionHandshaker = new PerMessageDeflateClientExtensionHandshaker(6, ZlibCodecFactory.isSupportingWindowSizeAndMemLevel(), 15, websocketClientSpec.compressionAllowClientNoContext(), websocketClientSpec.compressionRequestedServerNoContext(), 0);
            this.addHandlerFirst("com.dataiku.dss.shadelibazure.reactor.left.wsCompressionHandler", new WebSocketClientExtensionHandler(perMessageDeflateClientExtensionHandshaker, new DeflateFrameClientExtensionHandshaker(6, false, 0), new DeflateFrameClientExtensionHandshaker(6, true, 0)));
        }
        String subprotocols = websocketClientSpec.protocols();
        this.handshakerHttp11 = WebSocketClientHandshakerFactory.newHandshaker(currentURI, websocketClientSpec.version(), subprotocols != null && !subprotocols.isEmpty() ? subprotocols : null, true, this.requestHeaders().remove(HttpHeaderNames.HOST), websocketClientSpec.maxFramePayloadLength());
        Channel channel = this.channel();
        this.handshakerHttp11.handshake(channel).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
            this.markPersistent(false);
            channel.read();
        }));
    }

    @Override
    public HttpHeaders headers() {
        return this.responseHeaders();
    }

    @Override
    public boolean isWebsocket() {
        return true;
    }

    @Override
    @Nullable
    public String selectedSubprotocol() {
        return this.handshakerHttp11.actualSubprotocol();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInboundNext(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof FullHttpResponse) {
            this.started = true;
            this.channel().pipeline().remove(HttpObjectAggregator.class);
            FullHttpResponse response = (FullHttpResponse)msg;
            this.setNettyResponse(response);
            if (this.notRedirected(response)) {
                try {
                    this.handshakerHttp11.finishHandshake(this.channel(), response);
                    ctx.read();
                    this.listener().onStateChange(this, HttpClientState.RESPONSE_RECEIVED);
                }
                catch (Exception e) {
                    this.onInboundError(e);
                    ctx.close();
                }
                finally {
                    response.content().release();
                }
            } else {
                response.content().release();
                this.listener().onUncaughtException(this, this.redirecting);
            }
            return;
        }
        if (!this.proxyPing && msg instanceof PingWebSocketFrame) {
            ctx.writeAndFlush(new PongWebSocketFrame(((PingWebSocketFrame)msg).content()));
            ctx.read();
            return;
        }
        if (msg instanceof CloseWebSocketFrame && ((CloseWebSocketFrame)msg).isFinalFragment()) {
            CloseWebSocketFrame closeFrame;
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "CloseWebSocketFrame detected. Closing Websocket"));
            }
            if ((closeFrame = new CloseWebSocketFrame(true, ((CloseWebSocketFrame)msg).rsv(), ((CloseWebSocketFrame)msg).content())).statusCode() != -1) {
                this.sendCloseNow(closeFrame);
            } else {
                this.sendCloseNow(closeFrame, WebSocketCloseStatus.EMPTY);
            }
            this.onInboundComplete();
        } else if (msg != LastHttpContent.EMPTY_LAST_CONTENT) {
            super.onInboundNext(ctx, msg);
        }
    }

    @Override
    protected void onInboundCancel() {
        if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format(this.channel(), INBOUND_CANCEL_LOG));
        }
        this.sendCloseNow(new CloseWebSocketFrame(), WebSocketCloseStatus.ABNORMAL_CLOSURE);
    }

    @Override
    protected void onInboundClose() {
        if (this.isHandshakeComplete()) {
            this.terminate();
        } else {
            this.onInboundError(new WebSocketClientHandshakeException("Connection prematurely closed BEFORE opening handshake is complete."));
        }
    }

    boolean isHandshakeComplete() {
        return this.handshakerHttp11.isHandshakeComplete();
    }

    @Override
    protected void onOutboundComplete() {
    }

    @Override
    protected void onOutboundError(Throwable err) {
        if (this.channel().isActive()) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "Outbound error happened"), err);
            }
            this.sendCloseNow(new CloseWebSocketFrame(WebSocketCloseStatus.PROTOCOL_ERROR));
        }
    }

    @Override
    public NettyOutbound send(Publisher<? extends ByteBuf> dataStream) {
        return this.sendObject(Flux.from(dataStream).map(bytebufToWebsocketFrame));
    }

    @Override
    public Mono<Void> sendClose() {
        return this.sendClose(new CloseWebSocketFrame());
    }

    @Override
    public Mono<Void> sendClose(int rsv) {
        return this.sendClose(new CloseWebSocketFrame(true, rsv));
    }

    @Override
    public Mono<Void> sendClose(int statusCode, @Nullable String reasonText) {
        return this.sendClose(new CloseWebSocketFrame(statusCode, reasonText));
    }

    @Override
    public Mono<Void> sendClose(int rsv, int statusCode, @Nullable String reasonText) {
        return this.sendClose(new CloseWebSocketFrame(true, rsv, statusCode, reasonText));
    }

    @Override
    public Mono<WebSocketCloseStatus> receiveCloseStatus() {
        return this.onCloseState.asMono().or(this.onTerminate());
    }

    Mono<Void> sendClose(CloseWebSocketFrame frame) {
        if (CLOSE_SENT.get(this) == 0) {
            return FutureMono.deferFuture(() -> {
                if (CLOSE_SENT.getAndSet(this, 1) == 0) {
                    this.discard();
                    this.onCloseState.tryEmitValue(new WebSocketCloseStatus(frame.statusCode(), frame.reasonText()));
                    return this.channel().writeAndFlush(frame).addListener(ChannelFutureListener.CLOSE);
                }
                frame.release();
                return this.channel().newSucceededFuture();
            }).doOnCancel(() -> ReactorNetty.safeRelease(frame));
        }
        frame.release();
        return Mono.empty();
    }

    void sendCloseNow(CloseWebSocketFrame frame) {
        this.sendCloseNow(frame, new WebSocketCloseStatus(frame.statusCode(), frame.reasonText()));
    }

    void sendCloseNow(CloseWebSocketFrame frame, WebSocketCloseStatus closeStatus) {
        if (!frame.isFinalFragment()) {
            this.channel().writeAndFlush(frame);
            return;
        }
        if (CLOSE_SENT.getAndSet(this, 1) == 0) {
            this.onCloseState.tryEmitValue(closeStatus);
            this.channel().writeAndFlush(frame).addListener(ChannelFutureListener.CLOSE);
        } else {
            frame.release();
        }
    }
}

