/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.server;

import com.dataiku.dss.shadelibazure.io.netty.channel.Channel;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.AbstractHttpServerMetricsHandler;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.ContextAwareHttpServerMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.HttpServerOperations;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import com.dataiku.dss.shadelibazure.reactor.util.context.ContextView;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.function.Function;

final class ContextAwareHttpServerMetricsHandler
extends AbstractHttpServerMetricsHandler {
    final ContextAwareHttpServerMetricsRecorder recorder;

    ContextAwareHttpServerMetricsHandler(ContextAwareHttpServerMetricsRecorder recorder, @Nullable Function<String, String> methodTagValue, @Nullable Function<String, String> uriTagValue) {
        super(methodTagValue, uriTagValue);
        this.recorder = recorder;
    }

    ContextAwareHttpServerMetricsHandler(ContextAwareHttpServerMetricsHandler copy) {
        super(copy);
        this.recorder = copy.recorder;
    }

    @Override
    protected ContextAwareHttpServerMetricsRecorder recorder() {
        return this.recorder;
    }

    @Override
    protected void contextView(HttpServerOperations ops) {
        this.contextView = ops.currentContext();
    }

    @Override
    protected void recordException() {
        this.recorder().incrementErrorsCount(this.contextView, this.remoteSocketAddress, this.path);
    }

    @Override
    protected void recordRead() {
        this.recorder().recordDataReceivedTime(this.contextView, this.path, this.method, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
        this.recorder().recordDataReceived(this.contextView, this.remoteSocketAddress, this.path, this.dataReceived);
    }

    @Override
    protected void recordWrite(Channel channel) {
        this.recordWrite(this.contextView, this.dataReceivedTime, this.dataSent, this.dataSentTime, this.method, this.path, this.remoteSocketAddress, this.status);
    }

    @Override
    protected void recordWrite(Channel channel, AbstractHttpServerMetricsHandler.MetricsArgProvider metricsArgProvider) {
        this.recordWrite(metricsArgProvider.contextView, metricsArgProvider.dataReceivedTime, metricsArgProvider.dataSent, metricsArgProvider.dataSentTime, metricsArgProvider.method, metricsArgProvider.path, metricsArgProvider.remoteSocketAddress, metricsArgProvider.status);
    }

    void recordWrite(ContextView contextView, long dataReceivedTime, long dataSent, long dataSentTime, String method, String path, SocketAddress remoteSocketAddress, String status) {
        Duration dataSentTimeDuration = Duration.ofNanos(System.nanoTime() - dataSentTime);
        this.recorder().recordDataSentTime(contextView, path, method, status, dataSentTimeDuration);
        if (dataReceivedTime != 0L) {
            this.recorder().recordResponseTime(contextView, path, method, status, Duration.ofNanos(System.nanoTime() - dataReceivedTime));
        } else {
            this.recorder().recordResponseTime(contextView, path, method, status, dataSentTimeDuration);
        }
        this.recorder().recordDataSent(contextView, remoteSocketAddress, path, dataSent);
    }
}

